// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionEventStage's original definition in the XDR file is:
 *
 * <pre>
 * enum TransactionEventStage {
 *     // The event has happened before any one of the transactions has its
 *     // operations applied.
 *     TRANSACTION_EVENT_STAGE_BEFORE_ALL_TXS = 0,
 *     // The event has happened immediately after operations of the transaction
 *     // have been applied.
 *     TRANSACTION_EVENT_STAGE_AFTER_TX = 1,
 *     // The event has happened after every transaction had its operations
 *     // applied.
 *     TRANSACTION_EVENT_STAGE_AFTER_ALL_TXS = 2
 * };
 * </pre>
 */
public enum TransactionEventStage implements XdrElement {
  TRANSACTION_EVENT_STAGE_BEFORE_ALL_TXS(0),
  TRANSACTION_EVENT_STAGE_AFTER_TX(1),
  TRANSACTION_EVENT_STAGE_AFTER_ALL_TXS(2);

  private final int value;

  TransactionEventStage(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static TransactionEventStage decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return TRANSACTION_EVENT_STAGE_BEFORE_ALL_TXS;
      case 1:
        return TRANSACTION_EVENT_STAGE_AFTER_TX;
      case 2:
        return TRANSACTION_EVENT_STAGE_AFTER_ALL_TXS;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static TransactionEventStage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionEventStage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
