// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionMetaV4's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionMetaV4
 * {
 *     ExtensionPoint ext;
 *
 *     LedgerEntryChanges txChangesBefore;  // tx level changes before operations
 *                                          // are applied if any
 *     OperationMetaV2 operations&lt;&gt;;        // meta for each operation
 *     LedgerEntryChanges txChangesAfter;   // tx level changes after operations are
 *                                          // applied if any
 *     SorobanTransactionMetaV2&#42; sorobanMeta; // Soroban-specific meta (only for
 *                                            // Soroban transactions).
 *
 *     TransactionEvent events&lt;&gt;; // Used for transaction-level events (like fee payment)
 *     DiagnosticEvent diagnosticEvents&lt;&gt;; // Used for all diagnostic information
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionMetaV4 implements XdrElement {
  private ExtensionPoint ext;
  private LedgerEntryChanges txChangesBefore;
  private OperationMetaV2[] operations;
  private LedgerEntryChanges txChangesAfter;
  private SorobanTransactionMetaV2 sorobanMeta;
  private TransactionEvent[] events;
  private DiagnosticEvent[] diagnosticEvents;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    txChangesBefore.encode(stream);
    int operationsSize = getOperations().length;
    stream.writeInt(operationsSize);
    for (int i = 0; i < operationsSize; i++) {
      operations[i].encode(stream);
    }
    txChangesAfter.encode(stream);
    if (sorobanMeta != null) {
      stream.writeInt(1);
      sorobanMeta.encode(stream);
    } else {
      stream.writeInt(0);
    }
    int eventsSize = getEvents().length;
    stream.writeInt(eventsSize);
    for (int i = 0; i < eventsSize; i++) {
      events[i].encode(stream);
    }
    int diagnosticEventsSize = getDiagnosticEvents().length;
    stream.writeInt(diagnosticEventsSize);
    for (int i = 0; i < diagnosticEventsSize; i++) {
      diagnosticEvents[i].encode(stream);
    }
  }

  public static TransactionMetaV4 decode(XdrDataInputStream stream) throws IOException {
    TransactionMetaV4 decodedTransactionMetaV4 = new TransactionMetaV4();
    decodedTransactionMetaV4.ext = ExtensionPoint.decode(stream);
    decodedTransactionMetaV4.txChangesBefore = LedgerEntryChanges.decode(stream);
    int operationsSize = stream.readInt();
    decodedTransactionMetaV4.operations = new OperationMetaV2[operationsSize];
    for (int i = 0; i < operationsSize; i++) {
      decodedTransactionMetaV4.operations[i] = OperationMetaV2.decode(stream);
    }
    decodedTransactionMetaV4.txChangesAfter = LedgerEntryChanges.decode(stream);
    int sorobanMetaPresent = stream.readInt();
    if (sorobanMetaPresent != 0) {
      decodedTransactionMetaV4.sorobanMeta = SorobanTransactionMetaV2.decode(stream);
    }
    int eventsSize = stream.readInt();
    decodedTransactionMetaV4.events = new TransactionEvent[eventsSize];
    for (int i = 0; i < eventsSize; i++) {
      decodedTransactionMetaV4.events[i] = TransactionEvent.decode(stream);
    }
    int diagnosticEventsSize = stream.readInt();
    decodedTransactionMetaV4.diagnosticEvents = new DiagnosticEvent[diagnosticEventsSize];
    for (int i = 0; i < diagnosticEventsSize; i++) {
      decodedTransactionMetaV4.diagnosticEvents[i] = DiagnosticEvent.decode(stream);
    }
    return decodedTransactionMetaV4;
  }

  public static TransactionMetaV4 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionMetaV4 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
