// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TxSetComponent's original definition in the XDR file is:
 *
 * <pre>
 * union TxSetComponent switch (TxSetComponentType type)
 * {
 * case TXSET_COMP_TXS_MAYBE_DISCOUNTED_FEE:
 *   struct
 *   {
 *     int64&#42; baseFee;
 *     TransactionEnvelope txs&lt;&gt;;
 *   } txsMaybeDiscountedFee;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TxSetComponent implements XdrElement {
  private TxSetComponentType discriminant;
  private TxSetComponentTxsMaybeDiscountedFee txsMaybeDiscountedFee;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case TXSET_COMP_TXS_MAYBE_DISCOUNTED_FEE:
        txsMaybeDiscountedFee.encode(stream);
        break;
    }
  }

  public static TxSetComponent decode(XdrDataInputStream stream) throws IOException {
    TxSetComponent decodedTxSetComponent = new TxSetComponent();
    TxSetComponentType discriminant = TxSetComponentType.decode(stream);
    decodedTxSetComponent.setDiscriminant(discriminant);
    switch (decodedTxSetComponent.getDiscriminant()) {
      case TXSET_COMP_TXS_MAYBE_DISCOUNTED_FEE:
        decodedTxSetComponent.txsMaybeDiscountedFee =
            TxSetComponentTxsMaybeDiscountedFee.decode(stream);
        break;
    }
    return decodedTxSetComponent;
  }

  public static TxSetComponent fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TxSetComponent fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TxSetComponentTxsMaybeDiscountedFee's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *   {
   *     int64&#42; baseFee;
   *     TransactionEnvelope txs&lt;&gt;;
   *   }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TxSetComponentTxsMaybeDiscountedFee implements XdrElement {
    private Int64 baseFee;
    private TransactionEnvelope[] txs;

    public void encode(XdrDataOutputStream stream) throws IOException {
      if (baseFee != null) {
        stream.writeInt(1);
        baseFee.encode(stream);
      } else {
        stream.writeInt(0);
      }
      int txsSize = getTxs().length;
      stream.writeInt(txsSize);
      for (int i = 0; i < txsSize; i++) {
        txs[i].encode(stream);
      }
    }

    public static TxSetComponentTxsMaybeDiscountedFee decode(XdrDataInputStream stream)
        throws IOException {
      TxSetComponentTxsMaybeDiscountedFee decodedTxSetComponentTxsMaybeDiscountedFee =
          new TxSetComponentTxsMaybeDiscountedFee();
      int baseFeePresent = stream.readInt();
      if (baseFeePresent != 0) {
        decodedTxSetComponentTxsMaybeDiscountedFee.baseFee = Int64.decode(stream);
      }
      int txsSize = stream.readInt();
      decodedTxSetComponentTxsMaybeDiscountedFee.txs = new TransactionEnvelope[txsSize];
      for (int i = 0; i < txsSize; i++) {
        decodedTxSetComponentTxsMaybeDiscountedFee.txs[i] = TransactionEnvelope.decode(stream);
      }
      return decodedTxSetComponentTxsMaybeDiscountedFee;
    }

    public static TxSetComponentTxsMaybeDiscountedFee fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TxSetComponentTxsMaybeDiscountedFee fromXdrByteArray(byte[] xdr)
        throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
