/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.time.Instant;
import lombok.Generated;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimPredicateType;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public abstract class Predicate {
    public static Predicate fromXdr(ClaimPredicate xdr) {
        switch (xdr.getDiscriminant()) {
            case CLAIM_PREDICATE_UNCONDITIONAL: {
                return new Unconditional();
            }
            case CLAIM_PREDICATE_AND: {
                return new And(Predicate.fromXdr(xdr.getAndPredicates()[0]), Predicate.fromXdr(xdr.getAndPredicates()[1]));
            }
            case CLAIM_PREDICATE_OR: {
                return new Or(Predicate.fromXdr(xdr.getOrPredicates()[0]), Predicate.fromXdr(xdr.getOrPredicates()[1]));
            }
            case CLAIM_PREDICATE_NOT: {
                return new Not(Predicate.fromXdr(xdr.getNotPredicate()));
            }
            case CLAIM_PREDICATE_BEFORE_RELATIVE_TIME: {
                return new RelBefore(xdr.getRelBefore().getInt64());
            }
            case CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME: {
                return new AbsBefore(xdr.getAbsBefore().getInt64());
            }
        }
        throw new IllegalArgumentException("Unknown predicate type: " + xdr.getDiscriminant());
    }

    public abstract boolean equals(Object var1);

    public abstract ClaimPredicate toXdr();

    public static class RelBefore
    extends Predicate {
        private final Duration duration;

        public RelBefore(long secondsSinceClose) {
            this(new Duration(new Uint64(new XdrUnsignedHyperInteger(secondsSinceClose))));
        }

        public long getSecondsSinceClose() {
            return this.duration.getDuration().getUint64().getNumber().longValue();
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_RELATIVE_TIME);
            xdr.setRelBefore(new Int64(this.duration.getDuration().getUint64().getNumber().longValue()));
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelBefore)) {
                return false;
            }
            RelBefore other = (RelBefore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$duration = this.duration;
            Duration other$duration = other.duration;
            return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelBefore;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $duration = this.duration;
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            return result;
        }

        @Generated
        public RelBefore(Duration duration) {
            this.duration = duration;
        }
    }

    public static class AbsBefore
    extends Predicate {
        private final TimePoint timePoint;

        public AbsBefore(long epochSeconds) {
            this(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(epochSeconds))));
        }

        public AbsBefore(BigInteger epochSeconds) {
            this(new TimePoint(new Uint64(new XdrUnsignedHyperInteger(epochSeconds))));
        }

        public BigInteger getTimestampSeconds() {
            return this.timePoint.getTimePoint().getUint64().getNumber();
        }

        public Instant getDate() {
            BigInteger seconds = this.getTimestampSeconds();
            if (seconds.compareTo(BigInteger.valueOf(Instant.MAX.getEpochSecond())) > 0) {
                return Instant.MAX;
            }
            return Instant.ofEpochSecond(seconds.longValue());
        }

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME);
            xdr.setAbsBefore(new Int64(this.timePoint.getTimePoint().getUint64().getNumber().longValue()));
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbsBefore)) {
                return false;
            }
            AbsBefore other = (AbsBefore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TimePoint this$timePoint = this.timePoint;
            TimePoint other$timePoint = other.timePoint;
            return !(this$timePoint == null ? other$timePoint != null : !((Object)this$timePoint).equals(other$timePoint));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbsBefore;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TimePoint $timePoint = this.timePoint;
            result = result * 59 + ($timePoint == null ? 43 : ((Object)$timePoint).hashCode());
            return result;
        }

        @Generated
        public AbsBefore(TimePoint timePoint) {
            this.timePoint = timePoint;
        }
    }

    public static class And
    extends Predicate {
        private final Predicate left;
        private final Predicate right;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_AND);
            xdr.setAndPredicates(new ClaimPredicate[]{this.left.toXdr(), this.right.toXdr()});
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Predicate this$left = this.getLeft();
            Predicate other$left = other.getLeft();
            if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
                return false;
            }
            Predicate this$right = this.getRight();
            Predicate other$right = other.getRight();
            return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof And;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            Predicate $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        @Generated
        public And(Predicate left, Predicate right) {
            this.left = left;
            this.right = right;
        }

        @Generated
        public Predicate getLeft() {
            return this.left;
        }

        @Generated
        public Predicate getRight() {
            return this.right;
        }
    }

    public static class Or
    extends Predicate {
        private final Predicate left;
        private final Predicate right;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_OR);
            xdr.setOrPredicates(new ClaimPredicate[]{this.left.toXdr(), this.right.toXdr()});
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Predicate this$left = this.getLeft();
            Predicate other$left = other.getLeft();
            if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
                return false;
            }
            Predicate this$right = this.getRight();
            Predicate other$right = other.getRight();
            return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Or;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            Predicate $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        @Generated
        public Or(Predicate left, Predicate right) {
            this.left = left;
            this.right = right;
        }

        @Generated
        public Predicate getLeft() {
            return this.left;
        }

        @Generated
        public Predicate getRight() {
            return this.right;
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate inner;

        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_NOT);
            xdr.setNotPredicate(this.inner.toXdr());
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Not)) {
                return false;
            }
            Not other = (Not)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Predicate this$inner = this.getInner();
            Predicate other$inner = other.getInner();
            return !(this$inner == null ? other$inner != null : !((Object)this$inner).equals(other$inner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Not;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate $inner = this.getInner();
            result = result * 59 + ($inner == null ? 43 : $inner.hashCode());
            return result;
        }

        @Generated
        public Not(Predicate inner) {
            this.inner = inner;
        }

        @Generated
        public Predicate getInner() {
            return this.inner;
        }
    }

    public static class Unconditional
    extends Predicate {
        @Override
        public ClaimPredicate toXdr() {
            ClaimPredicate xdr = new ClaimPredicate();
            xdr.setDiscriminant(ClaimPredicateType.CLAIM_PREDICATE_UNCONDITIONAL);
            return xdr;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unconditional)) {
                return false;
            }
            Unconditional other = (Unconditional)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Unconditional;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

