/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Claimant;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class CreateClaimableBalanceOperation
extends Operation {
    @NonNull
    private final BigDecimal amount;
    @NonNull
    private final Asset asset;
    @NonNull
    private final List<Claimant> claimants;

    public static CreateClaimableBalanceOperation fromXdr(CreateClaimableBalanceOp op) {
        Asset asset = Asset.fromXdr(op.getAsset());
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        ArrayList<Claimant> claimants = new ArrayList<Claimant>();
        for (org.stellar.sdk.xdr.Claimant c : op.getClaimants()) {
            claimants.add(new Claimant(StrKey.encodeEd25519PublicKey(c.getV0().getDestination().getAccountID().getEd25519().getUint256()), Predicate.fromXdr(c.getV0().getPredicate())));
        }
        return new CreateClaimableBalanceOperation(amount, asset, claimants);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        CreateClaimableBalanceOp op = new CreateClaimableBalanceOp();
        op.setAsset(this.asset.toXdr());
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        org.stellar.sdk.xdr.Claimant[] xdrClaimants = new org.stellar.sdk.xdr.Claimant[this.claimants.size()];
        for (int i = 0; i < this.claimants.size(); ++i) {
            Claimant.ClaimantV0 v0 = new Claimant.ClaimantV0();
            v0.setDestination(KeyPair.fromAccountId(this.claimants.get(i).getDestination()).getXdrAccountId());
            v0.setPredicate(this.claimants.get(i).getPredicate().toXdr());
            xdrClaimants[i] = new org.stellar.sdk.xdr.Claimant();
            xdrClaimants[i].setDiscriminant(ClaimantType.CLAIMANT_TYPE_V0);
            xdrClaimants[i].setV0(v0);
        }
        op.setClaimants(xdrClaimants);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_CLAIMABLE_BALANCE);
        body.setCreateClaimableBalanceOp(op);
        return body;
    }

    @Generated
    protected CreateClaimableBalanceOperation(CreateClaimableBalanceOperationBuilder<?, ?> b) {
        super(b);
        this.amount = ((CreateClaimableBalanceOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.asset = ((CreateClaimableBalanceOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.claimants = ((CreateClaimableBalanceOperationBuilder)b).claimants;
        if (this.claimants == null) {
            throw new NullPointerException("claimants is marked non-null but is null");
        }
    }

    @Generated
    public static CreateClaimableBalanceOperationBuilder<?, ?> builder() {
        return new CreateClaimableBalanceOperationBuilderImpl();
    }

    @Generated
    public CreateClaimableBalanceOperationBuilder<?, ?> toBuilder() {
        return new CreateClaimableBalanceOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public List<Claimant> getClaimants() {
        return this.claimants;
    }

    @Generated
    public String toString() {
        return "CreateClaimableBalanceOperation(super=" + super.toString() + ", amount=" + this.getAmount() + ", asset=" + this.getAsset() + ", claimants=" + this.getClaimants() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateClaimableBalanceOperation)) {
            return false;
        }
        CreateClaimableBalanceOperation other = (CreateClaimableBalanceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        List<Claimant> this$claimants = this.getClaimants();
        List<Claimant> other$claimants = other.getClaimants();
        return !(this$claimants == null ? other$claimants != null : !((Object)this$claimants).equals(other$claimants));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateClaimableBalanceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        List<Claimant> $claimants = this.getClaimants();
        result = result * 59 + ($claimants == null ? 43 : ((Object)$claimants).hashCode());
        return result;
    }

    @Generated
    private CreateClaimableBalanceOperation(@NonNull BigDecimal amount, @NonNull Asset asset, @NonNull List<Claimant> claimants) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (claimants == null) {
            throw new NullPointerException("claimants is marked non-null but is null");
        }
        this.amount = amount;
        this.asset = asset;
        this.claimants = claimants;
    }

    public static abstract class CreateClaimableBalanceOperationBuilder<C extends CreateClaimableBalanceOperation, B extends CreateClaimableBalanceOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private BigDecimal amount;
        @Generated
        private Asset asset;
        @Generated
        private List<Claimant> claimants;

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateClaimableBalanceOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CreateClaimableBalanceOperation instance, CreateClaimableBalanceOperationBuilder<?, ?> b) {
            b.amount(instance.amount);
            b.asset(instance.asset);
            b.claimants(instance.claimants);
        }

        @Generated
        public B asset(@NonNull Asset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Generated
        public B claimants(@NonNull List<Claimant> claimants) {
            if (claimants == null) {
                throw new NullPointerException("claimants is marked non-null but is null");
            }
            this.claimants = claimants;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateClaimableBalanceOperation.CreateClaimableBalanceOperationBuilder(super=" + super.toString() + ", amount=" + this.amount + ", asset=" + this.asset + ", claimants=" + this.claimants + ")";
        }
    }

    private static final class CreateClaimableBalanceOperationBuilderImpl
    extends CreateClaimableBalanceOperationBuilder<CreateClaimableBalanceOperation, CreateClaimableBalanceOperationBuilderImpl> {
        @Override
        public CreateClaimableBalanceOperation build() {
            CreateClaimableBalanceOperation op = new CreateClaimableBalanceOperation(this);
            if (op.claimants.isEmpty()) {
                throw new IllegalArgumentException("claimants cannot be empty");
            }
            return op;
        }

        @Generated
        private CreateClaimableBalanceOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateClaimableBalanceOperationBuilderImpl self() {
            return this;
        }
    }
}

