/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountEntryExtensionV3;
import org.stellar.sdk.xdr.SponsorshipDescriptor;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntryExtensionV2
implements XdrElement {
    private Uint32 numSponsored;
    private Uint32 numSponsoring;
    private SponsorshipDescriptor[] signerSponsoringIDs;
    private AccountEntryExtensionV2Ext ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.numSponsored.encode(stream);
        this.numSponsoring.encode(stream);
        int signerSponsoringIDsSize = this.getSignerSponsoringIDs().length;
        stream.writeInt(signerSponsoringIDsSize);
        for (int i = 0; i < signerSponsoringIDsSize; ++i) {
            this.signerSponsoringIDs[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static AccountEntryExtensionV2 decode(XdrDataInputStream stream) throws IOException {
        AccountEntryExtensionV2 decodedAccountEntryExtensionV2 = new AccountEntryExtensionV2();
        decodedAccountEntryExtensionV2.numSponsored = Uint32.decode(stream);
        decodedAccountEntryExtensionV2.numSponsoring = Uint32.decode(stream);
        int signerSponsoringIDsSize = stream.readInt();
        decodedAccountEntryExtensionV2.signerSponsoringIDs = new SponsorshipDescriptor[signerSponsoringIDsSize];
        for (int i = 0; i < signerSponsoringIDsSize; ++i) {
            decodedAccountEntryExtensionV2.signerSponsoringIDs[i] = SponsorshipDescriptor.decode(stream);
        }
        decodedAccountEntryExtensionV2.ext = AccountEntryExtensionV2Ext.decode(stream);
        return decodedAccountEntryExtensionV2;
    }

    public static AccountEntryExtensionV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntryExtensionV2.fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntryExtensionV2.decode(xdrDataInputStream);
    }

    @Generated
    public static AccountEntryExtensionV2Builder builder() {
        return new AccountEntryExtensionV2Builder();
    }

    @Generated
    public AccountEntryExtensionV2Builder toBuilder() {
        return new AccountEntryExtensionV2Builder().numSponsored(this.numSponsored).numSponsoring(this.numSponsoring).signerSponsoringIDs(this.signerSponsoringIDs).ext(this.ext);
    }

    @Generated
    public Uint32 getNumSponsored() {
        return this.numSponsored;
    }

    @Generated
    public Uint32 getNumSponsoring() {
        return this.numSponsoring;
    }

    @Generated
    public SponsorshipDescriptor[] getSignerSponsoringIDs() {
        return this.signerSponsoringIDs;
    }

    @Generated
    public AccountEntryExtensionV2Ext getExt() {
        return this.ext;
    }

    @Generated
    public void setNumSponsored(Uint32 numSponsored) {
        this.numSponsored = numSponsored;
    }

    @Generated
    public void setNumSponsoring(Uint32 numSponsoring) {
        this.numSponsoring = numSponsoring;
    }

    @Generated
    public void setSignerSponsoringIDs(SponsorshipDescriptor[] signerSponsoringIDs) {
        this.signerSponsoringIDs = signerSponsoringIDs;
    }

    @Generated
    public void setExt(AccountEntryExtensionV2Ext ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountEntryExtensionV2)) {
            return false;
        }
        AccountEntryExtensionV2 other = (AccountEntryExtensionV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$numSponsored = this.getNumSponsored();
        Uint32 other$numSponsored = other.getNumSponsored();
        if (this$numSponsored == null ? other$numSponsored != null : !((Object)this$numSponsored).equals(other$numSponsored)) {
            return false;
        }
        Uint32 this$numSponsoring = this.getNumSponsoring();
        Uint32 other$numSponsoring = other.getNumSponsoring();
        if (this$numSponsoring == null ? other$numSponsoring != null : !((Object)this$numSponsoring).equals(other$numSponsoring)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSignerSponsoringIDs(), other.getSignerSponsoringIDs())) {
            return false;
        }
        AccountEntryExtensionV2Ext this$ext = this.getExt();
        AccountEntryExtensionV2Ext other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountEntryExtensionV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $numSponsored = this.getNumSponsored();
        result = result * 59 + ($numSponsored == null ? 43 : ((Object)$numSponsored).hashCode());
        Uint32 $numSponsoring = this.getNumSponsoring();
        result = result * 59 + ($numSponsoring == null ? 43 : ((Object)$numSponsoring).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSignerSponsoringIDs());
        AccountEntryExtensionV2Ext $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountEntryExtensionV2(numSponsored=" + this.getNumSponsored() + ", numSponsoring=" + this.getNumSponsoring() + ", signerSponsoringIDs=" + Arrays.deepToString(this.getSignerSponsoringIDs()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public AccountEntryExtensionV2() {
    }

    @Generated
    public AccountEntryExtensionV2(Uint32 numSponsored, Uint32 numSponsoring, SponsorshipDescriptor[] signerSponsoringIDs, AccountEntryExtensionV2Ext ext) {
        this.numSponsored = numSponsored;
        this.numSponsoring = numSponsoring;
        this.signerSponsoringIDs = signerSponsoringIDs;
        this.ext = ext;
    }

    @Generated
    public static class AccountEntryExtensionV2Builder {
        @Generated
        private Uint32 numSponsored;
        @Generated
        private Uint32 numSponsoring;
        @Generated
        private SponsorshipDescriptor[] signerSponsoringIDs;
        @Generated
        private AccountEntryExtensionV2Ext ext;

        @Generated
        AccountEntryExtensionV2Builder() {
        }

        @Generated
        public AccountEntryExtensionV2Builder numSponsored(Uint32 numSponsored) {
            this.numSponsored = numSponsored;
            return this;
        }

        @Generated
        public AccountEntryExtensionV2Builder numSponsoring(Uint32 numSponsoring) {
            this.numSponsoring = numSponsoring;
            return this;
        }

        @Generated
        public AccountEntryExtensionV2Builder signerSponsoringIDs(SponsorshipDescriptor[] signerSponsoringIDs) {
            this.signerSponsoringIDs = signerSponsoringIDs;
            return this;
        }

        @Generated
        public AccountEntryExtensionV2Builder ext(AccountEntryExtensionV2Ext ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public AccountEntryExtensionV2 build() {
            return new AccountEntryExtensionV2(this.numSponsored, this.numSponsoring, this.signerSponsoringIDs, this.ext);
        }

        @Generated
        public String toString() {
            return "AccountEntryExtensionV2.AccountEntryExtensionV2Builder(numSponsored=" + this.numSponsored + ", numSponsoring=" + this.numSponsoring + ", signerSponsoringIDs=" + Arrays.deepToString(this.signerSponsoringIDs) + ", ext=" + this.ext + ")";
        }
    }

    public static class AccountEntryExtensionV2Ext
    implements XdrElement {
        private Integer discriminant;
        private AccountEntryExtensionV3 v3;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 3: {
                    this.v3.encode(stream);
                }
            }
        }

        public static AccountEntryExtensionV2Ext decode(XdrDataInputStream stream) throws IOException {
            AccountEntryExtensionV2Ext decodedAccountEntryExtensionV2Ext = new AccountEntryExtensionV2Ext();
            Integer discriminant = stream.readInt();
            decodedAccountEntryExtensionV2Ext.setDiscriminant(discriminant);
            switch (decodedAccountEntryExtensionV2Ext.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 3: {
                    decodedAccountEntryExtensionV2Ext.v3 = AccountEntryExtensionV3.decode(stream);
                }
            }
            return decodedAccountEntryExtensionV2Ext;
        }

        public static AccountEntryExtensionV2Ext fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AccountEntryExtensionV2Ext.fromXdrByteArray(bytes);
        }

        public static AccountEntryExtensionV2Ext fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AccountEntryExtensionV2Ext.decode(xdrDataInputStream);
        }

        @Generated
        public static AccountEntryExtensionV2ExtBuilder builder() {
            return new AccountEntryExtensionV2ExtBuilder();
        }

        @Generated
        public AccountEntryExtensionV2ExtBuilder toBuilder() {
            return new AccountEntryExtensionV2ExtBuilder().discriminant(this.discriminant).v3(this.v3);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public AccountEntryExtensionV3 getV3() {
            return this.v3;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV3(AccountEntryExtensionV3 v3) {
            this.v3 = v3;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountEntryExtensionV2Ext)) {
                return false;
            }
            AccountEntryExtensionV2Ext other = (AccountEntryExtensionV2Ext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            AccountEntryExtensionV3 this$v3 = this.getV3();
            AccountEntryExtensionV3 other$v3 = other.getV3();
            return !(this$v3 == null ? other$v3 != null : !((Object)this$v3).equals(other$v3));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountEntryExtensionV2Ext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            AccountEntryExtensionV3 $v3 = this.getV3();
            result = result * 59 + ($v3 == null ? 43 : ((Object)$v3).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountEntryExtensionV2.AccountEntryExtensionV2Ext(discriminant=" + this.getDiscriminant() + ", v3=" + this.getV3() + ")";
        }

        @Generated
        public AccountEntryExtensionV2Ext() {
        }

        @Generated
        public AccountEntryExtensionV2Ext(Integer discriminant, AccountEntryExtensionV3 v3) {
            this.discriminant = discriminant;
            this.v3 = v3;
        }

        @Generated
        public static class AccountEntryExtensionV2ExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private AccountEntryExtensionV3 v3;

            @Generated
            AccountEntryExtensionV2ExtBuilder() {
            }

            @Generated
            public AccountEntryExtensionV2ExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public AccountEntryExtensionV2ExtBuilder v3(AccountEntryExtensionV3 v3) {
                this.v3 = v3;
                return this;
            }

            @Generated
            public AccountEntryExtensionV2Ext build() {
                return new AccountEntryExtensionV2Ext(this.discriminant, this.v3);
            }

            @Generated
            public String toString() {
                return "AccountEntryExtensionV2.AccountEntryExtensionV2Ext.AccountEntryExtensionV2ExtBuilder(discriminant=" + this.discriminant + ", v3=" + this.v3 + ")";
            }
        }
    }
}

