/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountMergeResultCode;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountMergeResult
implements XdrElement {
    private AccountMergeResultCode discriminant;
    private Int64 sourceAccountBalance;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ACCOUNT_MERGE_SUCCESS: {
                this.sourceAccountBalance.encode(stream);
                break;
            }
        }
    }

    public static AccountMergeResult decode(XdrDataInputStream stream) throws IOException {
        AccountMergeResult decodedAccountMergeResult = new AccountMergeResult();
        AccountMergeResultCode discriminant = AccountMergeResultCode.decode(stream);
        decodedAccountMergeResult.setDiscriminant(discriminant);
        switch (decodedAccountMergeResult.getDiscriminant()) {
            case ACCOUNT_MERGE_SUCCESS: {
                decodedAccountMergeResult.sourceAccountBalance = Int64.decode(stream);
                break;
            }
        }
        return decodedAccountMergeResult;
    }

    public static AccountMergeResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountMergeResult.fromXdrByteArray(bytes);
    }

    public static AccountMergeResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountMergeResult.decode(xdrDataInputStream);
    }

    @Generated
    public static AccountMergeResultBuilder builder() {
        return new AccountMergeResultBuilder();
    }

    @Generated
    public AccountMergeResultBuilder toBuilder() {
        return new AccountMergeResultBuilder().discriminant(this.discriminant).sourceAccountBalance(this.sourceAccountBalance);
    }

    @Generated
    public AccountMergeResultCode getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Int64 getSourceAccountBalance() {
        return this.sourceAccountBalance;
    }

    @Generated
    public void setDiscriminant(AccountMergeResultCode discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setSourceAccountBalance(Int64 sourceAccountBalance) {
        this.sourceAccountBalance = sourceAccountBalance;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountMergeResult)) {
            return false;
        }
        AccountMergeResult other = (AccountMergeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountMergeResultCode this$discriminant = this.getDiscriminant();
        AccountMergeResultCode other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Int64 this$sourceAccountBalance = this.getSourceAccountBalance();
        Int64 other$sourceAccountBalance = other.getSourceAccountBalance();
        return !(this$sourceAccountBalance == null ? other$sourceAccountBalance != null : !((Object)this$sourceAccountBalance).equals(other$sourceAccountBalance));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountMergeResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountMergeResultCode $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Int64 $sourceAccountBalance = this.getSourceAccountBalance();
        result = result * 59 + ($sourceAccountBalance == null ? 43 : ((Object)$sourceAccountBalance).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountMergeResult(discriminant=" + this.getDiscriminant() + ", sourceAccountBalance=" + this.getSourceAccountBalance() + ")";
    }

    @Generated
    public AccountMergeResult() {
    }

    @Generated
    public AccountMergeResult(AccountMergeResultCode discriminant, Int64 sourceAccountBalance) {
        this.discriminant = discriminant;
        this.sourceAccountBalance = sourceAccountBalance;
    }

    @Generated
    public static class AccountMergeResultBuilder {
        @Generated
        private AccountMergeResultCode discriminant;
        @Generated
        private Int64 sourceAccountBalance;

        @Generated
        AccountMergeResultBuilder() {
        }

        @Generated
        public AccountMergeResultBuilder discriminant(AccountMergeResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public AccountMergeResultBuilder sourceAccountBalance(Int64 sourceAccountBalance) {
            this.sourceAccountBalance = sourceAccountBalance;
            return this;
        }

        @Generated
        public AccountMergeResult build() {
            return new AccountMergeResult(this.discriminant, this.sourceAccountBalance);
        }

        @Generated
        public String toString() {
            return "AccountMergeResult.AccountMergeResultBuilder(discriminant=" + this.discriminant + ", sourceAccountBalance=" + this.sourceAccountBalance + ")";
        }
    }
}

