/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ConfigSettingContractBandwidthV0;
import org.stellar.sdk.xdr.ConfigSettingContractComputeV0;
import org.stellar.sdk.xdr.ConfigSettingContractEventsV0;
import org.stellar.sdk.xdr.ConfigSettingContractExecutionLanesV0;
import org.stellar.sdk.xdr.ConfigSettingContractHistoricalDataV0;
import org.stellar.sdk.xdr.ConfigSettingContractLedgerCostExtV0;
import org.stellar.sdk.xdr.ConfigSettingContractLedgerCostV0;
import org.stellar.sdk.xdr.ConfigSettingContractParallelComputeV0;
import org.stellar.sdk.xdr.ConfigSettingID;
import org.stellar.sdk.xdr.ConfigSettingSCPTiming;
import org.stellar.sdk.xdr.ContractCostParams;
import org.stellar.sdk.xdr.EvictionIterator;
import org.stellar.sdk.xdr.StateArchivalSettings;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ConfigSettingEntry
implements XdrElement {
    private ConfigSettingID discriminant;
    private Uint32 contractMaxSizeBytes;
    private ConfigSettingContractComputeV0 contractCompute;
    private ConfigSettingContractLedgerCostV0 contractLedgerCost;
    private ConfigSettingContractHistoricalDataV0 contractHistoricalData;
    private ConfigSettingContractEventsV0 contractEvents;
    private ConfigSettingContractBandwidthV0 contractBandwidth;
    private ContractCostParams contractCostParamsCpuInsns;
    private ContractCostParams contractCostParamsMemBytes;
    private Uint32 contractDataKeySizeBytes;
    private Uint32 contractDataEntrySizeBytes;
    private StateArchivalSettings stateArchivalSettings;
    private ConfigSettingContractExecutionLanesV0 contractExecutionLanes;
    private Uint64[] liveSorobanStateSizeWindow;
    private EvictionIterator evictionIterator;
    private ConfigSettingContractParallelComputeV0 contractParallelCompute;
    private ConfigSettingContractLedgerCostExtV0 contractLedgerCostExt;
    private ConfigSettingSCPTiming contractSCPTiming;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CONFIG_SETTING_CONTRACT_MAX_SIZE_BYTES: {
                this.contractMaxSizeBytes.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COMPUTE_V0: {
                this.contractCompute.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_LEDGER_COST_V0: {
                this.contractLedgerCost.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_HISTORICAL_DATA_V0: {
                this.contractHistoricalData.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_EVENTS_V0: {
                this.contractEvents.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_BANDWIDTH_V0: {
                this.contractBandwidth.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COST_PARAMS_CPU_INSTRUCTIONS: {
                this.contractCostParamsCpuInsns.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COST_PARAMS_MEMORY_BYTES: {
                this.contractCostParamsMemBytes.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_DATA_KEY_SIZE_BYTES: {
                this.contractDataKeySizeBytes.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_DATA_ENTRY_SIZE_BYTES: {
                this.contractDataEntrySizeBytes.encode(stream);
                break;
            }
            case CONFIG_SETTING_STATE_ARCHIVAL: {
                this.stateArchivalSettings.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_EXECUTION_LANES: {
                this.contractExecutionLanes.encode(stream);
                break;
            }
            case CONFIG_SETTING_LIVE_SOROBAN_STATE_SIZE_WINDOW: {
                int liveSorobanStateSizeWindowSize = this.getLiveSorobanStateSizeWindow().length;
                stream.writeInt(liveSorobanStateSizeWindowSize);
                for (int i = 0; i < liveSorobanStateSizeWindowSize; ++i) {
                    this.liveSorobanStateSizeWindow[i].encode(stream);
                }
                break;
            }
            case CONFIG_SETTING_EVICTION_ITERATOR: {
                this.evictionIterator.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_PARALLEL_COMPUTE_V0: {
                this.contractParallelCompute.encode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_LEDGER_COST_EXT_V0: {
                this.contractLedgerCostExt.encode(stream);
                break;
            }
            case CONFIG_SETTING_SCP_TIMING: {
                this.contractSCPTiming.encode(stream);
            }
        }
    }

    public static ConfigSettingEntry decode(XdrDataInputStream stream) throws IOException {
        ConfigSettingEntry decodedConfigSettingEntry = new ConfigSettingEntry();
        ConfigSettingID discriminant = ConfigSettingID.decode(stream);
        decodedConfigSettingEntry.setDiscriminant(discriminant);
        switch (decodedConfigSettingEntry.getDiscriminant()) {
            case CONFIG_SETTING_CONTRACT_MAX_SIZE_BYTES: {
                decodedConfigSettingEntry.contractMaxSizeBytes = Uint32.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COMPUTE_V0: {
                decodedConfigSettingEntry.contractCompute = ConfigSettingContractComputeV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_LEDGER_COST_V0: {
                decodedConfigSettingEntry.contractLedgerCost = ConfigSettingContractLedgerCostV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_HISTORICAL_DATA_V0: {
                decodedConfigSettingEntry.contractHistoricalData = ConfigSettingContractHistoricalDataV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_EVENTS_V0: {
                decodedConfigSettingEntry.contractEvents = ConfigSettingContractEventsV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_BANDWIDTH_V0: {
                decodedConfigSettingEntry.contractBandwidth = ConfigSettingContractBandwidthV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COST_PARAMS_CPU_INSTRUCTIONS: {
                decodedConfigSettingEntry.contractCostParamsCpuInsns = ContractCostParams.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_COST_PARAMS_MEMORY_BYTES: {
                decodedConfigSettingEntry.contractCostParamsMemBytes = ContractCostParams.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_DATA_KEY_SIZE_BYTES: {
                decodedConfigSettingEntry.contractDataKeySizeBytes = Uint32.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_DATA_ENTRY_SIZE_BYTES: {
                decodedConfigSettingEntry.contractDataEntrySizeBytes = Uint32.decode(stream);
                break;
            }
            case CONFIG_SETTING_STATE_ARCHIVAL: {
                decodedConfigSettingEntry.stateArchivalSettings = StateArchivalSettings.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_EXECUTION_LANES: {
                decodedConfigSettingEntry.contractExecutionLanes = ConfigSettingContractExecutionLanesV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_LIVE_SOROBAN_STATE_SIZE_WINDOW: {
                int liveSorobanStateSizeWindowSize = stream.readInt();
                decodedConfigSettingEntry.liveSorobanStateSizeWindow = new Uint64[liveSorobanStateSizeWindowSize];
                for (int i = 0; i < liveSorobanStateSizeWindowSize; ++i) {
                    decodedConfigSettingEntry.liveSorobanStateSizeWindow[i] = Uint64.decode(stream);
                }
                break;
            }
            case CONFIG_SETTING_EVICTION_ITERATOR: {
                decodedConfigSettingEntry.evictionIterator = EvictionIterator.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_PARALLEL_COMPUTE_V0: {
                decodedConfigSettingEntry.contractParallelCompute = ConfigSettingContractParallelComputeV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_CONTRACT_LEDGER_COST_EXT_V0: {
                decodedConfigSettingEntry.contractLedgerCostExt = ConfigSettingContractLedgerCostExtV0.decode(stream);
                break;
            }
            case CONFIG_SETTING_SCP_TIMING: {
                decodedConfigSettingEntry.contractSCPTiming = ConfigSettingSCPTiming.decode(stream);
            }
        }
        return decodedConfigSettingEntry;
    }

    public static ConfigSettingEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ConfigSettingEntry.fromXdrByteArray(bytes);
    }

    public static ConfigSettingEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ConfigSettingEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static ConfigSettingEntryBuilder builder() {
        return new ConfigSettingEntryBuilder();
    }

    @Generated
    public ConfigSettingEntryBuilder toBuilder() {
        return new ConfigSettingEntryBuilder().discriminant(this.discriminant).contractMaxSizeBytes(this.contractMaxSizeBytes).contractCompute(this.contractCompute).contractLedgerCost(this.contractLedgerCost).contractHistoricalData(this.contractHistoricalData).contractEvents(this.contractEvents).contractBandwidth(this.contractBandwidth).contractCostParamsCpuInsns(this.contractCostParamsCpuInsns).contractCostParamsMemBytes(this.contractCostParamsMemBytes).contractDataKeySizeBytes(this.contractDataKeySizeBytes).contractDataEntrySizeBytes(this.contractDataEntrySizeBytes).stateArchivalSettings(this.stateArchivalSettings).contractExecutionLanes(this.contractExecutionLanes).liveSorobanStateSizeWindow(this.liveSorobanStateSizeWindow).evictionIterator(this.evictionIterator).contractParallelCompute(this.contractParallelCompute).contractLedgerCostExt(this.contractLedgerCostExt).contractSCPTiming(this.contractSCPTiming);
    }

    @Generated
    public ConfigSettingID getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint32 getContractMaxSizeBytes() {
        return this.contractMaxSizeBytes;
    }

    @Generated
    public ConfigSettingContractComputeV0 getContractCompute() {
        return this.contractCompute;
    }

    @Generated
    public ConfigSettingContractLedgerCostV0 getContractLedgerCost() {
        return this.contractLedgerCost;
    }

    @Generated
    public ConfigSettingContractHistoricalDataV0 getContractHistoricalData() {
        return this.contractHistoricalData;
    }

    @Generated
    public ConfigSettingContractEventsV0 getContractEvents() {
        return this.contractEvents;
    }

    @Generated
    public ConfigSettingContractBandwidthV0 getContractBandwidth() {
        return this.contractBandwidth;
    }

    @Generated
    public ContractCostParams getContractCostParamsCpuInsns() {
        return this.contractCostParamsCpuInsns;
    }

    @Generated
    public ContractCostParams getContractCostParamsMemBytes() {
        return this.contractCostParamsMemBytes;
    }

    @Generated
    public Uint32 getContractDataKeySizeBytes() {
        return this.contractDataKeySizeBytes;
    }

    @Generated
    public Uint32 getContractDataEntrySizeBytes() {
        return this.contractDataEntrySizeBytes;
    }

    @Generated
    public StateArchivalSettings getStateArchivalSettings() {
        return this.stateArchivalSettings;
    }

    @Generated
    public ConfigSettingContractExecutionLanesV0 getContractExecutionLanes() {
        return this.contractExecutionLanes;
    }

    @Generated
    public Uint64[] getLiveSorobanStateSizeWindow() {
        return this.liveSorobanStateSizeWindow;
    }

    @Generated
    public EvictionIterator getEvictionIterator() {
        return this.evictionIterator;
    }

    @Generated
    public ConfigSettingContractParallelComputeV0 getContractParallelCompute() {
        return this.contractParallelCompute;
    }

    @Generated
    public ConfigSettingContractLedgerCostExtV0 getContractLedgerCostExt() {
        return this.contractLedgerCostExt;
    }

    @Generated
    public ConfigSettingSCPTiming getContractSCPTiming() {
        return this.contractSCPTiming;
    }

    @Generated
    public void setDiscriminant(ConfigSettingID discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setContractMaxSizeBytes(Uint32 contractMaxSizeBytes) {
        this.contractMaxSizeBytes = contractMaxSizeBytes;
    }

    @Generated
    public void setContractCompute(ConfigSettingContractComputeV0 contractCompute) {
        this.contractCompute = contractCompute;
    }

    @Generated
    public void setContractLedgerCost(ConfigSettingContractLedgerCostV0 contractLedgerCost) {
        this.contractLedgerCost = contractLedgerCost;
    }

    @Generated
    public void setContractHistoricalData(ConfigSettingContractHistoricalDataV0 contractHistoricalData) {
        this.contractHistoricalData = contractHistoricalData;
    }

    @Generated
    public void setContractEvents(ConfigSettingContractEventsV0 contractEvents) {
        this.contractEvents = contractEvents;
    }

    @Generated
    public void setContractBandwidth(ConfigSettingContractBandwidthV0 contractBandwidth) {
        this.contractBandwidth = contractBandwidth;
    }

    @Generated
    public void setContractCostParamsCpuInsns(ContractCostParams contractCostParamsCpuInsns) {
        this.contractCostParamsCpuInsns = contractCostParamsCpuInsns;
    }

    @Generated
    public void setContractCostParamsMemBytes(ContractCostParams contractCostParamsMemBytes) {
        this.contractCostParamsMemBytes = contractCostParamsMemBytes;
    }

    @Generated
    public void setContractDataKeySizeBytes(Uint32 contractDataKeySizeBytes) {
        this.contractDataKeySizeBytes = contractDataKeySizeBytes;
    }

    @Generated
    public void setContractDataEntrySizeBytes(Uint32 contractDataEntrySizeBytes) {
        this.contractDataEntrySizeBytes = contractDataEntrySizeBytes;
    }

    @Generated
    public void setStateArchivalSettings(StateArchivalSettings stateArchivalSettings) {
        this.stateArchivalSettings = stateArchivalSettings;
    }

    @Generated
    public void setContractExecutionLanes(ConfigSettingContractExecutionLanesV0 contractExecutionLanes) {
        this.contractExecutionLanes = contractExecutionLanes;
    }

    @Generated
    public void setLiveSorobanStateSizeWindow(Uint64[] liveSorobanStateSizeWindow) {
        this.liveSorobanStateSizeWindow = liveSorobanStateSizeWindow;
    }

    @Generated
    public void setEvictionIterator(EvictionIterator evictionIterator) {
        this.evictionIterator = evictionIterator;
    }

    @Generated
    public void setContractParallelCompute(ConfigSettingContractParallelComputeV0 contractParallelCompute) {
        this.contractParallelCompute = contractParallelCompute;
    }

    @Generated
    public void setContractLedgerCostExt(ConfigSettingContractLedgerCostExtV0 contractLedgerCostExt) {
        this.contractLedgerCostExt = contractLedgerCostExt;
    }

    @Generated
    public void setContractSCPTiming(ConfigSettingSCPTiming contractSCPTiming) {
        this.contractSCPTiming = contractSCPTiming;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigSettingEntry)) {
            return false;
        }
        ConfigSettingEntry other = (ConfigSettingEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigSettingID this$discriminant = this.getDiscriminant();
        ConfigSettingID other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint32 this$contractMaxSizeBytes = this.getContractMaxSizeBytes();
        Uint32 other$contractMaxSizeBytes = other.getContractMaxSizeBytes();
        if (this$contractMaxSizeBytes == null ? other$contractMaxSizeBytes != null : !((Object)this$contractMaxSizeBytes).equals(other$contractMaxSizeBytes)) {
            return false;
        }
        ConfigSettingContractComputeV0 this$contractCompute = this.getContractCompute();
        ConfigSettingContractComputeV0 other$contractCompute = other.getContractCompute();
        if (this$contractCompute == null ? other$contractCompute != null : !((Object)this$contractCompute).equals(other$contractCompute)) {
            return false;
        }
        ConfigSettingContractLedgerCostV0 this$contractLedgerCost = this.getContractLedgerCost();
        ConfigSettingContractLedgerCostV0 other$contractLedgerCost = other.getContractLedgerCost();
        if (this$contractLedgerCost == null ? other$contractLedgerCost != null : !((Object)this$contractLedgerCost).equals(other$contractLedgerCost)) {
            return false;
        }
        ConfigSettingContractHistoricalDataV0 this$contractHistoricalData = this.getContractHistoricalData();
        ConfigSettingContractHistoricalDataV0 other$contractHistoricalData = other.getContractHistoricalData();
        if (this$contractHistoricalData == null ? other$contractHistoricalData != null : !((Object)this$contractHistoricalData).equals(other$contractHistoricalData)) {
            return false;
        }
        ConfigSettingContractEventsV0 this$contractEvents = this.getContractEvents();
        ConfigSettingContractEventsV0 other$contractEvents = other.getContractEvents();
        if (this$contractEvents == null ? other$contractEvents != null : !((Object)this$contractEvents).equals(other$contractEvents)) {
            return false;
        }
        ConfigSettingContractBandwidthV0 this$contractBandwidth = this.getContractBandwidth();
        ConfigSettingContractBandwidthV0 other$contractBandwidth = other.getContractBandwidth();
        if (this$contractBandwidth == null ? other$contractBandwidth != null : !((Object)this$contractBandwidth).equals(other$contractBandwidth)) {
            return false;
        }
        ContractCostParams this$contractCostParamsCpuInsns = this.getContractCostParamsCpuInsns();
        ContractCostParams other$contractCostParamsCpuInsns = other.getContractCostParamsCpuInsns();
        if (this$contractCostParamsCpuInsns == null ? other$contractCostParamsCpuInsns != null : !((Object)this$contractCostParamsCpuInsns).equals(other$contractCostParamsCpuInsns)) {
            return false;
        }
        ContractCostParams this$contractCostParamsMemBytes = this.getContractCostParamsMemBytes();
        ContractCostParams other$contractCostParamsMemBytes = other.getContractCostParamsMemBytes();
        if (this$contractCostParamsMemBytes == null ? other$contractCostParamsMemBytes != null : !((Object)this$contractCostParamsMemBytes).equals(other$contractCostParamsMemBytes)) {
            return false;
        }
        Uint32 this$contractDataKeySizeBytes = this.getContractDataKeySizeBytes();
        Uint32 other$contractDataKeySizeBytes = other.getContractDataKeySizeBytes();
        if (this$contractDataKeySizeBytes == null ? other$contractDataKeySizeBytes != null : !((Object)this$contractDataKeySizeBytes).equals(other$contractDataKeySizeBytes)) {
            return false;
        }
        Uint32 this$contractDataEntrySizeBytes = this.getContractDataEntrySizeBytes();
        Uint32 other$contractDataEntrySizeBytes = other.getContractDataEntrySizeBytes();
        if (this$contractDataEntrySizeBytes == null ? other$contractDataEntrySizeBytes != null : !((Object)this$contractDataEntrySizeBytes).equals(other$contractDataEntrySizeBytes)) {
            return false;
        }
        StateArchivalSettings this$stateArchivalSettings = this.getStateArchivalSettings();
        StateArchivalSettings other$stateArchivalSettings = other.getStateArchivalSettings();
        if (this$stateArchivalSettings == null ? other$stateArchivalSettings != null : !((Object)this$stateArchivalSettings).equals(other$stateArchivalSettings)) {
            return false;
        }
        ConfigSettingContractExecutionLanesV0 this$contractExecutionLanes = this.getContractExecutionLanes();
        ConfigSettingContractExecutionLanesV0 other$contractExecutionLanes = other.getContractExecutionLanes();
        if (this$contractExecutionLanes == null ? other$contractExecutionLanes != null : !((Object)this$contractExecutionLanes).equals(other$contractExecutionLanes)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLiveSorobanStateSizeWindow(), other.getLiveSorobanStateSizeWindow())) {
            return false;
        }
        EvictionIterator this$evictionIterator = this.getEvictionIterator();
        EvictionIterator other$evictionIterator = other.getEvictionIterator();
        if (this$evictionIterator == null ? other$evictionIterator != null : !((Object)this$evictionIterator).equals(other$evictionIterator)) {
            return false;
        }
        ConfigSettingContractParallelComputeV0 this$contractParallelCompute = this.getContractParallelCompute();
        ConfigSettingContractParallelComputeV0 other$contractParallelCompute = other.getContractParallelCompute();
        if (this$contractParallelCompute == null ? other$contractParallelCompute != null : !((Object)this$contractParallelCompute).equals(other$contractParallelCompute)) {
            return false;
        }
        ConfigSettingContractLedgerCostExtV0 this$contractLedgerCostExt = this.getContractLedgerCostExt();
        ConfigSettingContractLedgerCostExtV0 other$contractLedgerCostExt = other.getContractLedgerCostExt();
        if (this$contractLedgerCostExt == null ? other$contractLedgerCostExt != null : !((Object)this$contractLedgerCostExt).equals(other$contractLedgerCostExt)) {
            return false;
        }
        ConfigSettingSCPTiming this$contractSCPTiming = this.getContractSCPTiming();
        ConfigSettingSCPTiming other$contractSCPTiming = other.getContractSCPTiming();
        return !(this$contractSCPTiming == null ? other$contractSCPTiming != null : !((Object)this$contractSCPTiming).equals(other$contractSCPTiming));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigSettingEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigSettingID $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint32 $contractMaxSizeBytes = this.getContractMaxSizeBytes();
        result = result * 59 + ($contractMaxSizeBytes == null ? 43 : ((Object)$contractMaxSizeBytes).hashCode());
        ConfigSettingContractComputeV0 $contractCompute = this.getContractCompute();
        result = result * 59 + ($contractCompute == null ? 43 : ((Object)$contractCompute).hashCode());
        ConfigSettingContractLedgerCostV0 $contractLedgerCost = this.getContractLedgerCost();
        result = result * 59 + ($contractLedgerCost == null ? 43 : ((Object)$contractLedgerCost).hashCode());
        ConfigSettingContractHistoricalDataV0 $contractHistoricalData = this.getContractHistoricalData();
        result = result * 59 + ($contractHistoricalData == null ? 43 : ((Object)$contractHistoricalData).hashCode());
        ConfigSettingContractEventsV0 $contractEvents = this.getContractEvents();
        result = result * 59 + ($contractEvents == null ? 43 : ((Object)$contractEvents).hashCode());
        ConfigSettingContractBandwidthV0 $contractBandwidth = this.getContractBandwidth();
        result = result * 59 + ($contractBandwidth == null ? 43 : ((Object)$contractBandwidth).hashCode());
        ContractCostParams $contractCostParamsCpuInsns = this.getContractCostParamsCpuInsns();
        result = result * 59 + ($contractCostParamsCpuInsns == null ? 43 : ((Object)$contractCostParamsCpuInsns).hashCode());
        ContractCostParams $contractCostParamsMemBytes = this.getContractCostParamsMemBytes();
        result = result * 59 + ($contractCostParamsMemBytes == null ? 43 : ((Object)$contractCostParamsMemBytes).hashCode());
        Uint32 $contractDataKeySizeBytes = this.getContractDataKeySizeBytes();
        result = result * 59 + ($contractDataKeySizeBytes == null ? 43 : ((Object)$contractDataKeySizeBytes).hashCode());
        Uint32 $contractDataEntrySizeBytes = this.getContractDataEntrySizeBytes();
        result = result * 59 + ($contractDataEntrySizeBytes == null ? 43 : ((Object)$contractDataEntrySizeBytes).hashCode());
        StateArchivalSettings $stateArchivalSettings = this.getStateArchivalSettings();
        result = result * 59 + ($stateArchivalSettings == null ? 43 : ((Object)$stateArchivalSettings).hashCode());
        ConfigSettingContractExecutionLanesV0 $contractExecutionLanes = this.getContractExecutionLanes();
        result = result * 59 + ($contractExecutionLanes == null ? 43 : ((Object)$contractExecutionLanes).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLiveSorobanStateSizeWindow());
        EvictionIterator $evictionIterator = this.getEvictionIterator();
        result = result * 59 + ($evictionIterator == null ? 43 : ((Object)$evictionIterator).hashCode());
        ConfigSettingContractParallelComputeV0 $contractParallelCompute = this.getContractParallelCompute();
        result = result * 59 + ($contractParallelCompute == null ? 43 : ((Object)$contractParallelCompute).hashCode());
        ConfigSettingContractLedgerCostExtV0 $contractLedgerCostExt = this.getContractLedgerCostExt();
        result = result * 59 + ($contractLedgerCostExt == null ? 43 : ((Object)$contractLedgerCostExt).hashCode());
        ConfigSettingSCPTiming $contractSCPTiming = this.getContractSCPTiming();
        result = result * 59 + ($contractSCPTiming == null ? 43 : ((Object)$contractSCPTiming).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigSettingEntry(discriminant=" + this.getDiscriminant() + ", contractMaxSizeBytes=" + this.getContractMaxSizeBytes() + ", contractCompute=" + this.getContractCompute() + ", contractLedgerCost=" + this.getContractLedgerCost() + ", contractHistoricalData=" + this.getContractHistoricalData() + ", contractEvents=" + this.getContractEvents() + ", contractBandwidth=" + this.getContractBandwidth() + ", contractCostParamsCpuInsns=" + this.getContractCostParamsCpuInsns() + ", contractCostParamsMemBytes=" + this.getContractCostParamsMemBytes() + ", contractDataKeySizeBytes=" + this.getContractDataKeySizeBytes() + ", contractDataEntrySizeBytes=" + this.getContractDataEntrySizeBytes() + ", stateArchivalSettings=" + this.getStateArchivalSettings() + ", contractExecutionLanes=" + this.getContractExecutionLanes() + ", liveSorobanStateSizeWindow=" + Arrays.deepToString(this.getLiveSorobanStateSizeWindow()) + ", evictionIterator=" + this.getEvictionIterator() + ", contractParallelCompute=" + this.getContractParallelCompute() + ", contractLedgerCostExt=" + this.getContractLedgerCostExt() + ", contractSCPTiming=" + this.getContractSCPTiming() + ")";
    }

    @Generated
    public ConfigSettingEntry() {
    }

    @Generated
    public ConfigSettingEntry(ConfigSettingID discriminant, Uint32 contractMaxSizeBytes, ConfigSettingContractComputeV0 contractCompute, ConfigSettingContractLedgerCostV0 contractLedgerCost, ConfigSettingContractHistoricalDataV0 contractHistoricalData, ConfigSettingContractEventsV0 contractEvents, ConfigSettingContractBandwidthV0 contractBandwidth, ContractCostParams contractCostParamsCpuInsns, ContractCostParams contractCostParamsMemBytes, Uint32 contractDataKeySizeBytes, Uint32 contractDataEntrySizeBytes, StateArchivalSettings stateArchivalSettings, ConfigSettingContractExecutionLanesV0 contractExecutionLanes, Uint64[] liveSorobanStateSizeWindow, EvictionIterator evictionIterator, ConfigSettingContractParallelComputeV0 contractParallelCompute, ConfigSettingContractLedgerCostExtV0 contractLedgerCostExt, ConfigSettingSCPTiming contractSCPTiming) {
        this.discriminant = discriminant;
        this.contractMaxSizeBytes = contractMaxSizeBytes;
        this.contractCompute = contractCompute;
        this.contractLedgerCost = contractLedgerCost;
        this.contractHistoricalData = contractHistoricalData;
        this.contractEvents = contractEvents;
        this.contractBandwidth = contractBandwidth;
        this.contractCostParamsCpuInsns = contractCostParamsCpuInsns;
        this.contractCostParamsMemBytes = contractCostParamsMemBytes;
        this.contractDataKeySizeBytes = contractDataKeySizeBytes;
        this.contractDataEntrySizeBytes = contractDataEntrySizeBytes;
        this.stateArchivalSettings = stateArchivalSettings;
        this.contractExecutionLanes = contractExecutionLanes;
        this.liveSorobanStateSizeWindow = liveSorobanStateSizeWindow;
        this.evictionIterator = evictionIterator;
        this.contractParallelCompute = contractParallelCompute;
        this.contractLedgerCostExt = contractLedgerCostExt;
        this.contractSCPTiming = contractSCPTiming;
    }

    @Generated
    public static class ConfigSettingEntryBuilder {
        @Generated
        private ConfigSettingID discriminant;
        @Generated
        private Uint32 contractMaxSizeBytes;
        @Generated
        private ConfigSettingContractComputeV0 contractCompute;
        @Generated
        private ConfigSettingContractLedgerCostV0 contractLedgerCost;
        @Generated
        private ConfigSettingContractHistoricalDataV0 contractHistoricalData;
        @Generated
        private ConfigSettingContractEventsV0 contractEvents;
        @Generated
        private ConfigSettingContractBandwidthV0 contractBandwidth;
        @Generated
        private ContractCostParams contractCostParamsCpuInsns;
        @Generated
        private ContractCostParams contractCostParamsMemBytes;
        @Generated
        private Uint32 contractDataKeySizeBytes;
        @Generated
        private Uint32 contractDataEntrySizeBytes;
        @Generated
        private StateArchivalSettings stateArchivalSettings;
        @Generated
        private ConfigSettingContractExecutionLanesV0 contractExecutionLanes;
        @Generated
        private Uint64[] liveSorobanStateSizeWindow;
        @Generated
        private EvictionIterator evictionIterator;
        @Generated
        private ConfigSettingContractParallelComputeV0 contractParallelCompute;
        @Generated
        private ConfigSettingContractLedgerCostExtV0 contractLedgerCostExt;
        @Generated
        private ConfigSettingSCPTiming contractSCPTiming;

        @Generated
        ConfigSettingEntryBuilder() {
        }

        @Generated
        public ConfigSettingEntryBuilder discriminant(ConfigSettingID discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractMaxSizeBytes(Uint32 contractMaxSizeBytes) {
            this.contractMaxSizeBytes = contractMaxSizeBytes;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractCompute(ConfigSettingContractComputeV0 contractCompute) {
            this.contractCompute = contractCompute;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractLedgerCost(ConfigSettingContractLedgerCostV0 contractLedgerCost) {
            this.contractLedgerCost = contractLedgerCost;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractHistoricalData(ConfigSettingContractHistoricalDataV0 contractHistoricalData) {
            this.contractHistoricalData = contractHistoricalData;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractEvents(ConfigSettingContractEventsV0 contractEvents) {
            this.contractEvents = contractEvents;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractBandwidth(ConfigSettingContractBandwidthV0 contractBandwidth) {
            this.contractBandwidth = contractBandwidth;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractCostParamsCpuInsns(ContractCostParams contractCostParamsCpuInsns) {
            this.contractCostParamsCpuInsns = contractCostParamsCpuInsns;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractCostParamsMemBytes(ContractCostParams contractCostParamsMemBytes) {
            this.contractCostParamsMemBytes = contractCostParamsMemBytes;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractDataKeySizeBytes(Uint32 contractDataKeySizeBytes) {
            this.contractDataKeySizeBytes = contractDataKeySizeBytes;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractDataEntrySizeBytes(Uint32 contractDataEntrySizeBytes) {
            this.contractDataEntrySizeBytes = contractDataEntrySizeBytes;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder stateArchivalSettings(StateArchivalSettings stateArchivalSettings) {
            this.stateArchivalSettings = stateArchivalSettings;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractExecutionLanes(ConfigSettingContractExecutionLanesV0 contractExecutionLanes) {
            this.contractExecutionLanes = contractExecutionLanes;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder liveSorobanStateSizeWindow(Uint64[] liveSorobanStateSizeWindow) {
            this.liveSorobanStateSizeWindow = liveSorobanStateSizeWindow;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder evictionIterator(EvictionIterator evictionIterator) {
            this.evictionIterator = evictionIterator;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractParallelCompute(ConfigSettingContractParallelComputeV0 contractParallelCompute) {
            this.contractParallelCompute = contractParallelCompute;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractLedgerCostExt(ConfigSettingContractLedgerCostExtV0 contractLedgerCostExt) {
            this.contractLedgerCostExt = contractLedgerCostExt;
            return this;
        }

        @Generated
        public ConfigSettingEntryBuilder contractSCPTiming(ConfigSettingSCPTiming contractSCPTiming) {
            this.contractSCPTiming = contractSCPTiming;
            return this;
        }

        @Generated
        public ConfigSettingEntry build() {
            return new ConfigSettingEntry(this.discriminant, this.contractMaxSizeBytes, this.contractCompute, this.contractLedgerCost, this.contractHistoricalData, this.contractEvents, this.contractBandwidth, this.contractCostParamsCpuInsns, this.contractCostParamsMemBytes, this.contractDataKeySizeBytes, this.contractDataEntrySizeBytes, this.stateArchivalSettings, this.contractExecutionLanes, this.liveSorobanStateSizeWindow, this.evictionIterator, this.contractParallelCompute, this.contractLedgerCostExt, this.contractSCPTiming);
        }

        @Generated
        public String toString() {
            return "ConfigSettingEntry.ConfigSettingEntryBuilder(discriminant=" + this.discriminant + ", contractMaxSizeBytes=" + this.contractMaxSizeBytes + ", contractCompute=" + this.contractCompute + ", contractLedgerCost=" + this.contractLedgerCost + ", contractHistoricalData=" + this.contractHistoricalData + ", contractEvents=" + this.contractEvents + ", contractBandwidth=" + this.contractBandwidth + ", contractCostParamsCpuInsns=" + this.contractCostParamsCpuInsns + ", contractCostParamsMemBytes=" + this.contractCostParamsMemBytes + ", contractDataKeySizeBytes=" + this.contractDataKeySizeBytes + ", contractDataEntrySizeBytes=" + this.contractDataEntrySizeBytes + ", stateArchivalSettings=" + this.stateArchivalSettings + ", contractExecutionLanes=" + this.contractExecutionLanes + ", liveSorobanStateSizeWindow=" + Arrays.deepToString(this.liveSorobanStateSizeWindow) + ", evictionIterator=" + this.evictionIterator + ", contractParallelCompute=" + this.contractParallelCompute + ", contractLedgerCostExt=" + this.contractLedgerCostExt + ", contractSCPTiming=" + this.contractSCPTiming + ")";
        }
    }
}

