/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.TransactionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InnerTransactionResult
implements XdrElement {
    private Int64 feeCharged;
    private InnerTransactionResultResult result;
    private InnerTransactionResultExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.feeCharged.encode(stream);
        this.result.encode(stream);
        this.ext.encode(stream);
    }

    public static InnerTransactionResult decode(XdrDataInputStream stream) throws IOException {
        InnerTransactionResult decodedInnerTransactionResult = new InnerTransactionResult();
        decodedInnerTransactionResult.feeCharged = Int64.decode(stream);
        decodedInnerTransactionResult.result = InnerTransactionResultResult.decode(stream);
        decodedInnerTransactionResult.ext = InnerTransactionResultExt.decode(stream);
        return decodedInnerTransactionResult;
    }

    public static InnerTransactionResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InnerTransactionResult.fromXdrByteArray(bytes);
    }

    public static InnerTransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InnerTransactionResult.decode(xdrDataInputStream);
    }

    @Generated
    public static InnerTransactionResultBuilder builder() {
        return new InnerTransactionResultBuilder();
    }

    @Generated
    public InnerTransactionResultBuilder toBuilder() {
        return new InnerTransactionResultBuilder().feeCharged(this.feeCharged).result(this.result).ext(this.ext);
    }

    @Generated
    public Int64 getFeeCharged() {
        return this.feeCharged;
    }

    @Generated
    public InnerTransactionResultResult getResult() {
        return this.result;
    }

    @Generated
    public InnerTransactionResultExt getExt() {
        return this.ext;
    }

    @Generated
    public void setFeeCharged(Int64 feeCharged) {
        this.feeCharged = feeCharged;
    }

    @Generated
    public void setResult(InnerTransactionResultResult result) {
        this.result = result;
    }

    @Generated
    public void setExt(InnerTransactionResultExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InnerTransactionResult)) {
            return false;
        }
        InnerTransactionResult other = (InnerTransactionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Int64 this$feeCharged = this.getFeeCharged();
        Int64 other$feeCharged = other.getFeeCharged();
        if (this$feeCharged == null ? other$feeCharged != null : !((Object)this$feeCharged).equals(other$feeCharged)) {
            return false;
        }
        InnerTransactionResultResult this$result = this.getResult();
        InnerTransactionResultResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        InnerTransactionResultExt this$ext = this.getExt();
        InnerTransactionResultExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InnerTransactionResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Int64 $feeCharged = this.getFeeCharged();
        result = result * 59 + ($feeCharged == null ? 43 : ((Object)$feeCharged).hashCode());
        InnerTransactionResultResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        InnerTransactionResultExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InnerTransactionResult(feeCharged=" + this.getFeeCharged() + ", result=" + this.getResult() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public InnerTransactionResult() {
    }

    @Generated
    public InnerTransactionResult(Int64 feeCharged, InnerTransactionResultResult result, InnerTransactionResultExt ext) {
        this.feeCharged = feeCharged;
        this.result = result;
        this.ext = ext;
    }

    @Generated
    public static class InnerTransactionResultBuilder {
        @Generated
        private Int64 feeCharged;
        @Generated
        private InnerTransactionResultResult result;
        @Generated
        private InnerTransactionResultExt ext;

        @Generated
        InnerTransactionResultBuilder() {
        }

        @Generated
        public InnerTransactionResultBuilder feeCharged(Int64 feeCharged) {
            this.feeCharged = feeCharged;
            return this;
        }

        @Generated
        public InnerTransactionResultBuilder result(InnerTransactionResultResult result) {
            this.result = result;
            return this;
        }

        @Generated
        public InnerTransactionResultBuilder ext(InnerTransactionResultExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public InnerTransactionResult build() {
            return new InnerTransactionResult(this.feeCharged, this.result, this.ext);
        }

        @Generated
        public String toString() {
            return "InnerTransactionResult.InnerTransactionResultBuilder(feeCharged=" + this.feeCharged + ", result=" + this.result + ", ext=" + this.ext + ")";
        }
    }

    public static class InnerTransactionResultExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static InnerTransactionResultExt decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultExt decodedInnerTransactionResultExt = new InnerTransactionResultExt();
            Integer discriminant = stream.readInt();
            decodedInnerTransactionResultExt.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultExt.getDiscriminant()) {
                default: 
            }
            return decodedInnerTransactionResultExt;
        }

        public static InnerTransactionResultExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return InnerTransactionResultExt.fromXdrByteArray(bytes);
        }

        public static InnerTransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return InnerTransactionResultExt.decode(xdrDataInputStream);
        }

        @Generated
        public static InnerTransactionResultExtBuilder builder() {
            return new InnerTransactionResultExtBuilder();
        }

        @Generated
        public InnerTransactionResultExtBuilder toBuilder() {
            return new InnerTransactionResultExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerTransactionResultExt)) {
                return false;
            }
            InnerTransactionResultExt other = (InnerTransactionResultExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InnerTransactionResultExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InnerTransactionResult.InnerTransactionResultExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public InnerTransactionResultExt() {
        }

        @Generated
        public InnerTransactionResultExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class InnerTransactionResultExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            InnerTransactionResultExtBuilder() {
            }

            @Generated
            public InnerTransactionResultExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public InnerTransactionResultExt build() {
                return new InnerTransactionResultExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "InnerTransactionResult.InnerTransactionResultExt.InnerTransactionResultExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }

    public static class InnerTransactionResultResult
    implements XdrElement {
        private TransactionResultCode discriminant;
        private OperationResult[] results;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultsSize = this.getResults().length;
                    stream.writeInt(resultsSize);
                    for (int i = 0; i < resultsSize; ++i) {
                        this.results[i].encode(stream);
                    }
                    break;
                }
            }
        }

        public static InnerTransactionResultResult decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultResult decodedInnerTransactionResultResult = new InnerTransactionResultResult();
            TransactionResultCode discriminant = TransactionResultCode.decode(stream);
            decodedInnerTransactionResultResult.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultResult.getDiscriminant()) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultsSize = stream.readInt();
                    decodedInnerTransactionResultResult.results = new OperationResult[resultsSize];
                    for (int i = 0; i < resultsSize; ++i) {
                        decodedInnerTransactionResultResult.results[i] = OperationResult.decode(stream);
                    }
                    break;
                }
            }
            return decodedInnerTransactionResultResult;
        }

        public static InnerTransactionResultResult fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return InnerTransactionResultResult.fromXdrByteArray(bytes);
        }

        public static InnerTransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return InnerTransactionResultResult.decode(xdrDataInputStream);
        }

        @Generated
        public static InnerTransactionResultResultBuilder builder() {
            return new InnerTransactionResultResultBuilder();
        }

        @Generated
        public InnerTransactionResultResultBuilder toBuilder() {
            return new InnerTransactionResultResultBuilder().discriminant(this.discriminant).results(this.results);
        }

        @Generated
        public TransactionResultCode getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public OperationResult[] getResults() {
            return this.results;
        }

        @Generated
        public void setDiscriminant(TransactionResultCode discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setResults(OperationResult[] results) {
            this.results = results;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerTransactionResultResult)) {
                return false;
            }
            InnerTransactionResultResult other = (InnerTransactionResultResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TransactionResultCode this$discriminant = this.getDiscriminant();
            TransactionResultCode other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            return Arrays.deepEquals(this.getResults(), other.getResults());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InnerTransactionResultResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TransactionResultCode $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getResults());
            return result;
        }

        @Generated
        public String toString() {
            return "InnerTransactionResult.InnerTransactionResultResult(discriminant=" + this.getDiscriminant() + ", results=" + Arrays.deepToString(this.getResults()) + ")";
        }

        @Generated
        public InnerTransactionResultResult() {
        }

        @Generated
        public InnerTransactionResultResult(TransactionResultCode discriminant, OperationResult[] results) {
            this.discriminant = discriminant;
            this.results = results;
        }

        @Generated
        public static class InnerTransactionResultResultBuilder {
            @Generated
            private TransactionResultCode discriminant;
            @Generated
            private OperationResult[] results;

            @Generated
            InnerTransactionResultResultBuilder() {
            }

            @Generated
            public InnerTransactionResultResultBuilder discriminant(TransactionResultCode discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public InnerTransactionResultResultBuilder results(OperationResult[] results) {
                this.results = results;
                return this;
            }

            @Generated
            public InnerTransactionResultResult build() {
                return new InnerTransactionResultResult(this.discriminant, this.results);
            }

            @Generated
            public String toString() {
                return "InnerTransactionResult.InnerTransactionResultResult.InnerTransactionResultResultBuilder(discriminant=" + this.discriminant + ", results=" + Arrays.deepToString(this.results) + ")";
            }
        }
    }
}

