/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolEntry
implements XdrElement {
    private PoolID liquidityPoolID;
    private LiquidityPoolEntryBody body;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.liquidityPoolID.encode(stream);
        this.body.encode(stream);
    }

    public static LiquidityPoolEntry decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolEntry decodedLiquidityPoolEntry = new LiquidityPoolEntry();
        decodedLiquidityPoolEntry.liquidityPoolID = PoolID.decode(stream);
        decodedLiquidityPoolEntry.body = LiquidityPoolEntryBody.decode(stream);
        return decodedLiquidityPoolEntry;
    }

    public static LiquidityPoolEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolEntry.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static LiquidityPoolEntryBuilder builder() {
        return new LiquidityPoolEntryBuilder();
    }

    @Generated
    public LiquidityPoolEntryBuilder toBuilder() {
        return new LiquidityPoolEntryBuilder().liquidityPoolID(this.liquidityPoolID).body(this.body);
    }

    @Generated
    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    @Generated
    public LiquidityPoolEntryBody getBody() {
        return this.body;
    }

    @Generated
    public void setLiquidityPoolID(PoolID liquidityPoolID) {
        this.liquidityPoolID = liquidityPoolID;
    }

    @Generated
    public void setBody(LiquidityPoolEntryBody body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolEntry)) {
            return false;
        }
        LiquidityPoolEntry other = (LiquidityPoolEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PoolID this$liquidityPoolID = this.getLiquidityPoolID();
        PoolID other$liquidityPoolID = other.getLiquidityPoolID();
        if (this$liquidityPoolID == null ? other$liquidityPoolID != null : !((Object)this$liquidityPoolID).equals(other$liquidityPoolID)) {
            return false;
        }
        LiquidityPoolEntryBody this$body = this.getBody();
        LiquidityPoolEntryBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PoolID $liquidityPoolID = this.getLiquidityPoolID();
        result = result * 59 + ($liquidityPoolID == null ? 43 : ((Object)$liquidityPoolID).hashCode());
        LiquidityPoolEntryBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolEntry(liquidityPoolID=" + this.getLiquidityPoolID() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public LiquidityPoolEntry() {
    }

    @Generated
    public LiquidityPoolEntry(PoolID liquidityPoolID, LiquidityPoolEntryBody body) {
        this.liquidityPoolID = liquidityPoolID;
        this.body = body;
    }

    @Generated
    public static class LiquidityPoolEntryBuilder {
        @Generated
        private PoolID liquidityPoolID;
        @Generated
        private LiquidityPoolEntryBody body;

        @Generated
        LiquidityPoolEntryBuilder() {
        }

        @Generated
        public LiquidityPoolEntryBuilder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        @Generated
        public LiquidityPoolEntryBuilder body(LiquidityPoolEntryBody body) {
            this.body = body;
            return this;
        }

        @Generated
        public LiquidityPoolEntry build() {
            return new LiquidityPoolEntry(this.liquidityPoolID, this.body);
        }

        @Generated
        public String toString() {
            return "LiquidityPoolEntry.LiquidityPoolEntryBuilder(liquidityPoolID=" + this.liquidityPoolID + ", body=" + this.body + ")";
        }
    }

    public static class LiquidityPoolEntryBody
    implements XdrElement {
        private LiquidityPoolType discriminant;
        private LiquidityPoolEntryConstantProduct constantProduct;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                    this.constantProduct.encode(stream);
                }
            }
        }

        public static LiquidityPoolEntryBody decode(XdrDataInputStream stream) throws IOException {
            LiquidityPoolEntryBody decodedLiquidityPoolEntryBody = new LiquidityPoolEntryBody();
            LiquidityPoolType discriminant = LiquidityPoolType.decode(stream);
            decodedLiquidityPoolEntryBody.setDiscriminant(discriminant);
            switch (decodedLiquidityPoolEntryBody.getDiscriminant()) {
                case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                    decodedLiquidityPoolEntryBody.constantProduct = LiquidityPoolEntryConstantProduct.decode(stream);
                }
            }
            return decodedLiquidityPoolEntryBody;
        }

        public static LiquidityPoolEntryBody fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LiquidityPoolEntryBody.fromXdrByteArray(bytes);
        }

        public static LiquidityPoolEntryBody fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LiquidityPoolEntryBody.decode(xdrDataInputStream);
        }

        @Generated
        public static LiquidityPoolEntryBodyBuilder builder() {
            return new LiquidityPoolEntryBodyBuilder();
        }

        @Generated
        public LiquidityPoolEntryBodyBuilder toBuilder() {
            return new LiquidityPoolEntryBodyBuilder().discriminant(this.discriminant).constantProduct(this.constantProduct);
        }

        @Generated
        public LiquidityPoolType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public LiquidityPoolEntryConstantProduct getConstantProduct() {
            return this.constantProduct;
        }

        @Generated
        public void setDiscriminant(LiquidityPoolType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setConstantProduct(LiquidityPoolEntryConstantProduct constantProduct) {
            this.constantProduct = constantProduct;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiquidityPoolEntryBody)) {
                return false;
            }
            LiquidityPoolEntryBody other = (LiquidityPoolEntryBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LiquidityPoolType this$discriminant = this.getDiscriminant();
            LiquidityPoolType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            LiquidityPoolEntryConstantProduct this$constantProduct = this.getConstantProduct();
            LiquidityPoolEntryConstantProduct other$constantProduct = other.getConstantProduct();
            return !(this$constantProduct == null ? other$constantProduct != null : !((Object)this$constantProduct).equals(other$constantProduct));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LiquidityPoolEntryBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LiquidityPoolType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            LiquidityPoolEntryConstantProduct $constantProduct = this.getConstantProduct();
            result = result * 59 + ($constantProduct == null ? 43 : ((Object)$constantProduct).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LiquidityPoolEntry.LiquidityPoolEntryBody(discriminant=" + this.getDiscriminant() + ", constantProduct=" + this.getConstantProduct() + ")";
        }

        @Generated
        public LiquidityPoolEntryBody() {
        }

        @Generated
        public LiquidityPoolEntryBody(LiquidityPoolType discriminant, LiquidityPoolEntryConstantProduct constantProduct) {
            this.discriminant = discriminant;
            this.constantProduct = constantProduct;
        }

        @Generated
        public static class LiquidityPoolEntryBodyBuilder {
            @Generated
            private LiquidityPoolType discriminant;
            @Generated
            private LiquidityPoolEntryConstantProduct constantProduct;

            @Generated
            LiquidityPoolEntryBodyBuilder() {
            }

            @Generated
            public LiquidityPoolEntryBodyBuilder discriminant(LiquidityPoolType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public LiquidityPoolEntryBodyBuilder constantProduct(LiquidityPoolEntryConstantProduct constantProduct) {
                this.constantProduct = constantProduct;
                return this;
            }

            @Generated
            public LiquidityPoolEntryBody build() {
                return new LiquidityPoolEntryBody(this.discriminant, this.constantProduct);
            }

            @Generated
            public String toString() {
                return "LiquidityPoolEntry.LiquidityPoolEntryBody.LiquidityPoolEntryBodyBuilder(discriminant=" + this.discriminant + ", constantProduct=" + this.constantProduct + ")";
            }
        }

        public static class LiquidityPoolEntryConstantProduct
        implements XdrElement {
            private LiquidityPoolConstantProductParameters params;
            private Int64 reserveA;
            private Int64 reserveB;
            private Int64 totalPoolShares;
            private Int64 poolSharesTrustLineCount;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.params.encode(stream);
                this.reserveA.encode(stream);
                this.reserveB.encode(stream);
                this.totalPoolShares.encode(stream);
                this.poolSharesTrustLineCount.encode(stream);
            }

            public static LiquidityPoolEntryConstantProduct decode(XdrDataInputStream stream) throws IOException {
                LiquidityPoolEntryConstantProduct decodedLiquidityPoolEntryConstantProduct = new LiquidityPoolEntryConstantProduct();
                decodedLiquidityPoolEntryConstantProduct.params = LiquidityPoolConstantProductParameters.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.reserveA = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.reserveB = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.totalPoolShares = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.poolSharesTrustLineCount = Int64.decode(stream);
                return decodedLiquidityPoolEntryConstantProduct;
            }

            public static LiquidityPoolEntryConstantProduct fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return LiquidityPoolEntryConstantProduct.fromXdrByteArray(bytes);
            }

            public static LiquidityPoolEntryConstantProduct fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return LiquidityPoolEntryConstantProduct.decode(xdrDataInputStream);
            }

            @Generated
            public static LiquidityPoolEntryConstantProductBuilder builder() {
                return new LiquidityPoolEntryConstantProductBuilder();
            }

            @Generated
            public LiquidityPoolEntryConstantProductBuilder toBuilder() {
                return new LiquidityPoolEntryConstantProductBuilder().params(this.params).reserveA(this.reserveA).reserveB(this.reserveB).totalPoolShares(this.totalPoolShares).poolSharesTrustLineCount(this.poolSharesTrustLineCount);
            }

            @Generated
            public LiquidityPoolConstantProductParameters getParams() {
                return this.params;
            }

            @Generated
            public Int64 getReserveA() {
                return this.reserveA;
            }

            @Generated
            public Int64 getReserveB() {
                return this.reserveB;
            }

            @Generated
            public Int64 getTotalPoolShares() {
                return this.totalPoolShares;
            }

            @Generated
            public Int64 getPoolSharesTrustLineCount() {
                return this.poolSharesTrustLineCount;
            }

            @Generated
            public void setParams(LiquidityPoolConstantProductParameters params) {
                this.params = params;
            }

            @Generated
            public void setReserveA(Int64 reserveA) {
                this.reserveA = reserveA;
            }

            @Generated
            public void setReserveB(Int64 reserveB) {
                this.reserveB = reserveB;
            }

            @Generated
            public void setTotalPoolShares(Int64 totalPoolShares) {
                this.totalPoolShares = totalPoolShares;
            }

            @Generated
            public void setPoolSharesTrustLineCount(Int64 poolSharesTrustLineCount) {
                this.poolSharesTrustLineCount = poolSharesTrustLineCount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LiquidityPoolEntryConstantProduct)) {
                    return false;
                }
                LiquidityPoolEntryConstantProduct other = (LiquidityPoolEntryConstantProduct)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                LiquidityPoolConstantProductParameters this$params = this.getParams();
                LiquidityPoolConstantProductParameters other$params = other.getParams();
                if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                    return false;
                }
                Int64 this$reserveA = this.getReserveA();
                Int64 other$reserveA = other.getReserveA();
                if (this$reserveA == null ? other$reserveA != null : !((Object)this$reserveA).equals(other$reserveA)) {
                    return false;
                }
                Int64 this$reserveB = this.getReserveB();
                Int64 other$reserveB = other.getReserveB();
                if (this$reserveB == null ? other$reserveB != null : !((Object)this$reserveB).equals(other$reserveB)) {
                    return false;
                }
                Int64 this$totalPoolShares = this.getTotalPoolShares();
                Int64 other$totalPoolShares = other.getTotalPoolShares();
                if (this$totalPoolShares == null ? other$totalPoolShares != null : !((Object)this$totalPoolShares).equals(other$totalPoolShares)) {
                    return false;
                }
                Int64 this$poolSharesTrustLineCount = this.getPoolSharesTrustLineCount();
                Int64 other$poolSharesTrustLineCount = other.getPoolSharesTrustLineCount();
                return !(this$poolSharesTrustLineCount == null ? other$poolSharesTrustLineCount != null : !((Object)this$poolSharesTrustLineCount).equals(other$poolSharesTrustLineCount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LiquidityPoolEntryConstantProduct;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LiquidityPoolConstantProductParameters $params = this.getParams();
                result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
                Int64 $reserveA = this.getReserveA();
                result = result * 59 + ($reserveA == null ? 43 : ((Object)$reserveA).hashCode());
                Int64 $reserveB = this.getReserveB();
                result = result * 59 + ($reserveB == null ? 43 : ((Object)$reserveB).hashCode());
                Int64 $totalPoolShares = this.getTotalPoolShares();
                result = result * 59 + ($totalPoolShares == null ? 43 : ((Object)$totalPoolShares).hashCode());
                Int64 $poolSharesTrustLineCount = this.getPoolSharesTrustLineCount();
                result = result * 59 + ($poolSharesTrustLineCount == null ? 43 : ((Object)$poolSharesTrustLineCount).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "LiquidityPoolEntry.LiquidityPoolEntryBody.LiquidityPoolEntryConstantProduct(params=" + this.getParams() + ", reserveA=" + this.getReserveA() + ", reserveB=" + this.getReserveB() + ", totalPoolShares=" + this.getTotalPoolShares() + ", poolSharesTrustLineCount=" + this.getPoolSharesTrustLineCount() + ")";
            }

            @Generated
            public LiquidityPoolEntryConstantProduct() {
            }

            @Generated
            public LiquidityPoolEntryConstantProduct(LiquidityPoolConstantProductParameters params, Int64 reserveA, Int64 reserveB, Int64 totalPoolShares, Int64 poolSharesTrustLineCount) {
                this.params = params;
                this.reserveA = reserveA;
                this.reserveB = reserveB;
                this.totalPoolShares = totalPoolShares;
                this.poolSharesTrustLineCount = poolSharesTrustLineCount;
            }

            @Generated
            public static class LiquidityPoolEntryConstantProductBuilder {
                @Generated
                private LiquidityPoolConstantProductParameters params;
                @Generated
                private Int64 reserveA;
                @Generated
                private Int64 reserveB;
                @Generated
                private Int64 totalPoolShares;
                @Generated
                private Int64 poolSharesTrustLineCount;

                @Generated
                LiquidityPoolEntryConstantProductBuilder() {
                }

                @Generated
                public LiquidityPoolEntryConstantProductBuilder params(LiquidityPoolConstantProductParameters params) {
                    this.params = params;
                    return this;
                }

                @Generated
                public LiquidityPoolEntryConstantProductBuilder reserveA(Int64 reserveA) {
                    this.reserveA = reserveA;
                    return this;
                }

                @Generated
                public LiquidityPoolEntryConstantProductBuilder reserveB(Int64 reserveB) {
                    this.reserveB = reserveB;
                    return this;
                }

                @Generated
                public LiquidityPoolEntryConstantProductBuilder totalPoolShares(Int64 totalPoolShares) {
                    this.totalPoolShares = totalPoolShares;
                    return this;
                }

                @Generated
                public LiquidityPoolEntryConstantProductBuilder poolSharesTrustLineCount(Int64 poolSharesTrustLineCount) {
                    this.poolSharesTrustLineCount = poolSharesTrustLineCount;
                    return this;
                }

                @Generated
                public LiquidityPoolEntryConstantProduct build() {
                    return new LiquidityPoolEntryConstantProduct(this.params, this.reserveA, this.reserveB, this.totalPoolShares, this.poolSharesTrustLineCount);
                }

                @Generated
                public String toString() {
                    return "LiquidityPoolEntry.LiquidityPoolEntryBody.LiquidityPoolEntryConstantProduct.LiquidityPoolEntryConstantProductBuilder(params=" + this.params + ", reserveA=" + this.reserveA + ", reserveB=" + this.reserveB + ", totalPoolShares=" + this.totalPoolShares + ", poolSharesTrustLineCount=" + this.poolSharesTrustLineCount + ")";
                }
            }
        }
    }
}

