/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesOp;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceOp;
import org.stellar.sdk.xdr.ClawbackOp;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.ExtendFootprintTTLOp;
import org.stellar.sdk.xdr.InvokeHostFunctionOp;
import org.stellar.sdk.xdr.LiquidityPoolDepositOp;
import org.stellar.sdk.xdr.LiquidityPoolWithdrawOp;
import org.stellar.sdk.xdr.ManageBuyOfferOp;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.ManageSellOfferOp;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;
import org.stellar.sdk.xdr.PaymentOp;
import org.stellar.sdk.xdr.RestoreFootprintOp;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.SetTrustLineFlagsOp;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Operation
implements XdrElement {
    private MuxedAccount sourceAccount;
    private OperationBody body;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        if (this.sourceAccount != null) {
            stream.writeInt(1);
            this.sourceAccount.encode(stream);
        } else {
            stream.writeInt(0);
        }
        this.body.encode(stream);
    }

    public static Operation decode(XdrDataInputStream stream) throws IOException {
        Operation decodedOperation = new Operation();
        int sourceAccountPresent = stream.readInt();
        if (sourceAccountPresent != 0) {
            decodedOperation.sourceAccount = MuxedAccount.decode(stream);
        }
        decodedOperation.body = OperationBody.decode(stream);
        return decodedOperation;
    }

    public static Operation fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Operation.fromXdrByteArray(bytes);
    }

    public static Operation fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Operation.decode(xdrDataInputStream);
    }

    @Generated
    public static OperationBuilder builder() {
        return new OperationBuilder();
    }

    @Generated
    public OperationBuilder toBuilder() {
        return new OperationBuilder().sourceAccount(this.sourceAccount).body(this.body);
    }

    @Generated
    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public OperationBody getBody() {
        return this.body;
    }

    @Generated
    public void setSourceAccount(MuxedAccount sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    @Generated
    public void setBody(OperationBody body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MuxedAccount this$sourceAccount = this.getSourceAccount();
        MuxedAccount other$sourceAccount = other.getSourceAccount();
        if (this$sourceAccount == null ? other$sourceAccount != null : !((Object)this$sourceAccount).equals(other$sourceAccount)) {
            return false;
        }
        OperationBody this$body = this.getBody();
        OperationBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MuxedAccount $sourceAccount = this.getSourceAccount();
        result = result * 59 + ($sourceAccount == null ? 43 : ((Object)$sourceAccount).hashCode());
        OperationBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Operation(sourceAccount=" + this.getSourceAccount() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public Operation() {
    }

    @Generated
    public Operation(MuxedAccount sourceAccount, OperationBody body) {
        this.sourceAccount = sourceAccount;
        this.body = body;
    }

    @Generated
    public static class OperationBuilder {
        @Generated
        private MuxedAccount sourceAccount;
        @Generated
        private OperationBody body;

        @Generated
        OperationBuilder() {
        }

        @Generated
        public OperationBuilder sourceAccount(MuxedAccount sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        @Generated
        public OperationBuilder body(OperationBody body) {
            this.body = body;
            return this;
        }

        @Generated
        public Operation build() {
            return new Operation(this.sourceAccount, this.body);
        }

        @Generated
        public String toString() {
            return "Operation.OperationBuilder(sourceAccount=" + this.sourceAccount + ", body=" + this.body + ")";
        }
    }

    public static class OperationBody
    implements XdrElement {
        private OperationType discriminant;
        private CreateAccountOp createAccountOp;
        private PaymentOp paymentOp;
        private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
        private ManageSellOfferOp manageSellOfferOp;
        private CreatePassiveSellOfferOp createPassiveSellOfferOp;
        private SetOptionsOp setOptionsOp;
        private ChangeTrustOp changeTrustOp;
        private AllowTrustOp allowTrustOp;
        private MuxedAccount destination;
        private ManageDataOp manageDataOp;
        private BumpSequenceOp bumpSequenceOp;
        private ManageBuyOfferOp manageBuyOfferOp;
        private PathPaymentStrictSendOp pathPaymentStrictSendOp;
        private CreateClaimableBalanceOp createClaimableBalanceOp;
        private ClaimClaimableBalanceOp claimClaimableBalanceOp;
        private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
        private RevokeSponsorshipOp revokeSponsorshipOp;
        private ClawbackOp clawbackOp;
        private ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
        private SetTrustLineFlagsOp setTrustLineFlagsOp;
        private LiquidityPoolDepositOp liquidityPoolDepositOp;
        private LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;
        private InvokeHostFunctionOp invokeHostFunctionOp;
        private ExtendFootprintTTLOp extendFootprintTTLOp;
        private RestoreFootprintOp restoreFootprintOp;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case CREATE_ACCOUNT: {
                    this.createAccountOp.encode(stream);
                    break;
                }
                case PAYMENT: {
                    this.paymentOp.encode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    this.pathPaymentStrictReceiveOp.encode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    this.manageSellOfferOp.encode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    this.createPassiveSellOfferOp.encode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    this.setOptionsOp.encode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    this.changeTrustOp.encode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    this.allowTrustOp.encode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    this.destination.encode(stream);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    this.manageDataOp.encode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    this.bumpSequenceOp.encode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    this.manageBuyOfferOp.encode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    this.pathPaymentStrictSendOp.encode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    this.createClaimableBalanceOp.encode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    this.claimClaimableBalanceOp.encode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    this.beginSponsoringFutureReservesOp.encode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    this.revokeSponsorshipOp.encode(stream);
                    break;
                }
                case CLAWBACK: {
                    this.clawbackOp.encode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    this.clawbackClaimableBalanceOp.encode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    this.setTrustLineFlagsOp.encode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    this.liquidityPoolDepositOp.encode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    this.liquidityPoolWithdrawOp.encode(stream);
                    break;
                }
                case INVOKE_HOST_FUNCTION: {
                    this.invokeHostFunctionOp.encode(stream);
                    break;
                }
                case EXTEND_FOOTPRINT_TTL: {
                    this.extendFootprintTTLOp.encode(stream);
                    break;
                }
                case RESTORE_FOOTPRINT: {
                    this.restoreFootprintOp.encode(stream);
                }
            }
        }

        public static OperationBody decode(XdrDataInputStream stream) throws IOException {
            OperationBody decodedOperationBody = new OperationBody();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationBody.setDiscriminant(discriminant);
            switch (decodedOperationBody.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationBody.createAccountOp = CreateAccountOp.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationBody.paymentOp = PaymentOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationBody.pathPaymentStrictReceiveOp = PathPaymentStrictReceiveOp.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationBody.manageSellOfferOp = ManageSellOfferOp.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationBody.createPassiveSellOfferOp = CreatePassiveSellOfferOp.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationBody.setOptionsOp = SetOptionsOp.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationBody.changeTrustOp = ChangeTrustOp.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationBody.allowTrustOp = AllowTrustOp.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationBody.destination = MuxedAccount.decode(stream);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationBody.manageDataOp = ManageDataOp.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationBody.bumpSequenceOp = BumpSequenceOp.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationBody.manageBuyOfferOp = ManageBuyOfferOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationBody.pathPaymentStrictSendOp = PathPaymentStrictSendOp.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationBody.createClaimableBalanceOp = CreateClaimableBalanceOp.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationBody.claimClaimableBalanceOp = ClaimClaimableBalanceOp.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationBody.beginSponsoringFutureReservesOp = BeginSponsoringFutureReservesOp.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationBody.revokeSponsorshipOp = RevokeSponsorshipOp.decode(stream);
                    break;
                }
                case CLAWBACK: {
                    decodedOperationBody.clawbackOp = ClawbackOp.decode(stream);
                    break;
                }
                case CLAWBACK_CLAIMABLE_BALANCE: {
                    decodedOperationBody.clawbackClaimableBalanceOp = ClawbackClaimableBalanceOp.decode(stream);
                    break;
                }
                case SET_TRUST_LINE_FLAGS: {
                    decodedOperationBody.setTrustLineFlagsOp = SetTrustLineFlagsOp.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_DEPOSIT: {
                    decodedOperationBody.liquidityPoolDepositOp = LiquidityPoolDepositOp.decode(stream);
                    break;
                }
                case LIQUIDITY_POOL_WITHDRAW: {
                    decodedOperationBody.liquidityPoolWithdrawOp = LiquidityPoolWithdrawOp.decode(stream);
                    break;
                }
                case INVOKE_HOST_FUNCTION: {
                    decodedOperationBody.invokeHostFunctionOp = InvokeHostFunctionOp.decode(stream);
                    break;
                }
                case EXTEND_FOOTPRINT_TTL: {
                    decodedOperationBody.extendFootprintTTLOp = ExtendFootprintTTLOp.decode(stream);
                    break;
                }
                case RESTORE_FOOTPRINT: {
                    decodedOperationBody.restoreFootprintOp = RestoreFootprintOp.decode(stream);
                }
            }
            return decodedOperationBody;
        }

        public static OperationBody fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return OperationBody.fromXdrByteArray(bytes);
        }

        public static OperationBody fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return OperationBody.decode(xdrDataInputStream);
        }

        @Generated
        public static OperationBodyBuilder builder() {
            return new OperationBodyBuilder();
        }

        @Generated
        public OperationBodyBuilder toBuilder() {
            return new OperationBodyBuilder().discriminant(this.discriminant).createAccountOp(this.createAccountOp).paymentOp(this.paymentOp).pathPaymentStrictReceiveOp(this.pathPaymentStrictReceiveOp).manageSellOfferOp(this.manageSellOfferOp).createPassiveSellOfferOp(this.createPassiveSellOfferOp).setOptionsOp(this.setOptionsOp).changeTrustOp(this.changeTrustOp).allowTrustOp(this.allowTrustOp).destination(this.destination).manageDataOp(this.manageDataOp).bumpSequenceOp(this.bumpSequenceOp).manageBuyOfferOp(this.manageBuyOfferOp).pathPaymentStrictSendOp(this.pathPaymentStrictSendOp).createClaimableBalanceOp(this.createClaimableBalanceOp).claimClaimableBalanceOp(this.claimClaimableBalanceOp).beginSponsoringFutureReservesOp(this.beginSponsoringFutureReservesOp).revokeSponsorshipOp(this.revokeSponsorshipOp).clawbackOp(this.clawbackOp).clawbackClaimableBalanceOp(this.clawbackClaimableBalanceOp).setTrustLineFlagsOp(this.setTrustLineFlagsOp).liquidityPoolDepositOp(this.liquidityPoolDepositOp).liquidityPoolWithdrawOp(this.liquidityPoolWithdrawOp).invokeHostFunctionOp(this.invokeHostFunctionOp).extendFootprintTTLOp(this.extendFootprintTTLOp).restoreFootprintOp(this.restoreFootprintOp);
        }

        @Generated
        public OperationType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public CreateAccountOp getCreateAccountOp() {
            return this.createAccountOp;
        }

        @Generated
        public PaymentOp getPaymentOp() {
            return this.paymentOp;
        }

        @Generated
        public PathPaymentStrictReceiveOp getPathPaymentStrictReceiveOp() {
            return this.pathPaymentStrictReceiveOp;
        }

        @Generated
        public ManageSellOfferOp getManageSellOfferOp() {
            return this.manageSellOfferOp;
        }

        @Generated
        public CreatePassiveSellOfferOp getCreatePassiveSellOfferOp() {
            return this.createPassiveSellOfferOp;
        }

        @Generated
        public SetOptionsOp getSetOptionsOp() {
            return this.setOptionsOp;
        }

        @Generated
        public ChangeTrustOp getChangeTrustOp() {
            return this.changeTrustOp;
        }

        @Generated
        public AllowTrustOp getAllowTrustOp() {
            return this.allowTrustOp;
        }

        @Generated
        public MuxedAccount getDestination() {
            return this.destination;
        }

        @Generated
        public ManageDataOp getManageDataOp() {
            return this.manageDataOp;
        }

        @Generated
        public BumpSequenceOp getBumpSequenceOp() {
            return this.bumpSequenceOp;
        }

        @Generated
        public ManageBuyOfferOp getManageBuyOfferOp() {
            return this.manageBuyOfferOp;
        }

        @Generated
        public PathPaymentStrictSendOp getPathPaymentStrictSendOp() {
            return this.pathPaymentStrictSendOp;
        }

        @Generated
        public CreateClaimableBalanceOp getCreateClaimableBalanceOp() {
            return this.createClaimableBalanceOp;
        }

        @Generated
        public ClaimClaimableBalanceOp getClaimClaimableBalanceOp() {
            return this.claimClaimableBalanceOp;
        }

        @Generated
        public BeginSponsoringFutureReservesOp getBeginSponsoringFutureReservesOp() {
            return this.beginSponsoringFutureReservesOp;
        }

        @Generated
        public RevokeSponsorshipOp getRevokeSponsorshipOp() {
            return this.revokeSponsorshipOp;
        }

        @Generated
        public ClawbackOp getClawbackOp() {
            return this.clawbackOp;
        }

        @Generated
        public ClawbackClaimableBalanceOp getClawbackClaimableBalanceOp() {
            return this.clawbackClaimableBalanceOp;
        }

        @Generated
        public SetTrustLineFlagsOp getSetTrustLineFlagsOp() {
            return this.setTrustLineFlagsOp;
        }

        @Generated
        public LiquidityPoolDepositOp getLiquidityPoolDepositOp() {
            return this.liquidityPoolDepositOp;
        }

        @Generated
        public LiquidityPoolWithdrawOp getLiquidityPoolWithdrawOp() {
            return this.liquidityPoolWithdrawOp;
        }

        @Generated
        public InvokeHostFunctionOp getInvokeHostFunctionOp() {
            return this.invokeHostFunctionOp;
        }

        @Generated
        public ExtendFootprintTTLOp getExtendFootprintTTLOp() {
            return this.extendFootprintTTLOp;
        }

        @Generated
        public RestoreFootprintOp getRestoreFootprintOp() {
            return this.restoreFootprintOp;
        }

        @Generated
        public void setDiscriminant(OperationType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setCreateAccountOp(CreateAccountOp createAccountOp) {
            this.createAccountOp = createAccountOp;
        }

        @Generated
        public void setPaymentOp(PaymentOp paymentOp) {
            this.paymentOp = paymentOp;
        }

        @Generated
        public void setPathPaymentStrictReceiveOp(PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp) {
            this.pathPaymentStrictReceiveOp = pathPaymentStrictReceiveOp;
        }

        @Generated
        public void setManageSellOfferOp(ManageSellOfferOp manageSellOfferOp) {
            this.manageSellOfferOp = manageSellOfferOp;
        }

        @Generated
        public void setCreatePassiveSellOfferOp(CreatePassiveSellOfferOp createPassiveSellOfferOp) {
            this.createPassiveSellOfferOp = createPassiveSellOfferOp;
        }

        @Generated
        public void setSetOptionsOp(SetOptionsOp setOptionsOp) {
            this.setOptionsOp = setOptionsOp;
        }

        @Generated
        public void setChangeTrustOp(ChangeTrustOp changeTrustOp) {
            this.changeTrustOp = changeTrustOp;
        }

        @Generated
        public void setAllowTrustOp(AllowTrustOp allowTrustOp) {
            this.allowTrustOp = allowTrustOp;
        }

        @Generated
        public void setDestination(MuxedAccount destination) {
            this.destination = destination;
        }

        @Generated
        public void setManageDataOp(ManageDataOp manageDataOp) {
            this.manageDataOp = manageDataOp;
        }

        @Generated
        public void setBumpSequenceOp(BumpSequenceOp bumpSequenceOp) {
            this.bumpSequenceOp = bumpSequenceOp;
        }

        @Generated
        public void setManageBuyOfferOp(ManageBuyOfferOp manageBuyOfferOp) {
            this.manageBuyOfferOp = manageBuyOfferOp;
        }

        @Generated
        public void setPathPaymentStrictSendOp(PathPaymentStrictSendOp pathPaymentStrictSendOp) {
            this.pathPaymentStrictSendOp = pathPaymentStrictSendOp;
        }

        @Generated
        public void setCreateClaimableBalanceOp(CreateClaimableBalanceOp createClaimableBalanceOp) {
            this.createClaimableBalanceOp = createClaimableBalanceOp;
        }

        @Generated
        public void setClaimClaimableBalanceOp(ClaimClaimableBalanceOp claimClaimableBalanceOp) {
            this.claimClaimableBalanceOp = claimClaimableBalanceOp;
        }

        @Generated
        public void setBeginSponsoringFutureReservesOp(BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp) {
            this.beginSponsoringFutureReservesOp = beginSponsoringFutureReservesOp;
        }

        @Generated
        public void setRevokeSponsorshipOp(RevokeSponsorshipOp revokeSponsorshipOp) {
            this.revokeSponsorshipOp = revokeSponsorshipOp;
        }

        @Generated
        public void setClawbackOp(ClawbackOp clawbackOp) {
            this.clawbackOp = clawbackOp;
        }

        @Generated
        public void setClawbackClaimableBalanceOp(ClawbackClaimableBalanceOp clawbackClaimableBalanceOp) {
            this.clawbackClaimableBalanceOp = clawbackClaimableBalanceOp;
        }

        @Generated
        public void setSetTrustLineFlagsOp(SetTrustLineFlagsOp setTrustLineFlagsOp) {
            this.setTrustLineFlagsOp = setTrustLineFlagsOp;
        }

        @Generated
        public void setLiquidityPoolDepositOp(LiquidityPoolDepositOp liquidityPoolDepositOp) {
            this.liquidityPoolDepositOp = liquidityPoolDepositOp;
        }

        @Generated
        public void setLiquidityPoolWithdrawOp(LiquidityPoolWithdrawOp liquidityPoolWithdrawOp) {
            this.liquidityPoolWithdrawOp = liquidityPoolWithdrawOp;
        }

        @Generated
        public void setInvokeHostFunctionOp(InvokeHostFunctionOp invokeHostFunctionOp) {
            this.invokeHostFunctionOp = invokeHostFunctionOp;
        }

        @Generated
        public void setExtendFootprintTTLOp(ExtendFootprintTTLOp extendFootprintTTLOp) {
            this.extendFootprintTTLOp = extendFootprintTTLOp;
        }

        @Generated
        public void setRestoreFootprintOp(RestoreFootprintOp restoreFootprintOp) {
            this.restoreFootprintOp = restoreFootprintOp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationBody)) {
                return false;
            }
            OperationBody other = (OperationBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            OperationType this$discriminant = this.getDiscriminant();
            OperationType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            CreateAccountOp this$createAccountOp = this.getCreateAccountOp();
            CreateAccountOp other$createAccountOp = other.getCreateAccountOp();
            if (this$createAccountOp == null ? other$createAccountOp != null : !((Object)this$createAccountOp).equals(other$createAccountOp)) {
                return false;
            }
            PaymentOp this$paymentOp = this.getPaymentOp();
            PaymentOp other$paymentOp = other.getPaymentOp();
            if (this$paymentOp == null ? other$paymentOp != null : !((Object)this$paymentOp).equals(other$paymentOp)) {
                return false;
            }
            PathPaymentStrictReceiveOp this$pathPaymentStrictReceiveOp = this.getPathPaymentStrictReceiveOp();
            PathPaymentStrictReceiveOp other$pathPaymentStrictReceiveOp = other.getPathPaymentStrictReceiveOp();
            if (this$pathPaymentStrictReceiveOp == null ? other$pathPaymentStrictReceiveOp != null : !((Object)this$pathPaymentStrictReceiveOp).equals(other$pathPaymentStrictReceiveOp)) {
                return false;
            }
            ManageSellOfferOp this$manageSellOfferOp = this.getManageSellOfferOp();
            ManageSellOfferOp other$manageSellOfferOp = other.getManageSellOfferOp();
            if (this$manageSellOfferOp == null ? other$manageSellOfferOp != null : !((Object)this$manageSellOfferOp).equals(other$manageSellOfferOp)) {
                return false;
            }
            CreatePassiveSellOfferOp this$createPassiveSellOfferOp = this.getCreatePassiveSellOfferOp();
            CreatePassiveSellOfferOp other$createPassiveSellOfferOp = other.getCreatePassiveSellOfferOp();
            if (this$createPassiveSellOfferOp == null ? other$createPassiveSellOfferOp != null : !((Object)this$createPassiveSellOfferOp).equals(other$createPassiveSellOfferOp)) {
                return false;
            }
            SetOptionsOp this$setOptionsOp = this.getSetOptionsOp();
            SetOptionsOp other$setOptionsOp = other.getSetOptionsOp();
            if (this$setOptionsOp == null ? other$setOptionsOp != null : !((Object)this$setOptionsOp).equals(other$setOptionsOp)) {
                return false;
            }
            ChangeTrustOp this$changeTrustOp = this.getChangeTrustOp();
            ChangeTrustOp other$changeTrustOp = other.getChangeTrustOp();
            if (this$changeTrustOp == null ? other$changeTrustOp != null : !((Object)this$changeTrustOp).equals(other$changeTrustOp)) {
                return false;
            }
            AllowTrustOp this$allowTrustOp = this.getAllowTrustOp();
            AllowTrustOp other$allowTrustOp = other.getAllowTrustOp();
            if (this$allowTrustOp == null ? other$allowTrustOp != null : !((Object)this$allowTrustOp).equals(other$allowTrustOp)) {
                return false;
            }
            MuxedAccount this$destination = this.getDestination();
            MuxedAccount other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
                return false;
            }
            ManageDataOp this$manageDataOp = this.getManageDataOp();
            ManageDataOp other$manageDataOp = other.getManageDataOp();
            if (this$manageDataOp == null ? other$manageDataOp != null : !((Object)this$manageDataOp).equals(other$manageDataOp)) {
                return false;
            }
            BumpSequenceOp this$bumpSequenceOp = this.getBumpSequenceOp();
            BumpSequenceOp other$bumpSequenceOp = other.getBumpSequenceOp();
            if (this$bumpSequenceOp == null ? other$bumpSequenceOp != null : !((Object)this$bumpSequenceOp).equals(other$bumpSequenceOp)) {
                return false;
            }
            ManageBuyOfferOp this$manageBuyOfferOp = this.getManageBuyOfferOp();
            ManageBuyOfferOp other$manageBuyOfferOp = other.getManageBuyOfferOp();
            if (this$manageBuyOfferOp == null ? other$manageBuyOfferOp != null : !((Object)this$manageBuyOfferOp).equals(other$manageBuyOfferOp)) {
                return false;
            }
            PathPaymentStrictSendOp this$pathPaymentStrictSendOp = this.getPathPaymentStrictSendOp();
            PathPaymentStrictSendOp other$pathPaymentStrictSendOp = other.getPathPaymentStrictSendOp();
            if (this$pathPaymentStrictSendOp == null ? other$pathPaymentStrictSendOp != null : !((Object)this$pathPaymentStrictSendOp).equals(other$pathPaymentStrictSendOp)) {
                return false;
            }
            CreateClaimableBalanceOp this$createClaimableBalanceOp = this.getCreateClaimableBalanceOp();
            CreateClaimableBalanceOp other$createClaimableBalanceOp = other.getCreateClaimableBalanceOp();
            if (this$createClaimableBalanceOp == null ? other$createClaimableBalanceOp != null : !((Object)this$createClaimableBalanceOp).equals(other$createClaimableBalanceOp)) {
                return false;
            }
            ClaimClaimableBalanceOp this$claimClaimableBalanceOp = this.getClaimClaimableBalanceOp();
            ClaimClaimableBalanceOp other$claimClaimableBalanceOp = other.getClaimClaimableBalanceOp();
            if (this$claimClaimableBalanceOp == null ? other$claimClaimableBalanceOp != null : !((Object)this$claimClaimableBalanceOp).equals(other$claimClaimableBalanceOp)) {
                return false;
            }
            BeginSponsoringFutureReservesOp this$beginSponsoringFutureReservesOp = this.getBeginSponsoringFutureReservesOp();
            BeginSponsoringFutureReservesOp other$beginSponsoringFutureReservesOp = other.getBeginSponsoringFutureReservesOp();
            if (this$beginSponsoringFutureReservesOp == null ? other$beginSponsoringFutureReservesOp != null : !((Object)this$beginSponsoringFutureReservesOp).equals(other$beginSponsoringFutureReservesOp)) {
                return false;
            }
            RevokeSponsorshipOp this$revokeSponsorshipOp = this.getRevokeSponsorshipOp();
            RevokeSponsorshipOp other$revokeSponsorshipOp = other.getRevokeSponsorshipOp();
            if (this$revokeSponsorshipOp == null ? other$revokeSponsorshipOp != null : !((Object)this$revokeSponsorshipOp).equals(other$revokeSponsorshipOp)) {
                return false;
            }
            ClawbackOp this$clawbackOp = this.getClawbackOp();
            ClawbackOp other$clawbackOp = other.getClawbackOp();
            if (this$clawbackOp == null ? other$clawbackOp != null : !((Object)this$clawbackOp).equals(other$clawbackOp)) {
                return false;
            }
            ClawbackClaimableBalanceOp this$clawbackClaimableBalanceOp = this.getClawbackClaimableBalanceOp();
            ClawbackClaimableBalanceOp other$clawbackClaimableBalanceOp = other.getClawbackClaimableBalanceOp();
            if (this$clawbackClaimableBalanceOp == null ? other$clawbackClaimableBalanceOp != null : !((Object)this$clawbackClaimableBalanceOp).equals(other$clawbackClaimableBalanceOp)) {
                return false;
            }
            SetTrustLineFlagsOp this$setTrustLineFlagsOp = this.getSetTrustLineFlagsOp();
            SetTrustLineFlagsOp other$setTrustLineFlagsOp = other.getSetTrustLineFlagsOp();
            if (this$setTrustLineFlagsOp == null ? other$setTrustLineFlagsOp != null : !((Object)this$setTrustLineFlagsOp).equals(other$setTrustLineFlagsOp)) {
                return false;
            }
            LiquidityPoolDepositOp this$liquidityPoolDepositOp = this.getLiquidityPoolDepositOp();
            LiquidityPoolDepositOp other$liquidityPoolDepositOp = other.getLiquidityPoolDepositOp();
            if (this$liquidityPoolDepositOp == null ? other$liquidityPoolDepositOp != null : !((Object)this$liquidityPoolDepositOp).equals(other$liquidityPoolDepositOp)) {
                return false;
            }
            LiquidityPoolWithdrawOp this$liquidityPoolWithdrawOp = this.getLiquidityPoolWithdrawOp();
            LiquidityPoolWithdrawOp other$liquidityPoolWithdrawOp = other.getLiquidityPoolWithdrawOp();
            if (this$liquidityPoolWithdrawOp == null ? other$liquidityPoolWithdrawOp != null : !((Object)this$liquidityPoolWithdrawOp).equals(other$liquidityPoolWithdrawOp)) {
                return false;
            }
            InvokeHostFunctionOp this$invokeHostFunctionOp = this.getInvokeHostFunctionOp();
            InvokeHostFunctionOp other$invokeHostFunctionOp = other.getInvokeHostFunctionOp();
            if (this$invokeHostFunctionOp == null ? other$invokeHostFunctionOp != null : !((Object)this$invokeHostFunctionOp).equals(other$invokeHostFunctionOp)) {
                return false;
            }
            ExtendFootprintTTLOp this$extendFootprintTTLOp = this.getExtendFootprintTTLOp();
            ExtendFootprintTTLOp other$extendFootprintTTLOp = other.getExtendFootprintTTLOp();
            if (this$extendFootprintTTLOp == null ? other$extendFootprintTTLOp != null : !((Object)this$extendFootprintTTLOp).equals(other$extendFootprintTTLOp)) {
                return false;
            }
            RestoreFootprintOp this$restoreFootprintOp = this.getRestoreFootprintOp();
            RestoreFootprintOp other$restoreFootprintOp = other.getRestoreFootprintOp();
            return !(this$restoreFootprintOp == null ? other$restoreFootprintOp != null : !((Object)this$restoreFootprintOp).equals(other$restoreFootprintOp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperationBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OperationType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            CreateAccountOp $createAccountOp = this.getCreateAccountOp();
            result = result * 59 + ($createAccountOp == null ? 43 : ((Object)$createAccountOp).hashCode());
            PaymentOp $paymentOp = this.getPaymentOp();
            result = result * 59 + ($paymentOp == null ? 43 : ((Object)$paymentOp).hashCode());
            PathPaymentStrictReceiveOp $pathPaymentStrictReceiveOp = this.getPathPaymentStrictReceiveOp();
            result = result * 59 + ($pathPaymentStrictReceiveOp == null ? 43 : ((Object)$pathPaymentStrictReceiveOp).hashCode());
            ManageSellOfferOp $manageSellOfferOp = this.getManageSellOfferOp();
            result = result * 59 + ($manageSellOfferOp == null ? 43 : ((Object)$manageSellOfferOp).hashCode());
            CreatePassiveSellOfferOp $createPassiveSellOfferOp = this.getCreatePassiveSellOfferOp();
            result = result * 59 + ($createPassiveSellOfferOp == null ? 43 : ((Object)$createPassiveSellOfferOp).hashCode());
            SetOptionsOp $setOptionsOp = this.getSetOptionsOp();
            result = result * 59 + ($setOptionsOp == null ? 43 : ((Object)$setOptionsOp).hashCode());
            ChangeTrustOp $changeTrustOp = this.getChangeTrustOp();
            result = result * 59 + ($changeTrustOp == null ? 43 : ((Object)$changeTrustOp).hashCode());
            AllowTrustOp $allowTrustOp = this.getAllowTrustOp();
            result = result * 59 + ($allowTrustOp == null ? 43 : ((Object)$allowTrustOp).hashCode());
            MuxedAccount $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
            ManageDataOp $manageDataOp = this.getManageDataOp();
            result = result * 59 + ($manageDataOp == null ? 43 : ((Object)$manageDataOp).hashCode());
            BumpSequenceOp $bumpSequenceOp = this.getBumpSequenceOp();
            result = result * 59 + ($bumpSequenceOp == null ? 43 : ((Object)$bumpSequenceOp).hashCode());
            ManageBuyOfferOp $manageBuyOfferOp = this.getManageBuyOfferOp();
            result = result * 59 + ($manageBuyOfferOp == null ? 43 : ((Object)$manageBuyOfferOp).hashCode());
            PathPaymentStrictSendOp $pathPaymentStrictSendOp = this.getPathPaymentStrictSendOp();
            result = result * 59 + ($pathPaymentStrictSendOp == null ? 43 : ((Object)$pathPaymentStrictSendOp).hashCode());
            CreateClaimableBalanceOp $createClaimableBalanceOp = this.getCreateClaimableBalanceOp();
            result = result * 59 + ($createClaimableBalanceOp == null ? 43 : ((Object)$createClaimableBalanceOp).hashCode());
            ClaimClaimableBalanceOp $claimClaimableBalanceOp = this.getClaimClaimableBalanceOp();
            result = result * 59 + ($claimClaimableBalanceOp == null ? 43 : ((Object)$claimClaimableBalanceOp).hashCode());
            BeginSponsoringFutureReservesOp $beginSponsoringFutureReservesOp = this.getBeginSponsoringFutureReservesOp();
            result = result * 59 + ($beginSponsoringFutureReservesOp == null ? 43 : ((Object)$beginSponsoringFutureReservesOp).hashCode());
            RevokeSponsorshipOp $revokeSponsorshipOp = this.getRevokeSponsorshipOp();
            result = result * 59 + ($revokeSponsorshipOp == null ? 43 : ((Object)$revokeSponsorshipOp).hashCode());
            ClawbackOp $clawbackOp = this.getClawbackOp();
            result = result * 59 + ($clawbackOp == null ? 43 : ((Object)$clawbackOp).hashCode());
            ClawbackClaimableBalanceOp $clawbackClaimableBalanceOp = this.getClawbackClaimableBalanceOp();
            result = result * 59 + ($clawbackClaimableBalanceOp == null ? 43 : ((Object)$clawbackClaimableBalanceOp).hashCode());
            SetTrustLineFlagsOp $setTrustLineFlagsOp = this.getSetTrustLineFlagsOp();
            result = result * 59 + ($setTrustLineFlagsOp == null ? 43 : ((Object)$setTrustLineFlagsOp).hashCode());
            LiquidityPoolDepositOp $liquidityPoolDepositOp = this.getLiquidityPoolDepositOp();
            result = result * 59 + ($liquidityPoolDepositOp == null ? 43 : ((Object)$liquidityPoolDepositOp).hashCode());
            LiquidityPoolWithdrawOp $liquidityPoolWithdrawOp = this.getLiquidityPoolWithdrawOp();
            result = result * 59 + ($liquidityPoolWithdrawOp == null ? 43 : ((Object)$liquidityPoolWithdrawOp).hashCode());
            InvokeHostFunctionOp $invokeHostFunctionOp = this.getInvokeHostFunctionOp();
            result = result * 59 + ($invokeHostFunctionOp == null ? 43 : ((Object)$invokeHostFunctionOp).hashCode());
            ExtendFootprintTTLOp $extendFootprintTTLOp = this.getExtendFootprintTTLOp();
            result = result * 59 + ($extendFootprintTTLOp == null ? 43 : ((Object)$extendFootprintTTLOp).hashCode());
            RestoreFootprintOp $restoreFootprintOp = this.getRestoreFootprintOp();
            result = result * 59 + ($restoreFootprintOp == null ? 43 : ((Object)$restoreFootprintOp).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Operation.OperationBody(discriminant=" + this.getDiscriminant() + ", createAccountOp=" + this.getCreateAccountOp() + ", paymentOp=" + this.getPaymentOp() + ", pathPaymentStrictReceiveOp=" + this.getPathPaymentStrictReceiveOp() + ", manageSellOfferOp=" + this.getManageSellOfferOp() + ", createPassiveSellOfferOp=" + this.getCreatePassiveSellOfferOp() + ", setOptionsOp=" + this.getSetOptionsOp() + ", changeTrustOp=" + this.getChangeTrustOp() + ", allowTrustOp=" + this.getAllowTrustOp() + ", destination=" + this.getDestination() + ", manageDataOp=" + this.getManageDataOp() + ", bumpSequenceOp=" + this.getBumpSequenceOp() + ", manageBuyOfferOp=" + this.getManageBuyOfferOp() + ", pathPaymentStrictSendOp=" + this.getPathPaymentStrictSendOp() + ", createClaimableBalanceOp=" + this.getCreateClaimableBalanceOp() + ", claimClaimableBalanceOp=" + this.getClaimClaimableBalanceOp() + ", beginSponsoringFutureReservesOp=" + this.getBeginSponsoringFutureReservesOp() + ", revokeSponsorshipOp=" + this.getRevokeSponsorshipOp() + ", clawbackOp=" + this.getClawbackOp() + ", clawbackClaimableBalanceOp=" + this.getClawbackClaimableBalanceOp() + ", setTrustLineFlagsOp=" + this.getSetTrustLineFlagsOp() + ", liquidityPoolDepositOp=" + this.getLiquidityPoolDepositOp() + ", liquidityPoolWithdrawOp=" + this.getLiquidityPoolWithdrawOp() + ", invokeHostFunctionOp=" + this.getInvokeHostFunctionOp() + ", extendFootprintTTLOp=" + this.getExtendFootprintTTLOp() + ", restoreFootprintOp=" + this.getRestoreFootprintOp() + ")";
        }

        @Generated
        public OperationBody() {
        }

        @Generated
        public OperationBody(OperationType discriminant, CreateAccountOp createAccountOp, PaymentOp paymentOp, PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp, ManageSellOfferOp manageSellOfferOp, CreatePassiveSellOfferOp createPassiveSellOfferOp, SetOptionsOp setOptionsOp, ChangeTrustOp changeTrustOp, AllowTrustOp allowTrustOp, MuxedAccount destination, ManageDataOp manageDataOp, BumpSequenceOp bumpSequenceOp, ManageBuyOfferOp manageBuyOfferOp, PathPaymentStrictSendOp pathPaymentStrictSendOp, CreateClaimableBalanceOp createClaimableBalanceOp, ClaimClaimableBalanceOp claimClaimableBalanceOp, BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp, RevokeSponsorshipOp revokeSponsorshipOp, ClawbackOp clawbackOp, ClawbackClaimableBalanceOp clawbackClaimableBalanceOp, SetTrustLineFlagsOp setTrustLineFlagsOp, LiquidityPoolDepositOp liquidityPoolDepositOp, LiquidityPoolWithdrawOp liquidityPoolWithdrawOp, InvokeHostFunctionOp invokeHostFunctionOp, ExtendFootprintTTLOp extendFootprintTTLOp, RestoreFootprintOp restoreFootprintOp) {
            this.discriminant = discriminant;
            this.createAccountOp = createAccountOp;
            this.paymentOp = paymentOp;
            this.pathPaymentStrictReceiveOp = pathPaymentStrictReceiveOp;
            this.manageSellOfferOp = manageSellOfferOp;
            this.createPassiveSellOfferOp = createPassiveSellOfferOp;
            this.setOptionsOp = setOptionsOp;
            this.changeTrustOp = changeTrustOp;
            this.allowTrustOp = allowTrustOp;
            this.destination = destination;
            this.manageDataOp = manageDataOp;
            this.bumpSequenceOp = bumpSequenceOp;
            this.manageBuyOfferOp = manageBuyOfferOp;
            this.pathPaymentStrictSendOp = pathPaymentStrictSendOp;
            this.createClaimableBalanceOp = createClaimableBalanceOp;
            this.claimClaimableBalanceOp = claimClaimableBalanceOp;
            this.beginSponsoringFutureReservesOp = beginSponsoringFutureReservesOp;
            this.revokeSponsorshipOp = revokeSponsorshipOp;
            this.clawbackOp = clawbackOp;
            this.clawbackClaimableBalanceOp = clawbackClaimableBalanceOp;
            this.setTrustLineFlagsOp = setTrustLineFlagsOp;
            this.liquidityPoolDepositOp = liquidityPoolDepositOp;
            this.liquidityPoolWithdrawOp = liquidityPoolWithdrawOp;
            this.invokeHostFunctionOp = invokeHostFunctionOp;
            this.extendFootprintTTLOp = extendFootprintTTLOp;
            this.restoreFootprintOp = restoreFootprintOp;
        }

        @Generated
        public static class OperationBodyBuilder {
            @Generated
            private OperationType discriminant;
            @Generated
            private CreateAccountOp createAccountOp;
            @Generated
            private PaymentOp paymentOp;
            @Generated
            private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
            @Generated
            private ManageSellOfferOp manageSellOfferOp;
            @Generated
            private CreatePassiveSellOfferOp createPassiveSellOfferOp;
            @Generated
            private SetOptionsOp setOptionsOp;
            @Generated
            private ChangeTrustOp changeTrustOp;
            @Generated
            private AllowTrustOp allowTrustOp;
            @Generated
            private MuxedAccount destination;
            @Generated
            private ManageDataOp manageDataOp;
            @Generated
            private BumpSequenceOp bumpSequenceOp;
            @Generated
            private ManageBuyOfferOp manageBuyOfferOp;
            @Generated
            private PathPaymentStrictSendOp pathPaymentStrictSendOp;
            @Generated
            private CreateClaimableBalanceOp createClaimableBalanceOp;
            @Generated
            private ClaimClaimableBalanceOp claimClaimableBalanceOp;
            @Generated
            private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
            @Generated
            private RevokeSponsorshipOp revokeSponsorshipOp;
            @Generated
            private ClawbackOp clawbackOp;
            @Generated
            private ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
            @Generated
            private SetTrustLineFlagsOp setTrustLineFlagsOp;
            @Generated
            private LiquidityPoolDepositOp liquidityPoolDepositOp;
            @Generated
            private LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;
            @Generated
            private InvokeHostFunctionOp invokeHostFunctionOp;
            @Generated
            private ExtendFootprintTTLOp extendFootprintTTLOp;
            @Generated
            private RestoreFootprintOp restoreFootprintOp;

            @Generated
            OperationBodyBuilder() {
            }

            @Generated
            public OperationBodyBuilder discriminant(OperationType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public OperationBodyBuilder createAccountOp(CreateAccountOp createAccountOp) {
                this.createAccountOp = createAccountOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder paymentOp(PaymentOp paymentOp) {
                this.paymentOp = paymentOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder pathPaymentStrictReceiveOp(PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp) {
                this.pathPaymentStrictReceiveOp = pathPaymentStrictReceiveOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder manageSellOfferOp(ManageSellOfferOp manageSellOfferOp) {
                this.manageSellOfferOp = manageSellOfferOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder createPassiveSellOfferOp(CreatePassiveSellOfferOp createPassiveSellOfferOp) {
                this.createPassiveSellOfferOp = createPassiveSellOfferOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder setOptionsOp(SetOptionsOp setOptionsOp) {
                this.setOptionsOp = setOptionsOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder changeTrustOp(ChangeTrustOp changeTrustOp) {
                this.changeTrustOp = changeTrustOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder allowTrustOp(AllowTrustOp allowTrustOp) {
                this.allowTrustOp = allowTrustOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder destination(MuxedAccount destination) {
                this.destination = destination;
                return this;
            }

            @Generated
            public OperationBodyBuilder manageDataOp(ManageDataOp manageDataOp) {
                this.manageDataOp = manageDataOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder bumpSequenceOp(BumpSequenceOp bumpSequenceOp) {
                this.bumpSequenceOp = bumpSequenceOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder manageBuyOfferOp(ManageBuyOfferOp manageBuyOfferOp) {
                this.manageBuyOfferOp = manageBuyOfferOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder pathPaymentStrictSendOp(PathPaymentStrictSendOp pathPaymentStrictSendOp) {
                this.pathPaymentStrictSendOp = pathPaymentStrictSendOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder createClaimableBalanceOp(CreateClaimableBalanceOp createClaimableBalanceOp) {
                this.createClaimableBalanceOp = createClaimableBalanceOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder claimClaimableBalanceOp(ClaimClaimableBalanceOp claimClaimableBalanceOp) {
                this.claimClaimableBalanceOp = claimClaimableBalanceOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder beginSponsoringFutureReservesOp(BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp) {
                this.beginSponsoringFutureReservesOp = beginSponsoringFutureReservesOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder revokeSponsorshipOp(RevokeSponsorshipOp revokeSponsorshipOp) {
                this.revokeSponsorshipOp = revokeSponsorshipOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder clawbackOp(ClawbackOp clawbackOp) {
                this.clawbackOp = clawbackOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder clawbackClaimableBalanceOp(ClawbackClaimableBalanceOp clawbackClaimableBalanceOp) {
                this.clawbackClaimableBalanceOp = clawbackClaimableBalanceOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder setTrustLineFlagsOp(SetTrustLineFlagsOp setTrustLineFlagsOp) {
                this.setTrustLineFlagsOp = setTrustLineFlagsOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder liquidityPoolDepositOp(LiquidityPoolDepositOp liquidityPoolDepositOp) {
                this.liquidityPoolDepositOp = liquidityPoolDepositOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder liquidityPoolWithdrawOp(LiquidityPoolWithdrawOp liquidityPoolWithdrawOp) {
                this.liquidityPoolWithdrawOp = liquidityPoolWithdrawOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder invokeHostFunctionOp(InvokeHostFunctionOp invokeHostFunctionOp) {
                this.invokeHostFunctionOp = invokeHostFunctionOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder extendFootprintTTLOp(ExtendFootprintTTLOp extendFootprintTTLOp) {
                this.extendFootprintTTLOp = extendFootprintTTLOp;
                return this;
            }

            @Generated
            public OperationBodyBuilder restoreFootprintOp(RestoreFootprintOp restoreFootprintOp) {
                this.restoreFootprintOp = restoreFootprintOp;
                return this;
            }

            @Generated
            public OperationBody build() {
                return new OperationBody(this.discriminant, this.createAccountOp, this.paymentOp, this.pathPaymentStrictReceiveOp, this.manageSellOfferOp, this.createPassiveSellOfferOp, this.setOptionsOp, this.changeTrustOp, this.allowTrustOp, this.destination, this.manageDataOp, this.bumpSequenceOp, this.manageBuyOfferOp, this.pathPaymentStrictSendOp, this.createClaimableBalanceOp, this.claimClaimableBalanceOp, this.beginSponsoringFutureReservesOp, this.revokeSponsorshipOp, this.clawbackOp, this.clawbackClaimableBalanceOp, this.setTrustLineFlagsOp, this.liquidityPoolDepositOp, this.liquidityPoolWithdrawOp, this.invokeHostFunctionOp, this.extendFootprintTTLOp, this.restoreFootprintOp);
            }

            @Generated
            public String toString() {
                return "Operation.OperationBody.OperationBodyBuilder(discriminant=" + this.discriminant + ", createAccountOp=" + this.createAccountOp + ", paymentOp=" + this.paymentOp + ", pathPaymentStrictReceiveOp=" + this.pathPaymentStrictReceiveOp + ", manageSellOfferOp=" + this.manageSellOfferOp + ", createPassiveSellOfferOp=" + this.createPassiveSellOfferOp + ", setOptionsOp=" + this.setOptionsOp + ", changeTrustOp=" + this.changeTrustOp + ", allowTrustOp=" + this.allowTrustOp + ", destination=" + this.destination + ", manageDataOp=" + this.manageDataOp + ", bumpSequenceOp=" + this.bumpSequenceOp + ", manageBuyOfferOp=" + this.manageBuyOfferOp + ", pathPaymentStrictSendOp=" + this.pathPaymentStrictSendOp + ", createClaimableBalanceOp=" + this.createClaimableBalanceOp + ", claimClaimableBalanceOp=" + this.claimClaimableBalanceOp + ", beginSponsoringFutureReservesOp=" + this.beginSponsoringFutureReservesOp + ", revokeSponsorshipOp=" + this.revokeSponsorshipOp + ", clawbackOp=" + this.clawbackOp + ", clawbackClaimableBalanceOp=" + this.clawbackClaimableBalanceOp + ", setTrustLineFlagsOp=" + this.setTrustLineFlagsOp + ", liquidityPoolDepositOp=" + this.liquidityPoolDepositOp + ", liquidityPoolWithdrawOp=" + this.liquidityPoolWithdrawOp + ", invokeHostFunctionOp=" + this.invokeHostFunctionOp + ", extendFootprintTTLOp=" + this.extendFootprintTTLOp + ", restoreFootprintOp=" + this.restoreFootprintOp + ")";
            }
        }
    }
}

