/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum PathPaymentStrictSendResultCode implements XdrElement
{
    PATH_PAYMENT_STRICT_SEND_SUCCESS(0),
    PATH_PAYMENT_STRICT_SEND_MALFORMED(-1),
    PATH_PAYMENT_STRICT_SEND_UNDERFUNDED(-2),
    PATH_PAYMENT_STRICT_SEND_SRC_NO_TRUST(-3),
    PATH_PAYMENT_STRICT_SEND_SRC_NOT_AUTHORIZED(-4),
    PATH_PAYMENT_STRICT_SEND_NO_DESTINATION(-5),
    PATH_PAYMENT_STRICT_SEND_NO_TRUST(-6),
    PATH_PAYMENT_STRICT_SEND_NOT_AUTHORIZED(-7),
    PATH_PAYMENT_STRICT_SEND_LINE_FULL(-8),
    PATH_PAYMENT_STRICT_SEND_NO_ISSUER(-9),
    PATH_PAYMENT_STRICT_SEND_TOO_FEW_OFFERS(-10),
    PATH_PAYMENT_STRICT_SEND_OFFER_CROSS_SELF(-11),
    PATH_PAYMENT_STRICT_SEND_UNDER_DESTMIN(-12);

    private final int value;

    private PathPaymentStrictSendResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PathPaymentStrictSendResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return PATH_PAYMENT_STRICT_SEND_SUCCESS;
            }
            case -1: {
                return PATH_PAYMENT_STRICT_SEND_MALFORMED;
            }
            case -2: {
                return PATH_PAYMENT_STRICT_SEND_UNDERFUNDED;
            }
            case -3: {
                return PATH_PAYMENT_STRICT_SEND_SRC_NO_TRUST;
            }
            case -4: {
                return PATH_PAYMENT_STRICT_SEND_SRC_NOT_AUTHORIZED;
            }
            case -5: {
                return PATH_PAYMENT_STRICT_SEND_NO_DESTINATION;
            }
            case -6: {
                return PATH_PAYMENT_STRICT_SEND_NO_TRUST;
            }
            case -7: {
                return PATH_PAYMENT_STRICT_SEND_NOT_AUTHORIZED;
            }
            case -8: {
                return PATH_PAYMENT_STRICT_SEND_LINE_FULL;
            }
            case -9: {
                return PATH_PAYMENT_STRICT_SEND_NO_ISSUER;
            }
            case -10: {
                return PATH_PAYMENT_STRICT_SEND_TOO_FEW_OFFERS;
            }
            case -11: {
                return PATH_PAYMENT_STRICT_SEND_OFFER_CROSS_SELF;
            }
            case -12: {
                return PATH_PAYMENT_STRICT_SEND_UNDER_DESTMIN;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static PathPaymentStrictSendResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictSendResultCode.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictSendResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictSendResultCode.decode(xdrDataInputStream);
    }
}

