/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ContractID;
import org.stellar.sdk.xdr.MuxedEd25519Account;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SCAddressType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCAddress
implements XdrElement {
    private SCAddressType discriminant;
    private AccountID accountId;
    private ContractID contractId;
    private MuxedEd25519Account muxedAccount;
    private ClaimableBalanceID claimableBalanceId;
    private PoolID liquidityPoolId;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                this.accountId.encode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                this.contractId.encode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_MUXED_ACCOUNT: {
                this.muxedAccount.encode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CLAIMABLE_BALANCE: {
                this.claimableBalanceId.encode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_LIQUIDITY_POOL: {
                this.liquidityPoolId.encode(stream);
            }
        }
    }

    public static SCAddress decode(XdrDataInputStream stream) throws IOException {
        SCAddress decodedSCAddress = new SCAddress();
        SCAddressType discriminant = SCAddressType.decode(stream);
        decodedSCAddress.setDiscriminant(discriminant);
        switch (decodedSCAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                decodedSCAddress.accountId = AccountID.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                decodedSCAddress.contractId = ContractID.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_MUXED_ACCOUNT: {
                decodedSCAddress.muxedAccount = MuxedEd25519Account.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CLAIMABLE_BALANCE: {
                decodedSCAddress.claimableBalanceId = ClaimableBalanceID.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_LIQUIDITY_POOL: {
                decodedSCAddress.liquidityPoolId = PoolID.decode(stream);
            }
        }
        return decodedSCAddress;
    }

    public static SCAddress fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCAddress.fromXdrByteArray(bytes);
    }

    public static SCAddress fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCAddress.decode(xdrDataInputStream);
    }

    @Generated
    public static SCAddressBuilder builder() {
        return new SCAddressBuilder();
    }

    @Generated
    public SCAddressBuilder toBuilder() {
        return new SCAddressBuilder().discriminant(this.discriminant).accountId(this.accountId).contractId(this.contractId).muxedAccount(this.muxedAccount).claimableBalanceId(this.claimableBalanceId).liquidityPoolId(this.liquidityPoolId);
    }

    @Generated
    public SCAddressType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AccountID getAccountId() {
        return this.accountId;
    }

    @Generated
    public ContractID getContractId() {
        return this.contractId;
    }

    @Generated
    public MuxedEd25519Account getMuxedAccount() {
        return this.muxedAccount;
    }

    @Generated
    public ClaimableBalanceID getClaimableBalanceId() {
        return this.claimableBalanceId;
    }

    @Generated
    public PoolID getLiquidityPoolId() {
        return this.liquidityPoolId;
    }

    @Generated
    public void setDiscriminant(SCAddressType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAccountId(AccountID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setContractId(ContractID contractId) {
        this.contractId = contractId;
    }

    @Generated
    public void setMuxedAccount(MuxedEd25519Account muxedAccount) {
        this.muxedAccount = muxedAccount;
    }

    @Generated
    public void setClaimableBalanceId(ClaimableBalanceID claimableBalanceId) {
        this.claimableBalanceId = claimableBalanceId;
    }

    @Generated
    public void setLiquidityPoolId(PoolID liquidityPoolId) {
        this.liquidityPoolId = liquidityPoolId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCAddress)) {
            return false;
        }
        SCAddress other = (SCAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCAddressType this$discriminant = this.getDiscriminant();
        SCAddressType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AccountID this$accountId = this.getAccountId();
        AccountID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        ContractID this$contractId = this.getContractId();
        ContractID other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !((Object)this$contractId).equals(other$contractId)) {
            return false;
        }
        MuxedEd25519Account this$muxedAccount = this.getMuxedAccount();
        MuxedEd25519Account other$muxedAccount = other.getMuxedAccount();
        if (this$muxedAccount == null ? other$muxedAccount != null : !((Object)this$muxedAccount).equals(other$muxedAccount)) {
            return false;
        }
        ClaimableBalanceID this$claimableBalanceId = this.getClaimableBalanceId();
        ClaimableBalanceID other$claimableBalanceId = other.getClaimableBalanceId();
        if (this$claimableBalanceId == null ? other$claimableBalanceId != null : !((Object)this$claimableBalanceId).equals(other$claimableBalanceId)) {
            return false;
        }
        PoolID this$liquidityPoolId = this.getLiquidityPoolId();
        PoolID other$liquidityPoolId = other.getLiquidityPoolId();
        return !(this$liquidityPoolId == null ? other$liquidityPoolId != null : !((Object)this$liquidityPoolId).equals(other$liquidityPoolId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCAddress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCAddressType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AccountID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        ContractID $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : ((Object)$contractId).hashCode());
        MuxedEd25519Account $muxedAccount = this.getMuxedAccount();
        result = result * 59 + ($muxedAccount == null ? 43 : ((Object)$muxedAccount).hashCode());
        ClaimableBalanceID $claimableBalanceId = this.getClaimableBalanceId();
        result = result * 59 + ($claimableBalanceId == null ? 43 : ((Object)$claimableBalanceId).hashCode());
        PoolID $liquidityPoolId = this.getLiquidityPoolId();
        result = result * 59 + ($liquidityPoolId == null ? 43 : ((Object)$liquidityPoolId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCAddress(discriminant=" + this.getDiscriminant() + ", accountId=" + this.getAccountId() + ", contractId=" + this.getContractId() + ", muxedAccount=" + this.getMuxedAccount() + ", claimableBalanceId=" + this.getClaimableBalanceId() + ", liquidityPoolId=" + this.getLiquidityPoolId() + ")";
    }

    @Generated
    public SCAddress() {
    }

    @Generated
    public SCAddress(SCAddressType discriminant, AccountID accountId, ContractID contractId, MuxedEd25519Account muxedAccount, ClaimableBalanceID claimableBalanceId, PoolID liquidityPoolId) {
        this.discriminant = discriminant;
        this.accountId = accountId;
        this.contractId = contractId;
        this.muxedAccount = muxedAccount;
        this.claimableBalanceId = claimableBalanceId;
        this.liquidityPoolId = liquidityPoolId;
    }

    @Generated
    public static class SCAddressBuilder {
        @Generated
        private SCAddressType discriminant;
        @Generated
        private AccountID accountId;
        @Generated
        private ContractID contractId;
        @Generated
        private MuxedEd25519Account muxedAccount;
        @Generated
        private ClaimableBalanceID claimableBalanceId;
        @Generated
        private PoolID liquidityPoolId;

        @Generated
        SCAddressBuilder() {
        }

        @Generated
        public SCAddressBuilder discriminant(SCAddressType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCAddressBuilder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public SCAddressBuilder contractId(ContractID contractId) {
            this.contractId = contractId;
            return this;
        }

        @Generated
        public SCAddressBuilder muxedAccount(MuxedEd25519Account muxedAccount) {
            this.muxedAccount = muxedAccount;
            return this;
        }

        @Generated
        public SCAddressBuilder claimableBalanceId(ClaimableBalanceID claimableBalanceId) {
            this.claimableBalanceId = claimableBalanceId;
            return this;
        }

        @Generated
        public SCAddressBuilder liquidityPoolId(PoolID liquidityPoolId) {
            this.liquidityPoolId = liquidityPoolId;
            return this;
        }

        @Generated
        public SCAddress build() {
            return new SCAddress(this.discriminant, this.accountId, this.contractId, this.muxedAccount, this.claimableBalanceId, this.liquidityPoolId);
        }

        @Generated
        public String toString() {
            return "SCAddress.SCAddressBuilder(discriminant=" + this.discriminant + ", accountId=" + this.accountId + ", contractId=" + this.contractId + ", muxedAccount=" + this.muxedAccount + ", claimableBalanceId=" + this.claimableBalanceId + ", liquidityPoolId=" + this.liquidityPoolId + ")";
        }
    }
}

