/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SorobanCredentialsType implements XdrElement
{
    SOROBAN_CREDENTIALS_SOURCE_ACCOUNT(0),
    SOROBAN_CREDENTIALS_ADDRESS(1);

    private final int value;

    private SorobanCredentialsType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SorobanCredentialsType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SOROBAN_CREDENTIALS_SOURCE_ACCOUNT;
            }
            case 1: {
                return SOROBAN_CREDENTIALS_ADDRESS;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SorobanCredentialsType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanCredentialsType.fromXdrByteArray(bytes);
    }

    public static SorobanCredentialsType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanCredentialsType.decode(xdrDataInputStream);
    }
}

