/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerFootprint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanResources
implements XdrElement {
    private LedgerFootprint footprint;
    private Uint32 instructions;
    private Uint32 diskReadBytes;
    private Uint32 writeBytes;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.footprint.encode(stream);
        this.instructions.encode(stream);
        this.diskReadBytes.encode(stream);
        this.writeBytes.encode(stream);
    }

    public static SorobanResources decode(XdrDataInputStream stream) throws IOException {
        SorobanResources decodedSorobanResources = new SorobanResources();
        decodedSorobanResources.footprint = LedgerFootprint.decode(stream);
        decodedSorobanResources.instructions = Uint32.decode(stream);
        decodedSorobanResources.diskReadBytes = Uint32.decode(stream);
        decodedSorobanResources.writeBytes = Uint32.decode(stream);
        return decodedSorobanResources;
    }

    public static SorobanResources fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanResources.fromXdrByteArray(bytes);
    }

    public static SorobanResources fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanResources.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanResourcesBuilder builder() {
        return new SorobanResourcesBuilder();
    }

    @Generated
    public SorobanResourcesBuilder toBuilder() {
        return new SorobanResourcesBuilder().footprint(this.footprint).instructions(this.instructions).diskReadBytes(this.diskReadBytes).writeBytes(this.writeBytes);
    }

    @Generated
    public LedgerFootprint getFootprint() {
        return this.footprint;
    }

    @Generated
    public Uint32 getInstructions() {
        return this.instructions;
    }

    @Generated
    public Uint32 getDiskReadBytes() {
        return this.diskReadBytes;
    }

    @Generated
    public Uint32 getWriteBytes() {
        return this.writeBytes;
    }

    @Generated
    public void setFootprint(LedgerFootprint footprint) {
        this.footprint = footprint;
    }

    @Generated
    public void setInstructions(Uint32 instructions) {
        this.instructions = instructions;
    }

    @Generated
    public void setDiskReadBytes(Uint32 diskReadBytes) {
        this.diskReadBytes = diskReadBytes;
    }

    @Generated
    public void setWriteBytes(Uint32 writeBytes) {
        this.writeBytes = writeBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanResources)) {
            return false;
        }
        SorobanResources other = (SorobanResources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerFootprint this$footprint = this.getFootprint();
        LedgerFootprint other$footprint = other.getFootprint();
        if (this$footprint == null ? other$footprint != null : !((Object)this$footprint).equals(other$footprint)) {
            return false;
        }
        Uint32 this$instructions = this.getInstructions();
        Uint32 other$instructions = other.getInstructions();
        if (this$instructions == null ? other$instructions != null : !((Object)this$instructions).equals(other$instructions)) {
            return false;
        }
        Uint32 this$diskReadBytes = this.getDiskReadBytes();
        Uint32 other$diskReadBytes = other.getDiskReadBytes();
        if (this$diskReadBytes == null ? other$diskReadBytes != null : !((Object)this$diskReadBytes).equals(other$diskReadBytes)) {
            return false;
        }
        Uint32 this$writeBytes = this.getWriteBytes();
        Uint32 other$writeBytes = other.getWriteBytes();
        return !(this$writeBytes == null ? other$writeBytes != null : !((Object)this$writeBytes).equals(other$writeBytes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanResources;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerFootprint $footprint = this.getFootprint();
        result = result * 59 + ($footprint == null ? 43 : ((Object)$footprint).hashCode());
        Uint32 $instructions = this.getInstructions();
        result = result * 59 + ($instructions == null ? 43 : ((Object)$instructions).hashCode());
        Uint32 $diskReadBytes = this.getDiskReadBytes();
        result = result * 59 + ($diskReadBytes == null ? 43 : ((Object)$diskReadBytes).hashCode());
        Uint32 $writeBytes = this.getWriteBytes();
        result = result * 59 + ($writeBytes == null ? 43 : ((Object)$writeBytes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanResources(footprint=" + this.getFootprint() + ", instructions=" + this.getInstructions() + ", diskReadBytes=" + this.getDiskReadBytes() + ", writeBytes=" + this.getWriteBytes() + ")";
    }

    @Generated
    public SorobanResources() {
    }

    @Generated
    public SorobanResources(LedgerFootprint footprint, Uint32 instructions, Uint32 diskReadBytes, Uint32 writeBytes) {
        this.footprint = footprint;
        this.instructions = instructions;
        this.diskReadBytes = diskReadBytes;
        this.writeBytes = writeBytes;
    }

    @Generated
    public static class SorobanResourcesBuilder {
        @Generated
        private LedgerFootprint footprint;
        @Generated
        private Uint32 instructions;
        @Generated
        private Uint32 diskReadBytes;
        @Generated
        private Uint32 writeBytes;

        @Generated
        SorobanResourcesBuilder() {
        }

        @Generated
        public SorobanResourcesBuilder footprint(LedgerFootprint footprint) {
            this.footprint = footprint;
            return this;
        }

        @Generated
        public SorobanResourcesBuilder instructions(Uint32 instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public SorobanResourcesBuilder diskReadBytes(Uint32 diskReadBytes) {
            this.diskReadBytes = diskReadBytes;
            return this;
        }

        @Generated
        public SorobanResourcesBuilder writeBytes(Uint32 writeBytes) {
            this.writeBytes = writeBytes;
            return this;
        }

        @Generated
        public SorobanResources build() {
            return new SorobanResources(this.footprint, this.instructions, this.diskReadBytes, this.writeBytes);
        }

        @Generated
        public String toString() {
            return "SorobanResources.SorobanResourcesBuilder(footprint=" + this.footprint + ", instructions=" + this.instructions + ", diskReadBytes=" + this.diskReadBytes + ", writeBytes=" + this.writeBytes + ")";
        }
    }
}

