/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SorobanResources;
import org.stellar.sdk.xdr.SorobanResourcesExtV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionData
implements XdrElement {
    private SorobanTransactionDataExt ext;
    private SorobanResources resources;
    private Int64 resourceFee;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.resources.encode(stream);
        this.resourceFee.encode(stream);
    }

    public static SorobanTransactionData decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionData decodedSorobanTransactionData = new SorobanTransactionData();
        decodedSorobanTransactionData.ext = SorobanTransactionDataExt.decode(stream);
        decodedSorobanTransactionData.resources = SorobanResources.decode(stream);
        decodedSorobanTransactionData.resourceFee = Int64.decode(stream);
        return decodedSorobanTransactionData;
    }

    public static SorobanTransactionData fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionData.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionData fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionData.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanTransactionDataBuilder builder() {
        return new SorobanTransactionDataBuilder();
    }

    @Generated
    public SorobanTransactionDataBuilder toBuilder() {
        return new SorobanTransactionDataBuilder().ext(this.ext).resources(this.resources).resourceFee(this.resourceFee);
    }

    @Generated
    public SorobanTransactionDataExt getExt() {
        return this.ext;
    }

    @Generated
    public SorobanResources getResources() {
        return this.resources;
    }

    @Generated
    public Int64 getResourceFee() {
        return this.resourceFee;
    }

    @Generated
    public void setExt(SorobanTransactionDataExt ext) {
        this.ext = ext;
    }

    @Generated
    public void setResources(SorobanResources resources) {
        this.resources = resources;
    }

    @Generated
    public void setResourceFee(Int64 resourceFee) {
        this.resourceFee = resourceFee;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanTransactionData)) {
            return false;
        }
        SorobanTransactionData other = (SorobanTransactionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorobanTransactionDataExt this$ext = this.getExt();
        SorobanTransactionDataExt other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        SorobanResources this$resources = this.getResources();
        SorobanResources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Int64 this$resourceFee = this.getResourceFee();
        Int64 other$resourceFee = other.getResourceFee();
        return !(this$resourceFee == null ? other$resourceFee != null : !((Object)this$resourceFee).equals(other$resourceFee));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanTransactionData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorobanTransactionDataExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        SorobanResources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Int64 $resourceFee = this.getResourceFee();
        result = result * 59 + ($resourceFee == null ? 43 : ((Object)$resourceFee).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanTransactionData(ext=" + this.getExt() + ", resources=" + this.getResources() + ", resourceFee=" + this.getResourceFee() + ")";
    }

    @Generated
    public SorobanTransactionData() {
    }

    @Generated
    public SorobanTransactionData(SorobanTransactionDataExt ext, SorobanResources resources, Int64 resourceFee) {
        this.ext = ext;
        this.resources = resources;
        this.resourceFee = resourceFee;
    }

    @Generated
    public static class SorobanTransactionDataBuilder {
        @Generated
        private SorobanTransactionDataExt ext;
        @Generated
        private SorobanResources resources;
        @Generated
        private Int64 resourceFee;

        @Generated
        SorobanTransactionDataBuilder() {
        }

        @Generated
        public SorobanTransactionDataBuilder ext(SorobanTransactionDataExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public SorobanTransactionDataBuilder resources(SorobanResources resources) {
            this.resources = resources;
            return this;
        }

        @Generated
        public SorobanTransactionDataBuilder resourceFee(Int64 resourceFee) {
            this.resourceFee = resourceFee;
            return this;
        }

        @Generated
        public SorobanTransactionData build() {
            return new SorobanTransactionData(this.ext, this.resources, this.resourceFee);
        }

        @Generated
        public String toString() {
            return "SorobanTransactionData.SorobanTransactionDataBuilder(ext=" + this.ext + ", resources=" + this.resources + ", resourceFee=" + this.resourceFee + ")";
        }
    }

    public static class SorobanTransactionDataExt
    implements XdrElement {
        private Integer discriminant;
        private SorobanResourcesExtV0 resourceExt;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    break;
                }
                case 1: {
                    this.resourceExt.encode(stream);
                }
            }
        }

        public static SorobanTransactionDataExt decode(XdrDataInputStream stream) throws IOException {
            SorobanTransactionDataExt decodedSorobanTransactionDataExt = new SorobanTransactionDataExt();
            Integer discriminant = stream.readInt();
            decodedSorobanTransactionDataExt.setDiscriminant(discriminant);
            switch (decodedSorobanTransactionDataExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedSorobanTransactionDataExt.resourceExt = SorobanResourcesExtV0.decode(stream);
                }
            }
            return decodedSorobanTransactionDataExt;
        }

        public static SorobanTransactionDataExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return SorobanTransactionDataExt.fromXdrByteArray(bytes);
        }

        public static SorobanTransactionDataExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return SorobanTransactionDataExt.decode(xdrDataInputStream);
        }

        @Generated
        public static SorobanTransactionDataExtBuilder builder() {
            return new SorobanTransactionDataExtBuilder();
        }

        @Generated
        public SorobanTransactionDataExtBuilder toBuilder() {
            return new SorobanTransactionDataExtBuilder().discriminant(this.discriminant).resourceExt(this.resourceExt);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public SorobanResourcesExtV0 getResourceExt() {
            return this.resourceExt;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setResourceExt(SorobanResourcesExtV0 resourceExt) {
            this.resourceExt = resourceExt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SorobanTransactionDataExt)) {
                return false;
            }
            SorobanTransactionDataExt other = (SorobanTransactionDataExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            SorobanResourcesExtV0 this$resourceExt = this.getResourceExt();
            SorobanResourcesExtV0 other$resourceExt = other.getResourceExt();
            return !(this$resourceExt == null ? other$resourceExt != null : !((Object)this$resourceExt).equals(other$resourceExt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SorobanTransactionDataExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            SorobanResourcesExtV0 $resourceExt = this.getResourceExt();
            result = result * 59 + ($resourceExt == null ? 43 : ((Object)$resourceExt).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SorobanTransactionData.SorobanTransactionDataExt(discriminant=" + this.getDiscriminant() + ", resourceExt=" + this.getResourceExt() + ")";
        }

        @Generated
        public SorobanTransactionDataExt() {
        }

        @Generated
        public SorobanTransactionDataExt(Integer discriminant, SorobanResourcesExtV0 resourceExt) {
            this.discriminant = discriminant;
            this.resourceExt = resourceExt;
        }

        @Generated
        public static class SorobanTransactionDataExtBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private SorobanResourcesExtV0 resourceExt;

            @Generated
            SorobanTransactionDataExtBuilder() {
            }

            @Generated
            public SorobanTransactionDataExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public SorobanTransactionDataExtBuilder resourceExt(SorobanResourcesExtV0 resourceExt) {
                this.resourceExt = resourceExt;
                return this;
            }

            @Generated
            public SorobanTransactionDataExt build() {
                return new SorobanTransactionDataExt(this.discriminant, this.resourceExt);
            }

            @Generated
            public String toString() {
                return "SorobanTransactionData.SorobanTransactionDataExt.SorobanTransactionDataExtBuilder(discriminant=" + this.discriminant + ", resourceExt=" + this.resourceExt + ")";
            }
        }
    }
}

