/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerCloseValueSignature;
import org.stellar.sdk.xdr.StellarValueType;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.UpgradeType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StellarValue
implements XdrElement {
    private Hash txSetHash;
    private TimePoint closeTime;
    private UpgradeType[] upgrades;
    private StellarValueExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.txSetHash.encode(stream);
        this.closeTime.encode(stream);
        int upgradesSize = this.getUpgrades().length;
        stream.writeInt(upgradesSize);
        for (int i = 0; i < upgradesSize; ++i) {
            this.upgrades[i].encode(stream);
        }
        this.ext.encode(stream);
    }

    public static StellarValue decode(XdrDataInputStream stream) throws IOException {
        StellarValue decodedStellarValue = new StellarValue();
        decodedStellarValue.txSetHash = Hash.decode(stream);
        decodedStellarValue.closeTime = TimePoint.decode(stream);
        int upgradesSize = stream.readInt();
        decodedStellarValue.upgrades = new UpgradeType[upgradesSize];
        for (int i = 0; i < upgradesSize; ++i) {
            decodedStellarValue.upgrades[i] = UpgradeType.decode(stream);
        }
        decodedStellarValue.ext = StellarValueExt.decode(stream);
        return decodedStellarValue;
    }

    public static StellarValue fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StellarValue.fromXdrByteArray(bytes);
    }

    public static StellarValue fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StellarValue.decode(xdrDataInputStream);
    }

    @Generated
    public static StellarValueBuilder builder() {
        return new StellarValueBuilder();
    }

    @Generated
    public StellarValueBuilder toBuilder() {
        return new StellarValueBuilder().txSetHash(this.txSetHash).closeTime(this.closeTime).upgrades(this.upgrades).ext(this.ext);
    }

    @Generated
    public Hash getTxSetHash() {
        return this.txSetHash;
    }

    @Generated
    public TimePoint getCloseTime() {
        return this.closeTime;
    }

    @Generated
    public UpgradeType[] getUpgrades() {
        return this.upgrades;
    }

    @Generated
    public StellarValueExt getExt() {
        return this.ext;
    }

    @Generated
    public void setTxSetHash(Hash txSetHash) {
        this.txSetHash = txSetHash;
    }

    @Generated
    public void setCloseTime(TimePoint closeTime) {
        this.closeTime = closeTime;
    }

    @Generated
    public void setUpgrades(UpgradeType[] upgrades) {
        this.upgrades = upgrades;
    }

    @Generated
    public void setExt(StellarValueExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StellarValue)) {
            return false;
        }
        StellarValue other = (StellarValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$txSetHash = this.getTxSetHash();
        Hash other$txSetHash = other.getTxSetHash();
        if (this$txSetHash == null ? other$txSetHash != null : !((Object)this$txSetHash).equals(other$txSetHash)) {
            return false;
        }
        TimePoint this$closeTime = this.getCloseTime();
        TimePoint other$closeTime = other.getCloseTime();
        if (this$closeTime == null ? other$closeTime != null : !((Object)this$closeTime).equals(other$closeTime)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUpgrades(), other.getUpgrades())) {
            return false;
        }
        StellarValueExt this$ext = this.getExt();
        StellarValueExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StellarValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $txSetHash = this.getTxSetHash();
        result = result * 59 + ($txSetHash == null ? 43 : ((Object)$txSetHash).hashCode());
        TimePoint $closeTime = this.getCloseTime();
        result = result * 59 + ($closeTime == null ? 43 : ((Object)$closeTime).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUpgrades());
        StellarValueExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StellarValue(txSetHash=" + this.getTxSetHash() + ", closeTime=" + this.getCloseTime() + ", upgrades=" + Arrays.deepToString(this.getUpgrades()) + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public StellarValue() {
    }

    @Generated
    public StellarValue(Hash txSetHash, TimePoint closeTime, UpgradeType[] upgrades, StellarValueExt ext) {
        this.txSetHash = txSetHash;
        this.closeTime = closeTime;
        this.upgrades = upgrades;
        this.ext = ext;
    }

    @Generated
    public static class StellarValueBuilder {
        @Generated
        private Hash txSetHash;
        @Generated
        private TimePoint closeTime;
        @Generated
        private UpgradeType[] upgrades;
        @Generated
        private StellarValueExt ext;

        @Generated
        StellarValueBuilder() {
        }

        @Generated
        public StellarValueBuilder txSetHash(Hash txSetHash) {
            this.txSetHash = txSetHash;
            return this;
        }

        @Generated
        public StellarValueBuilder closeTime(TimePoint closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        @Generated
        public StellarValueBuilder upgrades(UpgradeType[] upgrades) {
            this.upgrades = upgrades;
            return this;
        }

        @Generated
        public StellarValueBuilder ext(StellarValueExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public StellarValue build() {
            return new StellarValue(this.txSetHash, this.closeTime, this.upgrades, this.ext);
        }

        @Generated
        public String toString() {
            return "StellarValue.StellarValueBuilder(txSetHash=" + this.txSetHash + ", closeTime=" + this.closeTime + ", upgrades=" + Arrays.deepToString(this.upgrades) + ", ext=" + this.ext + ")";
        }
    }

    public static class StellarValueExt
    implements XdrElement {
        private StellarValueType discriminant;
        private LedgerCloseValueSignature lcValueSignature;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case STELLAR_VALUE_BASIC: {
                    break;
                }
                case STELLAR_VALUE_SIGNED: {
                    this.lcValueSignature.encode(stream);
                }
            }
        }

        public static StellarValueExt decode(XdrDataInputStream stream) throws IOException {
            StellarValueExt decodedStellarValueExt = new StellarValueExt();
            StellarValueType discriminant = StellarValueType.decode(stream);
            decodedStellarValueExt.setDiscriminant(discriminant);
            switch (decodedStellarValueExt.getDiscriminant()) {
                case STELLAR_VALUE_BASIC: {
                    break;
                }
                case STELLAR_VALUE_SIGNED: {
                    decodedStellarValueExt.lcValueSignature = LedgerCloseValueSignature.decode(stream);
                }
            }
            return decodedStellarValueExt;
        }

        public static StellarValueExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return StellarValueExt.fromXdrByteArray(bytes);
        }

        public static StellarValueExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return StellarValueExt.decode(xdrDataInputStream);
        }

        @Generated
        public static StellarValueExtBuilder builder() {
            return new StellarValueExtBuilder();
        }

        @Generated
        public StellarValueExtBuilder toBuilder() {
            return new StellarValueExtBuilder().discriminant(this.discriminant).lcValueSignature(this.lcValueSignature);
        }

        @Generated
        public StellarValueType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public LedgerCloseValueSignature getLcValueSignature() {
            return this.lcValueSignature;
        }

        @Generated
        public void setDiscriminant(StellarValueType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setLcValueSignature(LedgerCloseValueSignature lcValueSignature) {
            this.lcValueSignature = lcValueSignature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StellarValueExt)) {
                return false;
            }
            StellarValueExt other = (StellarValueExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StellarValueType this$discriminant = this.getDiscriminant();
            StellarValueType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            LedgerCloseValueSignature this$lcValueSignature = this.getLcValueSignature();
            LedgerCloseValueSignature other$lcValueSignature = other.getLcValueSignature();
            return !(this$lcValueSignature == null ? other$lcValueSignature != null : !((Object)this$lcValueSignature).equals(other$lcValueSignature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StellarValueExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StellarValueType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            LedgerCloseValueSignature $lcValueSignature = this.getLcValueSignature();
            result = result * 59 + ($lcValueSignature == null ? 43 : ((Object)$lcValueSignature).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StellarValue.StellarValueExt(discriminant=" + this.getDiscriminant() + ", lcValueSignature=" + this.getLcValueSignature() + ")";
        }

        @Generated
        public StellarValueExt() {
        }

        @Generated
        public StellarValueExt(StellarValueType discriminant, LedgerCloseValueSignature lcValueSignature) {
            this.discriminant = discriminant;
            this.lcValueSignature = lcValueSignature;
        }

        @Generated
        public static class StellarValueExtBuilder {
            @Generated
            private StellarValueType discriminant;
            @Generated
            private LedgerCloseValueSignature lcValueSignature;

            @Generated
            StellarValueExtBuilder() {
            }

            @Generated
            public StellarValueExtBuilder discriminant(StellarValueType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public StellarValueExtBuilder lcValueSignature(LedgerCloseValueSignature lcValueSignature) {
                this.lcValueSignature = lcValueSignature;
                return this;
            }

            @Generated
            public StellarValueExt build() {
                return new StellarValueExt(this.discriminant, this.lcValueSignature);
            }

            @Generated
            public String toString() {
                return "StellarValue.StellarValueExt.StellarValueExtBuilder(discriminant=" + this.discriminant + ", lcValueSignature=" + this.lcValueSignature + ")";
            }
        }
    }
}

