/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Curve25519Public;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SurveyRequestMessage
implements XdrElement {
    private NodeID surveyorPeerID;
    private NodeID surveyedPeerID;
    private Uint32 ledgerNum;
    private Curve25519Public encryptionKey;
    private SurveyMessageCommandType commandType;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.surveyorPeerID.encode(stream);
        this.surveyedPeerID.encode(stream);
        this.ledgerNum.encode(stream);
        this.encryptionKey.encode(stream);
        this.commandType.encode(stream);
    }

    public static SurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        SurveyRequestMessage decodedSurveyRequestMessage = new SurveyRequestMessage();
        decodedSurveyRequestMessage.surveyorPeerID = NodeID.decode(stream);
        decodedSurveyRequestMessage.surveyedPeerID = NodeID.decode(stream);
        decodedSurveyRequestMessage.ledgerNum = Uint32.decode(stream);
        decodedSurveyRequestMessage.encryptionKey = Curve25519Public.decode(stream);
        decodedSurveyRequestMessage.commandType = SurveyMessageCommandType.decode(stream);
        return decodedSurveyRequestMessage;
    }

    public static SurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SurveyRequestMessage.fromXdrByteArray(bytes);
    }

    public static SurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SurveyRequestMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static SurveyRequestMessageBuilder builder() {
        return new SurveyRequestMessageBuilder();
    }

    @Generated
    public SurveyRequestMessageBuilder toBuilder() {
        return new SurveyRequestMessageBuilder().surveyorPeerID(this.surveyorPeerID).surveyedPeerID(this.surveyedPeerID).ledgerNum(this.ledgerNum).encryptionKey(this.encryptionKey).commandType(this.commandType);
    }

    @Generated
    public NodeID getSurveyorPeerID() {
        return this.surveyorPeerID;
    }

    @Generated
    public NodeID getSurveyedPeerID() {
        return this.surveyedPeerID;
    }

    @Generated
    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    @Generated
    public Curve25519Public getEncryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public SurveyMessageCommandType getCommandType() {
        return this.commandType;
    }

    @Generated
    public void setSurveyorPeerID(NodeID surveyorPeerID) {
        this.surveyorPeerID = surveyorPeerID;
    }

    @Generated
    public void setSurveyedPeerID(NodeID surveyedPeerID) {
        this.surveyedPeerID = surveyedPeerID;
    }

    @Generated
    public void setLedgerNum(Uint32 ledgerNum) {
        this.ledgerNum = ledgerNum;
    }

    @Generated
    public void setEncryptionKey(Curve25519Public encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Generated
    public void setCommandType(SurveyMessageCommandType commandType) {
        this.commandType = commandType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SurveyRequestMessage)) {
            return false;
        }
        SurveyRequestMessage other = (SurveyRequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$surveyorPeerID = this.getSurveyorPeerID();
        NodeID other$surveyorPeerID = other.getSurveyorPeerID();
        if (this$surveyorPeerID == null ? other$surveyorPeerID != null : !((Object)this$surveyorPeerID).equals(other$surveyorPeerID)) {
            return false;
        }
        NodeID this$surveyedPeerID = this.getSurveyedPeerID();
        NodeID other$surveyedPeerID = other.getSurveyedPeerID();
        if (this$surveyedPeerID == null ? other$surveyedPeerID != null : !((Object)this$surveyedPeerID).equals(other$surveyedPeerID)) {
            return false;
        }
        Uint32 this$ledgerNum = this.getLedgerNum();
        Uint32 other$ledgerNum = other.getLedgerNum();
        if (this$ledgerNum == null ? other$ledgerNum != null : !((Object)this$ledgerNum).equals(other$ledgerNum)) {
            return false;
        }
        Curve25519Public this$encryptionKey = this.getEncryptionKey();
        Curve25519Public other$encryptionKey = other.getEncryptionKey();
        if (this$encryptionKey == null ? other$encryptionKey != null : !((Object)this$encryptionKey).equals(other$encryptionKey)) {
            return false;
        }
        SurveyMessageCommandType this$commandType = this.getCommandType();
        SurveyMessageCommandType other$commandType = other.getCommandType();
        return !(this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SurveyRequestMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $surveyorPeerID = this.getSurveyorPeerID();
        result = result * 59 + ($surveyorPeerID == null ? 43 : ((Object)$surveyorPeerID).hashCode());
        NodeID $surveyedPeerID = this.getSurveyedPeerID();
        result = result * 59 + ($surveyedPeerID == null ? 43 : ((Object)$surveyedPeerID).hashCode());
        Uint32 $ledgerNum = this.getLedgerNum();
        result = result * 59 + ($ledgerNum == null ? 43 : ((Object)$ledgerNum).hashCode());
        Curve25519Public $encryptionKey = this.getEncryptionKey();
        result = result * 59 + ($encryptionKey == null ? 43 : ((Object)$encryptionKey).hashCode());
        SurveyMessageCommandType $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SurveyRequestMessage(surveyorPeerID=" + this.getSurveyorPeerID() + ", surveyedPeerID=" + this.getSurveyedPeerID() + ", ledgerNum=" + this.getLedgerNum() + ", encryptionKey=" + this.getEncryptionKey() + ", commandType=" + this.getCommandType() + ")";
    }

    @Generated
    public SurveyRequestMessage() {
    }

    @Generated
    public SurveyRequestMessage(NodeID surveyorPeerID, NodeID surveyedPeerID, Uint32 ledgerNum, Curve25519Public encryptionKey, SurveyMessageCommandType commandType) {
        this.surveyorPeerID = surveyorPeerID;
        this.surveyedPeerID = surveyedPeerID;
        this.ledgerNum = ledgerNum;
        this.encryptionKey = encryptionKey;
        this.commandType = commandType;
    }

    @Generated
    public static class SurveyRequestMessageBuilder {
        @Generated
        private NodeID surveyorPeerID;
        @Generated
        private NodeID surveyedPeerID;
        @Generated
        private Uint32 ledgerNum;
        @Generated
        private Curve25519Public encryptionKey;
        @Generated
        private SurveyMessageCommandType commandType;

        @Generated
        SurveyRequestMessageBuilder() {
        }

        @Generated
        public SurveyRequestMessageBuilder surveyorPeerID(NodeID surveyorPeerID) {
            this.surveyorPeerID = surveyorPeerID;
            return this;
        }

        @Generated
        public SurveyRequestMessageBuilder surveyedPeerID(NodeID surveyedPeerID) {
            this.surveyedPeerID = surveyedPeerID;
            return this;
        }

        @Generated
        public SurveyRequestMessageBuilder ledgerNum(Uint32 ledgerNum) {
            this.ledgerNum = ledgerNum;
            return this;
        }

        @Generated
        public SurveyRequestMessageBuilder encryptionKey(Curve25519Public encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Generated
        public SurveyRequestMessageBuilder commandType(SurveyMessageCommandType commandType) {
            this.commandType = commandType;
            return this;
        }

        @Generated
        public SurveyRequestMessage build() {
            return new SurveyRequestMessage(this.surveyorPeerID, this.surveyedPeerID, this.ledgerNum, this.encryptionKey, this.commandType);
        }

        @Generated
        public String toString() {
            return "SurveyRequestMessage.SurveyRequestMessageBuilder(surveyorPeerID=" + this.surveyorPeerID + ", surveyedPeerID=" + this.surveyedPeerID + ", ledgerNum=" + this.ledgerNum + ", encryptionKey=" + this.encryptionKey + ", commandType=" + this.commandType + ")";
        }
    }
}

