/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeBounds
implements XdrElement {
    private TimePoint minTime;
    private TimePoint maxTime;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.minTime.encode(stream);
        this.maxTime.encode(stream);
    }

    public static TimeBounds decode(XdrDataInputStream stream) throws IOException {
        TimeBounds decodedTimeBounds = new TimeBounds();
        decodedTimeBounds.minTime = TimePoint.decode(stream);
        decodedTimeBounds.maxTime = TimePoint.decode(stream);
        return decodedTimeBounds;
    }

    public static TimeBounds fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeBounds.fromXdrByteArray(bytes);
    }

    public static TimeBounds fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeBounds.decode(xdrDataInputStream);
    }

    @Generated
    public static TimeBoundsBuilder builder() {
        return new TimeBoundsBuilder();
    }

    @Generated
    public TimeBoundsBuilder toBuilder() {
        return new TimeBoundsBuilder().minTime(this.minTime).maxTime(this.maxTime);
    }

    @Generated
    public TimePoint getMinTime() {
        return this.minTime;
    }

    @Generated
    public TimePoint getMaxTime() {
        return this.maxTime;
    }

    @Generated
    public void setMinTime(TimePoint minTime) {
        this.minTime = minTime;
    }

    @Generated
    public void setMaxTime(TimePoint maxTime) {
        this.maxTime = maxTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeBounds)) {
            return false;
        }
        TimeBounds other = (TimeBounds)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimePoint this$minTime = this.getMinTime();
        TimePoint other$minTime = other.getMinTime();
        if (this$minTime == null ? other$minTime != null : !((Object)this$minTime).equals(other$minTime)) {
            return false;
        }
        TimePoint this$maxTime = this.getMaxTime();
        TimePoint other$maxTime = other.getMaxTime();
        return !(this$maxTime == null ? other$maxTime != null : !((Object)this$maxTime).equals(other$maxTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeBounds;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimePoint $minTime = this.getMinTime();
        result = result * 59 + ($minTime == null ? 43 : ((Object)$minTime).hashCode());
        TimePoint $maxTime = this.getMaxTime();
        result = result * 59 + ($maxTime == null ? 43 : ((Object)$maxTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeBounds(minTime=" + this.getMinTime() + ", maxTime=" + this.getMaxTime() + ")";
    }

    @Generated
    public TimeBounds() {
    }

    @Generated
    public TimeBounds(TimePoint minTime, TimePoint maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    @Generated
    public static class TimeBoundsBuilder {
        @Generated
        private TimePoint minTime;
        @Generated
        private TimePoint maxTime;

        @Generated
        TimeBoundsBuilder() {
        }

        @Generated
        public TimeBoundsBuilder minTime(TimePoint minTime) {
            this.minTime = minTime;
            return this;
        }

        @Generated
        public TimeBoundsBuilder maxTime(TimePoint maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        @Generated
        public TimeBounds build() {
            return new TimeBounds(this.minTime, this.maxTime);
        }

        @Generated
        public String toString() {
            return "TimeBounds.TimeBoundsBuilder(minTime=" + this.minTime + ", maxTime=" + this.maxTime + ")";
        }
    }
}

