/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PeerStats;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeSlicedPeerData
implements XdrElement {
    private PeerStats peerStats;
    private Uint32 averageLatencyMs;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.peerStats.encode(stream);
        this.averageLatencyMs.encode(stream);
    }

    public static TimeSlicedPeerData decode(XdrDataInputStream stream) throws IOException {
        TimeSlicedPeerData decodedTimeSlicedPeerData = new TimeSlicedPeerData();
        decodedTimeSlicedPeerData.peerStats = PeerStats.decode(stream);
        decodedTimeSlicedPeerData.averageLatencyMs = Uint32.decode(stream);
        return decodedTimeSlicedPeerData;
    }

    public static TimeSlicedPeerData fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeSlicedPeerData.fromXdrByteArray(bytes);
    }

    public static TimeSlicedPeerData fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeSlicedPeerData.decode(xdrDataInputStream);
    }

    @Generated
    public static TimeSlicedPeerDataBuilder builder() {
        return new TimeSlicedPeerDataBuilder();
    }

    @Generated
    public TimeSlicedPeerDataBuilder toBuilder() {
        return new TimeSlicedPeerDataBuilder().peerStats(this.peerStats).averageLatencyMs(this.averageLatencyMs);
    }

    @Generated
    public PeerStats getPeerStats() {
        return this.peerStats;
    }

    @Generated
    public Uint32 getAverageLatencyMs() {
        return this.averageLatencyMs;
    }

    @Generated
    public void setPeerStats(PeerStats peerStats) {
        this.peerStats = peerStats;
    }

    @Generated
    public void setAverageLatencyMs(Uint32 averageLatencyMs) {
        this.averageLatencyMs = averageLatencyMs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSlicedPeerData)) {
            return false;
        }
        TimeSlicedPeerData other = (TimeSlicedPeerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PeerStats this$peerStats = this.getPeerStats();
        PeerStats other$peerStats = other.getPeerStats();
        if (this$peerStats == null ? other$peerStats != null : !((Object)this$peerStats).equals(other$peerStats)) {
            return false;
        }
        Uint32 this$averageLatencyMs = this.getAverageLatencyMs();
        Uint32 other$averageLatencyMs = other.getAverageLatencyMs();
        return !(this$averageLatencyMs == null ? other$averageLatencyMs != null : !((Object)this$averageLatencyMs).equals(other$averageLatencyMs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSlicedPeerData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PeerStats $peerStats = this.getPeerStats();
        result = result * 59 + ($peerStats == null ? 43 : ((Object)$peerStats).hashCode());
        Uint32 $averageLatencyMs = this.getAverageLatencyMs();
        result = result * 59 + ($averageLatencyMs == null ? 43 : ((Object)$averageLatencyMs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeSlicedPeerData(peerStats=" + this.getPeerStats() + ", averageLatencyMs=" + this.getAverageLatencyMs() + ")";
    }

    @Generated
    public TimeSlicedPeerData() {
    }

    @Generated
    public TimeSlicedPeerData(PeerStats peerStats, Uint32 averageLatencyMs) {
        this.peerStats = peerStats;
        this.averageLatencyMs = averageLatencyMs;
    }

    @Generated
    public static class TimeSlicedPeerDataBuilder {
        @Generated
        private PeerStats peerStats;
        @Generated
        private Uint32 averageLatencyMs;

        @Generated
        TimeSlicedPeerDataBuilder() {
        }

        @Generated
        public TimeSlicedPeerDataBuilder peerStats(PeerStats peerStats) {
            this.peerStats = peerStats;
            return this;
        }

        @Generated
        public TimeSlicedPeerDataBuilder averageLatencyMs(Uint32 averageLatencyMs) {
            this.averageLatencyMs = averageLatencyMs;
            return this;
        }

        @Generated
        public TimeSlicedPeerData build() {
            return new TimeSlicedPeerData(this.peerStats, this.averageLatencyMs);
        }

        @Generated
        public String toString() {
            return "TimeSlicedPeerData.TimeSlicedPeerDataBuilder(peerStats=" + this.peerStats + ", averageLatencyMs=" + this.averageLatencyMs + ")";
        }
    }
}

