/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.TransactionMetaV1;
import org.stellar.sdk.xdr.TransactionMetaV2;
import org.stellar.sdk.xdr.TransactionMetaV3;
import org.stellar.sdk.xdr.TransactionMetaV4;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMeta
implements XdrElement {
    private Integer discriminant;
    private OperationMeta[] operations;
    private TransactionMetaV1 v1;
    private TransactionMetaV2 v2;
    private TransactionMetaV3 v3;
    private TransactionMetaV4 v4;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant);
        switch (this.discriminant) {
            case 0: {
                int operationsSize = this.getOperations().length;
                stream.writeInt(operationsSize);
                for (int i = 0; i < operationsSize; ++i) {
                    this.operations[i].encode(stream);
                }
                break;
            }
            case 1: {
                this.v1.encode(stream);
                break;
            }
            case 2: {
                this.v2.encode(stream);
                break;
            }
            case 3: {
                this.v3.encode(stream);
                break;
            }
            case 4: {
                this.v4.encode(stream);
            }
        }
    }

    public static TransactionMeta decode(XdrDataInputStream stream) throws IOException {
        TransactionMeta decodedTransactionMeta = new TransactionMeta();
        Integer discriminant = stream.readInt();
        decodedTransactionMeta.setDiscriminant(discriminant);
        switch (decodedTransactionMeta.getDiscriminant()) {
            case 0: {
                int operationsSize = stream.readInt();
                decodedTransactionMeta.operations = new OperationMeta[operationsSize];
                for (int i = 0; i < operationsSize; ++i) {
                    decodedTransactionMeta.operations[i] = OperationMeta.decode(stream);
                }
                break;
            }
            case 1: {
                decodedTransactionMeta.v1 = TransactionMetaV1.decode(stream);
                break;
            }
            case 2: {
                decodedTransactionMeta.v2 = TransactionMetaV2.decode(stream);
                break;
            }
            case 3: {
                decodedTransactionMeta.v3 = TransactionMetaV3.decode(stream);
                break;
            }
            case 4: {
                decodedTransactionMeta.v4 = TransactionMetaV4.decode(stream);
            }
        }
        return decodedTransactionMeta;
    }

    public static TransactionMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMeta.fromXdrByteArray(bytes);
    }

    public static TransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMeta.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionMetaBuilder builder() {
        return new TransactionMetaBuilder();
    }

    @Generated
    public TransactionMetaBuilder toBuilder() {
        return new TransactionMetaBuilder().discriminant(this.discriminant).operations(this.operations).v1(this.v1).v2(this.v2).v3(this.v3).v4(this.v4);
    }

    @Generated
    public Integer getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public OperationMeta[] getOperations() {
        return this.operations;
    }

    @Generated
    public TransactionMetaV1 getV1() {
        return this.v1;
    }

    @Generated
    public TransactionMetaV2 getV2() {
        return this.v2;
    }

    @Generated
    public TransactionMetaV3 getV3() {
        return this.v3;
    }

    @Generated
    public TransactionMetaV4 getV4() {
        return this.v4;
    }

    @Generated
    public void setDiscriminant(Integer discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setOperations(OperationMeta[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setV1(TransactionMetaV1 v1) {
        this.v1 = v1;
    }

    @Generated
    public void setV2(TransactionMetaV2 v2) {
        this.v2 = v2;
    }

    @Generated
    public void setV3(TransactionMetaV3 v3) {
        this.v3 = v3;
    }

    @Generated
    public void setV4(TransactionMetaV4 v4) {
        this.v4 = v4;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMeta)) {
            return false;
        }
        TransactionMeta other = (TransactionMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$discriminant = this.getDiscriminant();
        Integer other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        TransactionMetaV1 this$v1 = this.getV1();
        TransactionMetaV1 other$v1 = other.getV1();
        if (this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1)) {
            return false;
        }
        TransactionMetaV2 this$v2 = this.getV2();
        TransactionMetaV2 other$v2 = other.getV2();
        if (this$v2 == null ? other$v2 != null : !((Object)this$v2).equals(other$v2)) {
            return false;
        }
        TransactionMetaV3 this$v3 = this.getV3();
        TransactionMetaV3 other$v3 = other.getV3();
        if (this$v3 == null ? other$v3 != null : !((Object)this$v3).equals(other$v3)) {
            return false;
        }
        TransactionMetaV4 this$v4 = this.getV4();
        TransactionMetaV4 other$v4 = other.getV4();
        return !(this$v4 == null ? other$v4 != null : !((Object)this$v4).equals(other$v4));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        TransactionMetaV1 $v1 = this.getV1();
        result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
        TransactionMetaV2 $v2 = this.getV2();
        result = result * 59 + ($v2 == null ? 43 : ((Object)$v2).hashCode());
        TransactionMetaV3 $v3 = this.getV3();
        result = result * 59 + ($v3 == null ? 43 : ((Object)$v3).hashCode());
        TransactionMetaV4 $v4 = this.getV4();
        result = result * 59 + ($v4 == null ? 43 : ((Object)$v4).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionMeta(discriminant=" + this.getDiscriminant() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", v1=" + this.getV1() + ", v2=" + this.getV2() + ", v3=" + this.getV3() + ", v4=" + this.getV4() + ")";
    }

    @Generated
    public TransactionMeta() {
    }

    @Generated
    public TransactionMeta(Integer discriminant, OperationMeta[] operations, TransactionMetaV1 v1, TransactionMetaV2 v2, TransactionMetaV3 v3, TransactionMetaV4 v4) {
        this.discriminant = discriminant;
        this.operations = operations;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.v4 = v4;
    }

    @Generated
    public static class TransactionMetaBuilder {
        @Generated
        private Integer discriminant;
        @Generated
        private OperationMeta[] operations;
        @Generated
        private TransactionMetaV1 v1;
        @Generated
        private TransactionMetaV2 v2;
        @Generated
        private TransactionMetaV3 v3;
        @Generated
        private TransactionMetaV4 v4;

        @Generated
        TransactionMetaBuilder() {
        }

        @Generated
        public TransactionMetaBuilder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public TransactionMetaBuilder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionMetaBuilder v1(TransactionMetaV1 v1) {
            this.v1 = v1;
            return this;
        }

        @Generated
        public TransactionMetaBuilder v2(TransactionMetaV2 v2) {
            this.v2 = v2;
            return this;
        }

        @Generated
        public TransactionMetaBuilder v3(TransactionMetaV3 v3) {
            this.v3 = v3;
            return this;
        }

        @Generated
        public TransactionMetaBuilder v4(TransactionMetaV4 v4) {
            this.v4 = v4;
            return this;
        }

        @Generated
        public TransactionMeta build() {
            return new TransactionMeta(this.discriminant, this.operations, this.v1, this.v2, this.v3, this.v4);
        }

        @Generated
        public String toString() {
            return "TransactionMeta.TransactionMetaBuilder(discriminant=" + this.discriminant + ", operations=" + Arrays.deepToString(this.operations) + ", v1=" + this.v1 + ", v2=" + this.v2 + ", v3=" + this.v3 + ", v4=" + this.v4 + ")";
        }
    }
}

