/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class UInt128Parts
implements XdrElement {
    private Uint64 hi;
    private Uint64 lo;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.hi.encode(stream);
        this.lo.encode(stream);
    }

    public static UInt128Parts decode(XdrDataInputStream stream) throws IOException {
        UInt128Parts decodedUInt128Parts = new UInt128Parts();
        decodedUInt128Parts.hi = Uint64.decode(stream);
        decodedUInt128Parts.lo = Uint64.decode(stream);
        return decodedUInt128Parts;
    }

    public static UInt128Parts fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return UInt128Parts.fromXdrByteArray(bytes);
    }

    public static UInt128Parts fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return UInt128Parts.decode(xdrDataInputStream);
    }

    @Generated
    public static UInt128PartsBuilder builder() {
        return new UInt128PartsBuilder();
    }

    @Generated
    public UInt128PartsBuilder toBuilder() {
        return new UInt128PartsBuilder().hi(this.hi).lo(this.lo);
    }

    @Generated
    public Uint64 getHi() {
        return this.hi;
    }

    @Generated
    public Uint64 getLo() {
        return this.lo;
    }

    @Generated
    public void setHi(Uint64 hi) {
        this.hi = hi;
    }

    @Generated
    public void setLo(Uint64 lo) {
        this.lo = lo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UInt128Parts)) {
            return false;
        }
        UInt128Parts other = (UInt128Parts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint64 this$hi = this.getHi();
        Uint64 other$hi = other.getHi();
        if (this$hi == null ? other$hi != null : !((Object)this$hi).equals(other$hi)) {
            return false;
        }
        Uint64 this$lo = this.getLo();
        Uint64 other$lo = other.getLo();
        return !(this$lo == null ? other$lo != null : !((Object)this$lo).equals(other$lo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UInt128Parts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint64 $hi = this.getHi();
        result = result * 59 + ($hi == null ? 43 : ((Object)$hi).hashCode());
        Uint64 $lo = this.getLo();
        result = result * 59 + ($lo == null ? 43 : ((Object)$lo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UInt128Parts(hi=" + this.getHi() + ", lo=" + this.getLo() + ")";
    }

    @Generated
    public UInt128Parts() {
    }

    @Generated
    public UInt128Parts(Uint64 hi, Uint64 lo) {
        this.hi = hi;
        this.lo = lo;
    }

    @Generated
    public static class UInt128PartsBuilder {
        @Generated
        private Uint64 hi;
        @Generated
        private Uint64 lo;

        @Generated
        UInt128PartsBuilder() {
        }

        @Generated
        public UInt128PartsBuilder hi(Uint64 hi) {
            this.hi = hi;
            return this;
        }

        @Generated
        public UInt128PartsBuilder lo(Uint64 lo) {
            this.lo = lo;
            return this;
        }

        @Generated
        public UInt128Parts build() {
            return new UInt128Parts(this.hi, this.lo);
        }

        @Generated
        public String toString() {
            return "UInt128Parts.UInt128PartsBuilder(hi=" + this.hi + ", lo=" + this.lo + ")";
        }
    }
}

