/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.SLIP10;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.PublicKey;
import org.stellar.sdk.xdr.PublicKeyType;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataOutputStream;

public class KeyPair {
    @NonNull
    private final Ed25519PublicKeyParameters publicKey;
    @Nullable
    private final Ed25519PrivateKeyParameters privateKey;

    private KeyPair(@NonNull Ed25519PublicKeyParameters publicKey, @Nullable Ed25519PrivateKeyParameters privateKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public boolean canSign() {
        return this.privateKey != null;
    }

    public static KeyPair fromSecretSeed(char[] seed) {
        byte[] decoded = StrKey.decodeEd25519SecretSeed(seed);
        return KeyPair.fromSecretSeed(decoded);
    }

    public static KeyPair fromSecretSeed(String seed) {
        char[] charSeed = seed.toCharArray();
        KeyPair keypair = KeyPair.fromSecretSeed(charSeed);
        Arrays.fill(charSeed, '\u0000');
        return keypair;
    }

    public static KeyPair fromSecretSeed(byte[] seed) {
        Ed25519PrivateKeyParameters privateKey;
        try {
            privateKey = new Ed25519PrivateKeyParameters(seed, 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Secret seed is invalid", e);
        }
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public static KeyPair fromAccountId(String accountId) {
        byte[] decoded = StrKey.decodeEd25519PublicKey(accountId);
        return KeyPair.fromPublicKey(decoded);
    }

    public static KeyPair fromPublicKey(byte[] publicKey) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters;
        try {
            ed25519PublicKeyParameters = new Ed25519PublicKeyParameters(publicKey, 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Public key is invalid", e);
        }
        return new KeyPair(ed25519PublicKeyParameters, null);
    }

    public static KeyPair fromBip39Seed(byte[] bip39Seed, int accountNumber) {
        try {
            return KeyPair.fromSecretSeed(SLIP10.deriveEd25519PrivateKey(bip39Seed, 44, 148, accountNumber));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyPair random() {
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(new SecureRandom());
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    public String getAccountId() {
        return StrKey.encodeEd25519PublicKey(this.getPublicKey());
    }

    public char[] getSecretSeed() {
        if (this.privateKey == null) {
            return null;
        }
        return StrKey.encodeEd25519SecretSeed(this.privateKey.getEncoded());
    }

    public byte[] getPublicKey() {
        return this.publicKey.getEncoded();
    }

    public SignatureHint getSignatureHint() {
        ByteArrayOutputStream publicKeyBytesStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(publicKeyBytesStream);
        try {
            this.getXdrPublicKey().encode(xdrOutputStream);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        byte[] publicKeyBytes = publicKeyBytesStream.toByteArray();
        byte[] signatureHintBytes = Arrays.copyOfRange(publicKeyBytes, publicKeyBytes.length - 4, publicKeyBytes.length);
        SignatureHint signatureHint = new SignatureHint();
        signatureHint.setSignatureHint(signatureHintBytes);
        return signatureHint;
    }

    public PublicKey getXdrPublicKey() {
        PublicKey publicKey = new PublicKey();
        publicKey.setDiscriminant(PublicKeyType.PUBLIC_KEY_TYPE_ED25519);
        Uint256 uint256 = new Uint256();
        uint256.setUint256(this.getPublicKey());
        publicKey.setEd25519(uint256);
        return publicKey;
    }

    public AccountID getXdrAccountId() {
        AccountID accountID = new AccountID();
        accountID.setAccountID(this.getXdrPublicKey());
        return accountID;
    }

    public static KeyPair fromXdrPublicKey(PublicKey key) {
        return KeyPair.fromPublicKey(key.getEd25519().getUint256());
    }

    public byte[] sign(byte[] data) {
        if (this.privateKey == null) {
            throw new IllegalStateException("KeyPair does not contain secret key. Use KeyPair.fromSecretSeed method to create a new KeyPair with a secret key.");
        }
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)this.privateKey);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public DecoratedSignature signDecorated(byte[] data) {
        byte[] signatureBytes = this.sign(data);
        Signature signature = new Signature();
        signature.setSignature(signatureBytes);
        DecoratedSignature decoratedSignature = new DecoratedSignature();
        decoratedSignature.setHint(this.getSignatureHint());
        decoratedSignature.setSignature(signature);
        return decoratedSignature;
    }

    public DecoratedSignature signPayloadDecorated(byte[] signerPayload) {
        DecoratedSignature payloadSignature = this.signDecorated(signerPayload);
        byte[] hint = new byte[4];
        if (signerPayload.length >= hint.length) {
            System.arraycopy(signerPayload, signerPayload.length - hint.length, hint, 0, hint.length);
        } else {
            System.arraycopy(signerPayload, 0, hint, 0, signerPayload.length);
        }
        for (int i = 0; i < hint.length; ++i) {
            int n = i;
            hint[n] = (byte)(hint[n] ^ payloadSignature.getHint().getSignatureHint()[i]);
        }
        payloadSignature.getHint().setSignatureHint(hint);
        return payloadSignature;
    }

    public boolean verify(byte[] data, byte[] signature) {
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)this.publicKey);
        verifier.update(data, 0, data.length);
        return verifier.verifySignature(signature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KeyPair keyPair = (KeyPair)object;
        if (!Arrays.equals(this.publicKey.getEncoded(), keyPair.publicKey.getEncoded())) {
            return false;
        }
        return Arrays.equals(this.privateKey == null ? null : this.privateKey.getEncoded(), keyPair.privateKey == null ? null : keyPair.privateKey.getEncoded());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.publicKey.getEncoded()), this.privateKey == null ? null : Integer.valueOf(Arrays.hashCode(this.privateKey.getEncoded())));
    }

    private static byte[] calculateMessageHash(byte[] message) {
        byte[] messagePrefix = "Stellar Signed Message:\n".getBytes(StandardCharsets.UTF_8);
        byte[] signedMessageBase = new byte[messagePrefix.length + message.length];
        System.arraycopy(messagePrefix, 0, signedMessageBase, 0, messagePrefix.length);
        System.arraycopy(message, 0, signedMessageBase, messagePrefix.length, message.length);
        return Util.hash(signedMessageBase);
    }

    public byte[] signMessage(String message) {
        return this.signMessage(message.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] signMessage(byte[] message) {
        byte[] messageHash = KeyPair.calculateMessageHash(message);
        return this.sign(messageHash);
    }

    public boolean verifyMessage(byte[] message, byte[] signature) {
        byte[] messageHash = KeyPair.calculateMessageHash(message);
        return this.verify(messageHash, signature);
    }

    public boolean verifyMessage(String message, byte[] signature) {
        return this.verifyMessage(message.getBytes(StandardCharsets.UTF_8), signature);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

