/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.SignerKey;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrString;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class SetOptionsOperation
extends Operation {
    @Nullable
    private final String inflationDestination;
    @Nullable
    private final Integer clearFlags;
    @Nullable
    private final Integer setFlags;
    @Nullable
    private final Integer masterKeyWeight;
    @Nullable
    private final Integer lowThreshold;
    @Nullable
    private final Integer mediumThreshold;
    @Nullable
    private final Integer highThreshold;
    @Nullable
    private final String homeDomain;
    @Nullable
    private final SignerKey signer;
    @Nullable
    private final Integer signerWeight;

    public static SetOptionsOperation fromXdr(SetOptionsOp op) {
        SetOptionsOperationBuilder<?, ?> builder = SetOptionsOperation.builder();
        if (op.getInflationDest() != null) {
            builder.inflationDestination(StrKey.encodeEd25519PublicKey(op.getInflationDest().getAccountID().getEd25519().getUint256()));
        }
        if (op.getClearFlags() != null) {
            builder.clearFlags(op.getClearFlags().getUint32().getNumber().intValue());
        }
        if (op.getSetFlags() != null) {
            builder.setFlags(op.getSetFlags().getUint32().getNumber().intValue());
        }
        if (op.getMasterWeight() != null) {
            builder.masterKeyWeight(op.getMasterWeight().getUint32().getNumber().intValue());
        }
        if (op.getLowThreshold() != null) {
            builder.lowThreshold(op.getLowThreshold().getUint32().getNumber().intValue());
        }
        if (op.getMedThreshold() != null) {
            builder.mediumThreshold(op.getMedThreshold().getUint32().getNumber().intValue());
        }
        if (op.getHighThreshold() != null) {
            builder.highThreshold(op.getHighThreshold().getUint32().getNumber().intValue());
        }
        if (op.getHomeDomain() != null) {
            builder.homeDomain(op.getHomeDomain().getString32().toString());
        }
        if (op.getSigner() != null) {
            builder.signer(SignerKey.fromXdr(op.getSigner().getKey()));
            builder.signerWeight(op.getSigner().getWeight().getUint32().getNumber().intValue());
        }
        return builder.build();
    }

    @Override
    Operation.OperationBody toOperationBody() {
        Uint32 uint32;
        SetOptionsOp op = new SetOptionsOp();
        if (this.inflationDestination != null) {
            op.setInflationDest(KeyPair.fromAccountId(this.inflationDestination).getXdrAccountId());
        }
        if (this.clearFlags != null) {
            Uint32 clearFlags = new Uint32();
            clearFlags.setUint32(new XdrUnsignedInteger(this.clearFlags));
            op.setClearFlags(clearFlags);
        }
        if (this.setFlags != null) {
            Uint32 setFlags = new Uint32();
            setFlags.setUint32(new XdrUnsignedInteger(this.setFlags));
            op.setSetFlags(setFlags);
        }
        if (this.masterKeyWeight != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.masterKeyWeight));
            op.setMasterWeight(uint32);
        }
        if (this.lowThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.lowThreshold));
            op.setLowThreshold(uint32);
        }
        if (this.mediumThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.mediumThreshold));
            op.setMedThreshold(uint32);
        }
        if (this.highThreshold != null) {
            uint32 = new Uint32();
            uint32.setUint32(new XdrUnsignedInteger(this.highThreshold));
            op.setHighThreshold(uint32);
        }
        if (this.homeDomain != null) {
            String32 homeDomain = new String32();
            homeDomain.setString32(new XdrString(this.homeDomain));
            op.setHomeDomain(homeDomain);
        }
        if (this.signer != null && this.signerWeight != null) {
            Signer signer = new Signer();
            Uint32 weight = new Uint32();
            weight.setUint32(new XdrUnsignedInteger(this.signerWeight));
            signer.setKey(this.signer.toXdr());
            signer.setWeight(weight);
            op.setSigner(signer);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.SET_OPTIONS);
        body.setSetOptionsOp(op);
        return body;
    }

    @Generated
    protected SetOptionsOperation(SetOptionsOperationBuilder<?, ?> b) {
        super(b);
        this.inflationDestination = ((SetOptionsOperationBuilder)b).inflationDestination;
        this.clearFlags = ((SetOptionsOperationBuilder)b).clearFlags;
        this.setFlags = ((SetOptionsOperationBuilder)b).setFlags;
        this.masterKeyWeight = ((SetOptionsOperationBuilder)b).masterKeyWeight;
        this.lowThreshold = ((SetOptionsOperationBuilder)b).lowThreshold;
        this.mediumThreshold = ((SetOptionsOperationBuilder)b).mediumThreshold;
        this.highThreshold = ((SetOptionsOperationBuilder)b).highThreshold;
        this.homeDomain = ((SetOptionsOperationBuilder)b).homeDomain;
        this.signer = ((SetOptionsOperationBuilder)b).signer;
        this.signerWeight = ((SetOptionsOperationBuilder)b).signerWeight;
    }

    @Generated
    public static SetOptionsOperationBuilder<?, ?> builder() {
        return new SetOptionsOperationBuilderImpl();
    }

    @Generated
    public SetOptionsOperationBuilder<?, ?> toBuilder() {
        return new SetOptionsOperationBuilderImpl().$fillValuesFrom(this);
    }

    @Nullable
    @Generated
    public String getInflationDestination() {
        return this.inflationDestination;
    }

    @Nullable
    @Generated
    public Integer getClearFlags() {
        return this.clearFlags;
    }

    @Nullable
    @Generated
    public Integer getSetFlags() {
        return this.setFlags;
    }

    @Nullable
    @Generated
    public Integer getMasterKeyWeight() {
        return this.masterKeyWeight;
    }

    @Nullable
    @Generated
    public Integer getLowThreshold() {
        return this.lowThreshold;
    }

    @Nullable
    @Generated
    public Integer getMediumThreshold() {
        return this.mediumThreshold;
    }

    @Nullable
    @Generated
    public Integer getHighThreshold() {
        return this.highThreshold;
    }

    @Nullable
    @Generated
    public String getHomeDomain() {
        return this.homeDomain;
    }

    @Nullable
    @Generated
    public SignerKey getSigner() {
        return this.signer;
    }

    @Nullable
    @Generated
    public Integer getSignerWeight() {
        return this.signerWeight;
    }

    @Generated
    public String toString() {
        return "SetOptionsOperation(super=" + super.toString() + ", inflationDestination=" + this.getInflationDestination() + ", clearFlags=" + this.getClearFlags() + ", setFlags=" + this.getSetFlags() + ", masterKeyWeight=" + this.getMasterKeyWeight() + ", lowThreshold=" + this.getLowThreshold() + ", mediumThreshold=" + this.getMediumThreshold() + ", highThreshold=" + this.getHighThreshold() + ", homeDomain=" + this.getHomeDomain() + ", signer=" + this.getSigner() + ", signerWeight=" + this.getSignerWeight() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetOptionsOperation)) {
            return false;
        }
        SetOptionsOperation other = (SetOptionsOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$clearFlags = this.getClearFlags();
        Integer other$clearFlags = other.getClearFlags();
        if (this$clearFlags == null ? other$clearFlags != null : !((Object)this$clearFlags).equals(other$clearFlags)) {
            return false;
        }
        Integer this$setFlags = this.getSetFlags();
        Integer other$setFlags = other.getSetFlags();
        if (this$setFlags == null ? other$setFlags != null : !((Object)this$setFlags).equals(other$setFlags)) {
            return false;
        }
        Integer this$masterKeyWeight = this.getMasterKeyWeight();
        Integer other$masterKeyWeight = other.getMasterKeyWeight();
        if (this$masterKeyWeight == null ? other$masterKeyWeight != null : !((Object)this$masterKeyWeight).equals(other$masterKeyWeight)) {
            return false;
        }
        Integer this$lowThreshold = this.getLowThreshold();
        Integer other$lowThreshold = other.getLowThreshold();
        if (this$lowThreshold == null ? other$lowThreshold != null : !((Object)this$lowThreshold).equals(other$lowThreshold)) {
            return false;
        }
        Integer this$mediumThreshold = this.getMediumThreshold();
        Integer other$mediumThreshold = other.getMediumThreshold();
        if (this$mediumThreshold == null ? other$mediumThreshold != null : !((Object)this$mediumThreshold).equals(other$mediumThreshold)) {
            return false;
        }
        Integer this$highThreshold = this.getHighThreshold();
        Integer other$highThreshold = other.getHighThreshold();
        if (this$highThreshold == null ? other$highThreshold != null : !((Object)this$highThreshold).equals(other$highThreshold)) {
            return false;
        }
        Integer this$signerWeight = this.getSignerWeight();
        Integer other$signerWeight = other.getSignerWeight();
        if (this$signerWeight == null ? other$signerWeight != null : !((Object)this$signerWeight).equals(other$signerWeight)) {
            return false;
        }
        String this$inflationDestination = this.getInflationDestination();
        String other$inflationDestination = other.getInflationDestination();
        if (this$inflationDestination == null ? other$inflationDestination != null : !this$inflationDestination.equals(other$inflationDestination)) {
            return false;
        }
        String this$homeDomain = this.getHomeDomain();
        String other$homeDomain = other.getHomeDomain();
        if (this$homeDomain == null ? other$homeDomain != null : !this$homeDomain.equals(other$homeDomain)) {
            return false;
        }
        SignerKey this$signer = this.getSigner();
        SignerKey other$signer = other.getSigner();
        return !(this$signer == null ? other$signer != null : !((Object)this$signer).equals(other$signer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetOptionsOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $clearFlags = this.getClearFlags();
        result = result * 59 + ($clearFlags == null ? 43 : ((Object)$clearFlags).hashCode());
        Integer $setFlags = this.getSetFlags();
        result = result * 59 + ($setFlags == null ? 43 : ((Object)$setFlags).hashCode());
        Integer $masterKeyWeight = this.getMasterKeyWeight();
        result = result * 59 + ($masterKeyWeight == null ? 43 : ((Object)$masterKeyWeight).hashCode());
        Integer $lowThreshold = this.getLowThreshold();
        result = result * 59 + ($lowThreshold == null ? 43 : ((Object)$lowThreshold).hashCode());
        Integer $mediumThreshold = this.getMediumThreshold();
        result = result * 59 + ($mediumThreshold == null ? 43 : ((Object)$mediumThreshold).hashCode());
        Integer $highThreshold = this.getHighThreshold();
        result = result * 59 + ($highThreshold == null ? 43 : ((Object)$highThreshold).hashCode());
        Integer $signerWeight = this.getSignerWeight();
        result = result * 59 + ($signerWeight == null ? 43 : ((Object)$signerWeight).hashCode());
        String $inflationDestination = this.getInflationDestination();
        result = result * 59 + ($inflationDestination == null ? 43 : $inflationDestination.hashCode());
        String $homeDomain = this.getHomeDomain();
        result = result * 59 + ($homeDomain == null ? 43 : $homeDomain.hashCode());
        SignerKey $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : ((Object)$signer).hashCode());
        return result;
    }

    @Generated
    private SetOptionsOperation(@Nullable String inflationDestination, @Nullable Integer clearFlags, @Nullable Integer setFlags, @Nullable Integer masterKeyWeight, @Nullable Integer lowThreshold, @Nullable Integer mediumThreshold, @Nullable Integer highThreshold, @Nullable String homeDomain, @Nullable SignerKey signer, @Nullable Integer signerWeight) {
        this.inflationDestination = inflationDestination;
        this.clearFlags = clearFlags;
        this.setFlags = setFlags;
        this.masterKeyWeight = masterKeyWeight;
        this.lowThreshold = lowThreshold;
        this.mediumThreshold = mediumThreshold;
        this.highThreshold = highThreshold;
        this.homeDomain = homeDomain;
        this.signer = signer;
        this.signerWeight = signerWeight;
    }

    @Generated
    public static abstract class SetOptionsOperationBuilder<C extends SetOptionsOperation, B extends SetOptionsOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String inflationDestination;
        @Generated
        private Integer clearFlags;
        @Generated
        private Integer setFlags;
        @Generated
        private Integer masterKeyWeight;
        @Generated
        private Integer lowThreshold;
        @Generated
        private Integer mediumThreshold;
        @Generated
        private Integer highThreshold;
        @Generated
        private String homeDomain;
        @Generated
        private SignerKey signer;
        @Generated
        private Integer signerWeight;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetOptionsOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SetOptionsOperation instance, SetOptionsOperationBuilder<?, ?> b) {
            b.inflationDestination(instance.inflationDestination);
            b.clearFlags(instance.clearFlags);
            b.setFlags(instance.setFlags);
            b.masterKeyWeight(instance.masterKeyWeight);
            b.lowThreshold(instance.lowThreshold);
            b.mediumThreshold(instance.mediumThreshold);
            b.highThreshold(instance.highThreshold);
            b.homeDomain(instance.homeDomain);
            b.signer(instance.signer);
            b.signerWeight(instance.signerWeight);
        }

        @Generated
        public B inflationDestination(@Nullable String inflationDestination) {
            this.inflationDestination = inflationDestination;
            return (B)this.self();
        }

        @Generated
        public B clearFlags(@Nullable Integer clearFlags) {
            this.clearFlags = clearFlags;
            return (B)this.self();
        }

        @Generated
        public B setFlags(@Nullable Integer setFlags) {
            this.setFlags = setFlags;
            return (B)this.self();
        }

        @Generated
        public B masterKeyWeight(@Nullable Integer masterKeyWeight) {
            this.masterKeyWeight = masterKeyWeight;
            return (B)this.self();
        }

        @Generated
        public B lowThreshold(@Nullable Integer lowThreshold) {
            this.lowThreshold = lowThreshold;
            return (B)this.self();
        }

        @Generated
        public B mediumThreshold(@Nullable Integer mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
            return (B)this.self();
        }

        @Generated
        public B highThreshold(@Nullable Integer highThreshold) {
            this.highThreshold = highThreshold;
            return (B)this.self();
        }

        @Generated
        public B homeDomain(@Nullable String homeDomain) {
            this.homeDomain = homeDomain;
            return (B)this.self();
        }

        @Generated
        public B signer(@Nullable SignerKey signer) {
            this.signer = signer;
            return (B)this.self();
        }

        @Generated
        public B signerWeight(@Nullable Integer signerWeight) {
            this.signerWeight = signerWeight;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetOptionsOperation.SetOptionsOperationBuilder(super=" + super.toString() + ", inflationDestination=" + this.inflationDestination + ", clearFlags=" + this.clearFlags + ", setFlags=" + this.setFlags + ", masterKeyWeight=" + this.masterKeyWeight + ", lowThreshold=" + this.lowThreshold + ", mediumThreshold=" + this.mediumThreshold + ", highThreshold=" + this.highThreshold + ", homeDomain=" + this.homeDomain + ", signer=" + this.signer + ", signerWeight=" + this.signerWeight + ")";
        }
    }

    private static final class SetOptionsOperationBuilderImpl
    extends SetOptionsOperationBuilder<SetOptionsOperation, SetOptionsOperationBuilderImpl> {
        @Override
        public SetOptionsOperation build() {
            SetOptionsOperation op = new SetOptionsOperation(this);
            if (op.homeDomain != null && new XdrString(op.homeDomain).getBytes().length > 32) {
                throw new IllegalArgumentException("home domain cannot exceed 32 bytes");
            }
            if (op.signer != null && op.signerWeight == null) {
                throw new IllegalArgumentException("signer weight cannot be null if signer is not null");
            }
            if (op.signer == null && op.signerWeight != null) {
                throw new IllegalArgumentException("signer cannot be null if signer weight is not null");
            }
            if (op.signerWeight != null && (op.signerWeight < 0 || op.signerWeight > 255)) {
                throw new IllegalArgumentException("signer weight must be between 0 and 255");
            }
            return op;
        }

        @Generated
        private SetOptionsOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected SetOptionsOperationBuilderImpl self() {
            return this;
        }
    }
}

