/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.AccountResponse;
import org.stellar.sdk.responses.Page;

public class AccountsRequestBuilder
extends RequestBuilder {
    private static final String ASSET_PARAMETER_NAME = "asset";
    private static final String LIQUIDITY_POOL_PARAMETER_NAME = "liquidity_pool";
    private static final String SIGNER_PARAMETER_NAME = "signer";
    private static final String SPONSOR_PARAMETER_NAME = "sponsor";

    public AccountsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "accounts");
    }

    public AccountResponse account(HttpUrl uri) {
        TypeToken<AccountResponse> type = new TypeToken<AccountResponse>(){};
        return AccountsRequestBuilder.executeGetRequest(this.httpClient, uri, type);
    }

    public AccountResponse account(String account) {
        this.setSegments("accounts", account);
        return this.account(this.buildUri());
    }

    public AccountsRequestBuilder forSigner(String signer) {
        if (this.uriBuilder.build().queryParameter(ASSET_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both asset and signer");
        }
        if (this.uriBuilder.build().queryParameter(LIQUIDITY_POOL_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both liquidity_pool and signer");
        }
        if (this.uriBuilder.build().queryParameter(SPONSOR_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both sponsor and signer");
        }
        this.uriBuilder.setQueryParameter(SIGNER_PARAMETER_NAME, signer);
        return this;
    }

    public AccountsRequestBuilder forAsset(AssetTypeCreditAlphaNum asset) {
        if (this.uriBuilder.build().queryParameter(LIQUIDITY_POOL_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both liquidity_pool and asset");
        }
        if (this.uriBuilder.build().queryParameter(SIGNER_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both signer and asset");
        }
        if (this.uriBuilder.build().queryParameter(SPONSOR_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both sponsor and asset");
        }
        this.setAssetParameter(ASSET_PARAMETER_NAME, asset);
        return this;
    }

    public AccountsRequestBuilder forLiquidityPool(String liquidityPoolId) {
        if (this.uriBuilder.build().queryParameter(ASSET_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both asset and liquidity_pool");
        }
        if (this.uriBuilder.build().queryParameter(SIGNER_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both signer and liquidity_pool");
        }
        if (this.uriBuilder.build().queryParameter(SPONSOR_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both sponsor and liquidity_pool");
        }
        this.uriBuilder.setQueryParameter(LIQUIDITY_POOL_PARAMETER_NAME, liquidityPoolId);
        return this;
    }

    public AccountsRequestBuilder forSponsor(String sponsor) {
        if (this.uriBuilder.build().queryParameter(ASSET_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both asset and sponsor");
        }
        if (this.uriBuilder.build().queryParameter(LIQUIDITY_POOL_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both liquidity_pool and sponsor");
        }
        if (this.uriBuilder.build().queryParameter(SIGNER_PARAMETER_NAME) != null) {
            throw new IllegalArgumentException("cannot set both signer and sponsor");
        }
        this.uriBuilder.setQueryParameter(SPONSOR_PARAMETER_NAME, sponsor);
        return this;
    }

    public static Page<AccountResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<AccountResponse>> type = new TypeToken<Page<AccountResponse>>(){};
        return AccountsRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<AccountResponse> stream(EventListener<AccountResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, AccountResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<AccountResponse> stream(EventListener<AccountResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<AccountResponse> execute() {
        return AccountsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public AccountsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public AccountsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public AccountsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

