/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Predicate;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.effects.EffectResponse;
import org.stellar.sdk.responses.gson.AssetDeserializer;
import org.stellar.sdk.responses.gson.EffectDeserializer;
import org.stellar.sdk.responses.gson.OperationDeserializer;
import org.stellar.sdk.responses.gson.PredicateDeserializer;
import org.stellar.sdk.responses.operations.OperationResponse;

class PageDeserializer<E>
implements JsonDeserializer<Page<E>> {
    private TypeToken<Page<E>> pageType;

    public PageDeserializer(TypeToken<Page<E>> pageType) {
        this.pageType = pageType;
    }

    public Page<E> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject newJson = new JsonObject();
        newJson.add("records", json.getAsJsonObject().get("_embedded").getAsJsonObject().get("records"));
        newJson.add("links", json.getAsJsonObject().get("_links"));
        Gson gson = new GsonBuilder().registerTypeAdapter(Asset.class, (Object)new AssetDeserializer()).registerTypeAdapter(Predicate.class, (Object)new PredicateDeserializer()).registerTypeAdapter(OperationResponse.class, (Object)new OperationDeserializer()).registerTypeAdapter(EffectResponse.class, (Object)new EffectDeserializer()).create();
        return (Page)gson.fromJson((JsonElement)newJson, this.pageType.getType());
    }
}

