/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AlphaNum12
implements XdrElement {
    private AssetCode12 assetCode;
    private AccountID issuer;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.assetCode.encode(stream);
        this.issuer.encode(stream);
    }

    public static AlphaNum12 decode(XdrDataInputStream stream) throws IOException {
        AlphaNum12 decodedAlphaNum12 = new AlphaNum12();
        decodedAlphaNum12.assetCode = AssetCode12.decode(stream);
        decodedAlphaNum12.issuer = AccountID.decode(stream);
        return decodedAlphaNum12;
    }

    public static AlphaNum12 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AlphaNum12.fromXdrByteArray(bytes);
    }

    public static AlphaNum12 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AlphaNum12.decode(xdrDataInputStream);
    }

    @Generated
    public static AlphaNum12Builder builder() {
        return new AlphaNum12Builder();
    }

    @Generated
    public AlphaNum12Builder toBuilder() {
        return new AlphaNum12Builder().assetCode(this.assetCode).issuer(this.issuer);
    }

    @Generated
    public AssetCode12 getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public AccountID getIssuer() {
        return this.issuer;
    }

    @Generated
    public void setAssetCode(AssetCode12 assetCode) {
        this.assetCode = assetCode;
    }

    @Generated
    public void setIssuer(AccountID issuer) {
        this.issuer = issuer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlphaNum12)) {
            return false;
        }
        AlphaNum12 other = (AlphaNum12)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetCode12 this$assetCode = this.getAssetCode();
        AssetCode12 other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !((Object)this$assetCode).equals(other$assetCode)) {
            return false;
        }
        AccountID this$issuer = this.getIssuer();
        AccountID other$issuer = other.getIssuer();
        return !(this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlphaNum12;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetCode12 $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : ((Object)$assetCode).hashCode());
        AccountID $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlphaNum12(assetCode=" + this.getAssetCode() + ", issuer=" + this.getIssuer() + ")";
    }

    @Generated
    public AlphaNum12() {
    }

    @Generated
    public AlphaNum12(AssetCode12 assetCode, AccountID issuer) {
        this.assetCode = assetCode;
        this.issuer = issuer;
    }

    @Generated
    public static class AlphaNum12Builder {
        @Generated
        private AssetCode12 assetCode;
        @Generated
        private AccountID issuer;

        @Generated
        AlphaNum12Builder() {
        }

        @Generated
        public AlphaNum12Builder assetCode(AssetCode12 assetCode) {
            this.assetCode = assetCode;
            return this;
        }

        @Generated
        public AlphaNum12Builder issuer(AccountID issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public AlphaNum12 build() {
            return new AlphaNum12(this.assetCode, this.issuer);
        }

        @Generated
        public String toString() {
            return "AlphaNum12.AlphaNum12Builder(assetCode=" + this.assetCode + ", issuer=" + this.issuer + ")";
        }
    }
}

