/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEventType;
import org.stellar.sdk.xdr.ContractID;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractEvent
implements XdrElement {
    private ExtensionPoint ext;
    private ContractID contractID;
    private ContractEventType type;
    private ContractEventBody body;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        if (this.contractID != null) {
            stream.writeInt(1);
            this.contractID.encode(stream);
        } else {
            stream.writeInt(0);
        }
        this.type.encode(stream);
        this.body.encode(stream);
    }

    public static ContractEvent decode(XdrDataInputStream stream) throws IOException {
        ContractEvent decodedContractEvent = new ContractEvent();
        decodedContractEvent.ext = ExtensionPoint.decode(stream);
        int contractIDPresent = stream.readInt();
        if (contractIDPresent != 0) {
            decodedContractEvent.contractID = ContractID.decode(stream);
        }
        decodedContractEvent.type = ContractEventType.decode(stream);
        decodedContractEvent.body = ContractEventBody.decode(stream);
        return decodedContractEvent;
    }

    public static ContractEvent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractEvent.fromXdrByteArray(bytes);
    }

    public static ContractEvent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractEvent.decode(xdrDataInputStream);
    }

    @Generated
    public static ContractEventBuilder builder() {
        return new ContractEventBuilder();
    }

    @Generated
    public ContractEventBuilder toBuilder() {
        return new ContractEventBuilder().ext(this.ext).contractID(this.contractID).type(this.type).body(this.body);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public ContractID getContractID() {
        return this.contractID;
    }

    @Generated
    public ContractEventType getType() {
        return this.type;
    }

    @Generated
    public ContractEventBody getBody() {
        return this.body;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setContractID(ContractID contractID) {
        this.contractID = contractID;
    }

    @Generated
    public void setType(ContractEventType type) {
        this.type = type;
    }

    @Generated
    public void setBody(ContractEventBody body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractEvent)) {
            return false;
        }
        ContractEvent other = (ContractEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        ContractID this$contractID = this.getContractID();
        ContractID other$contractID = other.getContractID();
        if (this$contractID == null ? other$contractID != null : !((Object)this$contractID).equals(other$contractID)) {
            return false;
        }
        ContractEventType this$type = this.getType();
        ContractEventType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ContractEventBody this$body = this.getBody();
        ContractEventBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContractEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        ContractID $contractID = this.getContractID();
        result = result * 59 + ($contractID == null ? 43 : ((Object)$contractID).hashCode());
        ContractEventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ContractEventBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractEvent(ext=" + this.getExt() + ", contractID=" + this.getContractID() + ", type=" + this.getType() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public ContractEvent() {
    }

    @Generated
    public ContractEvent(ExtensionPoint ext, ContractID contractID, ContractEventType type, ContractEventBody body) {
        this.ext = ext;
        this.contractID = contractID;
        this.type = type;
        this.body = body;
    }

    @Generated
    public static class ContractEventBuilder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private ContractID contractID;
        @Generated
        private ContractEventType type;
        @Generated
        private ContractEventBody body;

        @Generated
        ContractEventBuilder() {
        }

        @Generated
        public ContractEventBuilder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public ContractEventBuilder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        @Generated
        public ContractEventBuilder type(ContractEventType type) {
            this.type = type;
            return this;
        }

        @Generated
        public ContractEventBuilder body(ContractEventBody body) {
            this.body = body;
            return this;
        }

        @Generated
        public ContractEvent build() {
            return new ContractEvent(this.ext, this.contractID, this.type, this.body);
        }

        @Generated
        public String toString() {
            return "ContractEvent.ContractEventBuilder(ext=" + this.ext + ", contractID=" + this.contractID + ", type=" + this.type + ", body=" + this.body + ")";
        }
    }

    public static class ContractEventBody
    implements XdrElement {
        private Integer discriminant;
        private ContractEventV0 v0;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                case 0: {
                    this.v0.encode(stream);
                }
            }
        }

        public static ContractEventBody decode(XdrDataInputStream stream) throws IOException {
            ContractEventBody decodedContractEventBody = new ContractEventBody();
            Integer discriminant = stream.readInt();
            decodedContractEventBody.setDiscriminant(discriminant);
            switch (decodedContractEventBody.getDiscriminant()) {
                case 0: {
                    decodedContractEventBody.v0 = ContractEventV0.decode(stream);
                }
            }
            return decodedContractEventBody;
        }

        public static ContractEventBody fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ContractEventBody.fromXdrByteArray(bytes);
        }

        public static ContractEventBody fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ContractEventBody.decode(xdrDataInputStream);
        }

        @Generated
        public static ContractEventBodyBuilder builder() {
            return new ContractEventBodyBuilder();
        }

        @Generated
        public ContractEventBodyBuilder toBuilder() {
            return new ContractEventBodyBuilder().discriminant(this.discriminant).v0(this.v0);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public ContractEventV0 getV0() {
            return this.v0;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV0(ContractEventV0 v0) {
            this.v0 = v0;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractEventBody)) {
                return false;
            }
            ContractEventBody other = (ContractEventBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant)) {
                return false;
            }
            ContractEventV0 this$v0 = this.getV0();
            ContractEventV0 other$v0 = other.getV0();
            return !(this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContractEventBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            ContractEventV0 $v0 = this.getV0();
            result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContractEvent.ContractEventBody(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ")";
        }

        @Generated
        public ContractEventBody() {
        }

        @Generated
        public ContractEventBody(Integer discriminant, ContractEventV0 v0) {
            this.discriminant = discriminant;
            this.v0 = v0;
        }

        @Generated
        public static class ContractEventBodyBuilder {
            @Generated
            private Integer discriminant;
            @Generated
            private ContractEventV0 v0;

            @Generated
            ContractEventBodyBuilder() {
            }

            @Generated
            public ContractEventBodyBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public ContractEventBodyBuilder v0(ContractEventV0 v0) {
                this.v0 = v0;
                return this;
            }

            @Generated
            public ContractEventBody build() {
                return new ContractEventBody(this.discriminant, this.v0);
            }

            @Generated
            public String toString() {
                return "ContractEvent.ContractEventBody.ContractEventBodyBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ")";
            }
        }

        public static class ContractEventV0
        implements XdrElement {
            private SCVal[] topics;
            private SCVal data;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                int topicsSize = this.getTopics().length;
                stream.writeInt(topicsSize);
                for (int i = 0; i < topicsSize; ++i) {
                    this.topics[i].encode(stream);
                }
                this.data.encode(stream);
            }

            public static ContractEventV0 decode(XdrDataInputStream stream) throws IOException {
                ContractEventV0 decodedContractEventV0 = new ContractEventV0();
                int topicsSize = stream.readInt();
                decodedContractEventV0.topics = new SCVal[topicsSize];
                for (int i = 0; i < topicsSize; ++i) {
                    decodedContractEventV0.topics[i] = SCVal.decode(stream);
                }
                decodedContractEventV0.data = SCVal.decode(stream);
                return decodedContractEventV0;
            }

            public static ContractEventV0 fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return ContractEventV0.fromXdrByteArray(bytes);
            }

            public static ContractEventV0 fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return ContractEventV0.decode(xdrDataInputStream);
            }

            @Generated
            public static ContractEventV0Builder builder() {
                return new ContractEventV0Builder();
            }

            @Generated
            public ContractEventV0Builder toBuilder() {
                return new ContractEventV0Builder().topics(this.topics).data(this.data);
            }

            @Generated
            public SCVal[] getTopics() {
                return this.topics;
            }

            @Generated
            public SCVal getData() {
                return this.data;
            }

            @Generated
            public void setTopics(SCVal[] topics) {
                this.topics = topics;
            }

            @Generated
            public void setData(SCVal data) {
                this.data = data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContractEventV0)) {
                    return false;
                }
                ContractEventV0 other = (ContractEventV0)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!Arrays.deepEquals(this.getTopics(), other.getTopics())) {
                    return false;
                }
                SCVal this$data = this.getData();
                SCVal other$data = other.getData();
                return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ContractEventV0;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Arrays.deepHashCode(this.getTopics());
                SCVal $data = this.getData();
                result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ContractEvent.ContractEventBody.ContractEventV0(topics=" + Arrays.deepToString(this.getTopics()) + ", data=" + this.getData() + ")";
            }

            @Generated
            public ContractEventV0() {
            }

            @Generated
            public ContractEventV0(SCVal[] topics, SCVal data) {
                this.topics = topics;
                this.data = data;
            }

            @Generated
            public static class ContractEventV0Builder {
                @Generated
                private SCVal[] topics;
                @Generated
                private SCVal data;

                @Generated
                ContractEventV0Builder() {
                }

                @Generated
                public ContractEventV0Builder topics(SCVal[] topics) {
                    this.topics = topics;
                    return this;
                }

                @Generated
                public ContractEventV0Builder data(SCVal data) {
                    this.data = data;
                    return this;
                }

                @Generated
                public ContractEventV0 build() {
                    return new ContractEventV0(this.topics, this.data);
                }

                @Generated
                public String toString() {
                    return "ContractEvent.ContractEventBody.ContractEventV0.ContractEventV0Builder(topics=" + Arrays.deepToString(this.topics) + ", data=" + this.data + ")";
                }
            }
        }
    }
}

