/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractExecutableType implements XdrElement
{
    CONTRACT_EXECUTABLE_WASM(0),
    CONTRACT_EXECUTABLE_STELLAR_ASSET(1);

    private final int value;

    private ContractExecutableType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractExecutableType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CONTRACT_EXECUTABLE_WASM;
            }
            case 1: {
                return CONTRACT_EXECUTABLE_STELLAR_ASSET;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ContractExecutableType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractExecutableType.fromXdrByteArray(bytes);
    }

    public static ContractExecutableType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractExecutableType.decode(xdrDataInputStream);
    }
}

