/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.BucketMetadata;
import org.stellar.sdk.xdr.HotArchiveBucketEntryType;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HotArchiveBucketEntry
implements XdrElement {
    private HotArchiveBucketEntryType discriminant;
    private LedgerEntry archivedEntry;
    private LedgerKey key;
    private BucketMetadata metaEntry;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case HOT_ARCHIVE_ARCHIVED: {
                this.archivedEntry.encode(stream);
                break;
            }
            case HOT_ARCHIVE_LIVE: {
                this.key.encode(stream);
                break;
            }
            case HOT_ARCHIVE_METAENTRY: {
                this.metaEntry.encode(stream);
            }
        }
    }

    public static HotArchiveBucketEntry decode(XdrDataInputStream stream) throws IOException {
        HotArchiveBucketEntry decodedHotArchiveBucketEntry = new HotArchiveBucketEntry();
        HotArchiveBucketEntryType discriminant = HotArchiveBucketEntryType.decode(stream);
        decodedHotArchiveBucketEntry.setDiscriminant(discriminant);
        switch (decodedHotArchiveBucketEntry.getDiscriminant()) {
            case HOT_ARCHIVE_ARCHIVED: {
                decodedHotArchiveBucketEntry.archivedEntry = LedgerEntry.decode(stream);
                break;
            }
            case HOT_ARCHIVE_LIVE: {
                decodedHotArchiveBucketEntry.key = LedgerKey.decode(stream);
                break;
            }
            case HOT_ARCHIVE_METAENTRY: {
                decodedHotArchiveBucketEntry.metaEntry = BucketMetadata.decode(stream);
            }
        }
        return decodedHotArchiveBucketEntry;
    }

    public static HotArchiveBucketEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HotArchiveBucketEntry.fromXdrByteArray(bytes);
    }

    public static HotArchiveBucketEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HotArchiveBucketEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static HotArchiveBucketEntryBuilder builder() {
        return new HotArchiveBucketEntryBuilder();
    }

    @Generated
    public HotArchiveBucketEntryBuilder toBuilder() {
        return new HotArchiveBucketEntryBuilder().discriminant(this.discriminant).archivedEntry(this.archivedEntry).key(this.key).metaEntry(this.metaEntry);
    }

    @Generated
    public HotArchiveBucketEntryType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public LedgerEntry getArchivedEntry() {
        return this.archivedEntry;
    }

    @Generated
    public LedgerKey getKey() {
        return this.key;
    }

    @Generated
    public BucketMetadata getMetaEntry() {
        return this.metaEntry;
    }

    @Generated
    public void setDiscriminant(HotArchiveBucketEntryType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setArchivedEntry(LedgerEntry archivedEntry) {
        this.archivedEntry = archivedEntry;
    }

    @Generated
    public void setKey(LedgerKey key) {
        this.key = key;
    }

    @Generated
    public void setMetaEntry(BucketMetadata metaEntry) {
        this.metaEntry = metaEntry;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotArchiveBucketEntry)) {
            return false;
        }
        HotArchiveBucketEntry other = (HotArchiveBucketEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HotArchiveBucketEntryType this$discriminant = this.getDiscriminant();
        HotArchiveBucketEntryType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        LedgerEntry this$archivedEntry = this.getArchivedEntry();
        LedgerEntry other$archivedEntry = other.getArchivedEntry();
        if (this$archivedEntry == null ? other$archivedEntry != null : !((Object)this$archivedEntry).equals(other$archivedEntry)) {
            return false;
        }
        LedgerKey this$key = this.getKey();
        LedgerKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        BucketMetadata this$metaEntry = this.getMetaEntry();
        BucketMetadata other$metaEntry = other.getMetaEntry();
        return !(this$metaEntry == null ? other$metaEntry != null : !((Object)this$metaEntry).equals(other$metaEntry));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HotArchiveBucketEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HotArchiveBucketEntryType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        LedgerEntry $archivedEntry = this.getArchivedEntry();
        result = result * 59 + ($archivedEntry == null ? 43 : ((Object)$archivedEntry).hashCode());
        LedgerKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        BucketMetadata $metaEntry = this.getMetaEntry();
        result = result * 59 + ($metaEntry == null ? 43 : ((Object)$metaEntry).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HotArchiveBucketEntry(discriminant=" + this.getDiscriminant() + ", archivedEntry=" + this.getArchivedEntry() + ", key=" + this.getKey() + ", metaEntry=" + this.getMetaEntry() + ")";
    }

    @Generated
    public HotArchiveBucketEntry() {
    }

    @Generated
    public HotArchiveBucketEntry(HotArchiveBucketEntryType discriminant, LedgerEntry archivedEntry, LedgerKey key, BucketMetadata metaEntry) {
        this.discriminant = discriminant;
        this.archivedEntry = archivedEntry;
        this.key = key;
        this.metaEntry = metaEntry;
    }

    @Generated
    public static class HotArchiveBucketEntryBuilder {
        @Generated
        private HotArchiveBucketEntryType discriminant;
        @Generated
        private LedgerEntry archivedEntry;
        @Generated
        private LedgerKey key;
        @Generated
        private BucketMetadata metaEntry;

        @Generated
        HotArchiveBucketEntryBuilder() {
        }

        @Generated
        public HotArchiveBucketEntryBuilder discriminant(HotArchiveBucketEntryType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public HotArchiveBucketEntryBuilder archivedEntry(LedgerEntry archivedEntry) {
            this.archivedEntry = archivedEntry;
            return this;
        }

        @Generated
        public HotArchiveBucketEntryBuilder key(LedgerKey key) {
            this.key = key;
            return this;
        }

        @Generated
        public HotArchiveBucketEntryBuilder metaEntry(BucketMetadata metaEntry) {
            this.metaEntry = metaEntry;
            return this;
        }

        @Generated
        public HotArchiveBucketEntry build() {
            return new HotArchiveBucketEntry(this.discriminant, this.archivedEntry, this.key, this.metaEntry);
        }

        @Generated
        public String toString() {
            return "HotArchiveBucketEntry.HotArchiveBucketEntryBuilder(discriminant=" + this.discriminant + ", archivedEntry=" + this.archivedEntry + ", key=" + this.key + ", metaEntry=" + this.metaEntry + ")";
        }
    }
}

