/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class OperationMetaV2
implements XdrElement {
    private ExtensionPoint ext;
    private LedgerEntryChanges changes;
    private ContractEvent[] events;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.changes.encode(stream);
        int eventsSize = this.getEvents().length;
        stream.writeInt(eventsSize);
        for (int i = 0; i < eventsSize; ++i) {
            this.events[i].encode(stream);
        }
    }

    public static OperationMetaV2 decode(XdrDataInputStream stream) throws IOException {
        OperationMetaV2 decodedOperationMetaV2 = new OperationMetaV2();
        decodedOperationMetaV2.ext = ExtensionPoint.decode(stream);
        decodedOperationMetaV2.changes = LedgerEntryChanges.decode(stream);
        int eventsSize = stream.readInt();
        decodedOperationMetaV2.events = new ContractEvent[eventsSize];
        for (int i = 0; i < eventsSize; ++i) {
            decodedOperationMetaV2.events[i] = ContractEvent.decode(stream);
        }
        return decodedOperationMetaV2;
    }

    public static OperationMetaV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return OperationMetaV2.fromXdrByteArray(bytes);
    }

    public static OperationMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return OperationMetaV2.decode(xdrDataInputStream);
    }

    @Generated
    public static OperationMetaV2Builder builder() {
        return new OperationMetaV2Builder();
    }

    @Generated
    public OperationMetaV2Builder toBuilder() {
        return new OperationMetaV2Builder().ext(this.ext).changes(this.changes).events(this.events);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public LedgerEntryChanges getChanges() {
        return this.changes;
    }

    @Generated
    public ContractEvent[] getEvents() {
        return this.events;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setChanges(LedgerEntryChanges changes) {
        this.changes = changes;
    }

    @Generated
    public void setEvents(ContractEvent[] events) {
        this.events = events;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationMetaV2)) {
            return false;
        }
        OperationMetaV2 other = (OperationMetaV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        LedgerEntryChanges this$changes = this.getChanges();
        LedgerEntryChanges other$changes = other.getChanges();
        if (this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes)) {
            return false;
        }
        return Arrays.deepEquals(this.getEvents(), other.getEvents());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationMetaV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        LedgerEntryChanges $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEvents());
        return result;
    }

    @Generated
    public String toString() {
        return "OperationMetaV2(ext=" + this.getExt() + ", changes=" + this.getChanges() + ", events=" + Arrays.deepToString(this.getEvents()) + ")";
    }

    @Generated
    public OperationMetaV2() {
    }

    @Generated
    public OperationMetaV2(ExtensionPoint ext, LedgerEntryChanges changes, ContractEvent[] events) {
        this.ext = ext;
        this.changes = changes;
        this.events = events;
    }

    @Generated
    public static class OperationMetaV2Builder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private LedgerEntryChanges changes;
        @Generated
        private ContractEvent[] events;

        @Generated
        OperationMetaV2Builder() {
        }

        @Generated
        public OperationMetaV2Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public OperationMetaV2Builder changes(LedgerEntryChanges changes) {
            this.changes = changes;
            return this;
        }

        @Generated
        public OperationMetaV2Builder events(ContractEvent[] events) {
            this.events = events;
            return this;
        }

        @Generated
        public OperationMetaV2 build() {
            return new OperationMetaV2(this.ext, this.changes, this.events);
        }

        @Generated
        public String toString() {
            return "OperationMetaV2.OperationMetaV2Builder(ext=" + this.ext + ", changes=" + this.changes + ", events=" + Arrays.deepToString(this.events) + ")";
        }
    }
}

