/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCEnvMetaKind implements XdrElement
{
    SC_ENV_META_KIND_INTERFACE_VERSION(0);

    private final int value;

    private SCEnvMetaKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SCEnvMetaKind decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SC_ENV_META_KIND_INTERFACE_VERSION;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SCEnvMetaKind fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCEnvMetaKind.fromXdrByteArray(bytes);
    }

    public static SCEnvMetaKind fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCEnvMetaKind.decode(xdrDataInputStream);
    }
}

