/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SCPBallot;
import org.stellar.sdk.xdr.SCPNomination;
import org.stellar.sdk.xdr.SCPStatementType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPStatement
implements XdrElement {
    private NodeID nodeID;
    private Uint64 slotIndex;
    private SCPStatementPledges pledges;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.nodeID.encode(stream);
        this.slotIndex.encode(stream);
        this.pledges.encode(stream);
    }

    public static SCPStatement decode(XdrDataInputStream stream) throws IOException {
        SCPStatement decodedSCPStatement = new SCPStatement();
        decodedSCPStatement.nodeID = NodeID.decode(stream);
        decodedSCPStatement.slotIndex = Uint64.decode(stream);
        decodedSCPStatement.pledges = SCPStatementPledges.decode(stream);
        return decodedSCPStatement;
    }

    public static SCPStatement fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPStatement.fromXdrByteArray(bytes);
    }

    public static SCPStatement fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPStatement.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPStatementBuilder builder() {
        return new SCPStatementBuilder();
    }

    @Generated
    public SCPStatementBuilder toBuilder() {
        return new SCPStatementBuilder().nodeID(this.nodeID).slotIndex(this.slotIndex).pledges(this.pledges);
    }

    @Generated
    public NodeID getNodeID() {
        return this.nodeID;
    }

    @Generated
    public Uint64 getSlotIndex() {
        return this.slotIndex;
    }

    @Generated
    public SCPStatementPledges getPledges() {
        return this.pledges;
    }

    @Generated
    public void setNodeID(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    @Generated
    public void setSlotIndex(Uint64 slotIndex) {
        this.slotIndex = slotIndex;
    }

    @Generated
    public void setPledges(SCPStatementPledges pledges) {
        this.pledges = pledges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPStatement)) {
            return false;
        }
        SCPStatement other = (SCPStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$nodeID = this.getNodeID();
        NodeID other$nodeID = other.getNodeID();
        if (this$nodeID == null ? other$nodeID != null : !((Object)this$nodeID).equals(other$nodeID)) {
            return false;
        }
        Uint64 this$slotIndex = this.getSlotIndex();
        Uint64 other$slotIndex = other.getSlotIndex();
        if (this$slotIndex == null ? other$slotIndex != null : !((Object)this$slotIndex).equals(other$slotIndex)) {
            return false;
        }
        SCPStatementPledges this$pledges = this.getPledges();
        SCPStatementPledges other$pledges = other.getPledges();
        return !(this$pledges == null ? other$pledges != null : !((Object)this$pledges).equals(other$pledges));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $nodeID = this.getNodeID();
        result = result * 59 + ($nodeID == null ? 43 : ((Object)$nodeID).hashCode());
        Uint64 $slotIndex = this.getSlotIndex();
        result = result * 59 + ($slotIndex == null ? 43 : ((Object)$slotIndex).hashCode());
        SCPStatementPledges $pledges = this.getPledges();
        result = result * 59 + ($pledges == null ? 43 : ((Object)$pledges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPStatement(nodeID=" + this.getNodeID() + ", slotIndex=" + this.getSlotIndex() + ", pledges=" + this.getPledges() + ")";
    }

    @Generated
    public SCPStatement() {
    }

    @Generated
    public SCPStatement(NodeID nodeID, Uint64 slotIndex, SCPStatementPledges pledges) {
        this.nodeID = nodeID;
        this.slotIndex = slotIndex;
        this.pledges = pledges;
    }

    @Generated
    public static class SCPStatementBuilder {
        @Generated
        private NodeID nodeID;
        @Generated
        private Uint64 slotIndex;
        @Generated
        private SCPStatementPledges pledges;

        @Generated
        SCPStatementBuilder() {
        }

        @Generated
        public SCPStatementBuilder nodeID(NodeID nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        @Generated
        public SCPStatementBuilder slotIndex(Uint64 slotIndex) {
            this.slotIndex = slotIndex;
            return this;
        }

        @Generated
        public SCPStatementBuilder pledges(SCPStatementPledges pledges) {
            this.pledges = pledges;
            return this;
        }

        @Generated
        public SCPStatement build() {
            return new SCPStatement(this.nodeID, this.slotIndex, this.pledges);
        }

        @Generated
        public String toString() {
            return "SCPStatement.SCPStatementBuilder(nodeID=" + this.nodeID + ", slotIndex=" + this.slotIndex + ", pledges=" + this.pledges + ")";
        }
    }

    public static class SCPStatementPledges
    implements XdrElement {
        private SCPStatementType discriminant;
        private SCPStatementPrepare prepare;
        private SCPStatementConfirm confirm;
        private SCPStatementExternalize externalize;
        private SCPNomination nominate;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case SCP_ST_PREPARE: {
                    this.prepare.encode(stream);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    this.confirm.encode(stream);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    this.externalize.encode(stream);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    this.nominate.encode(stream);
                }
            }
        }

        public static SCPStatementPledges decode(XdrDataInputStream stream) throws IOException {
            SCPStatementPledges decodedSCPStatementPledges = new SCPStatementPledges();
            SCPStatementType discriminant = SCPStatementType.decode(stream);
            decodedSCPStatementPledges.setDiscriminant(discriminant);
            switch (decodedSCPStatementPledges.getDiscriminant()) {
                case SCP_ST_PREPARE: {
                    decodedSCPStatementPledges.prepare = SCPStatementPrepare.decode(stream);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    decodedSCPStatementPledges.confirm = SCPStatementConfirm.decode(stream);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    decodedSCPStatementPledges.externalize = SCPStatementExternalize.decode(stream);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    decodedSCPStatementPledges.nominate = SCPNomination.decode(stream);
                }
            }
            return decodedSCPStatementPledges;
        }

        public static SCPStatementPledges fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return SCPStatementPledges.fromXdrByteArray(bytes);
        }

        public static SCPStatementPledges fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return SCPStatementPledges.decode(xdrDataInputStream);
        }

        @Generated
        public static SCPStatementPledgesBuilder builder() {
            return new SCPStatementPledgesBuilder();
        }

        @Generated
        public SCPStatementPledgesBuilder toBuilder() {
            return new SCPStatementPledgesBuilder().discriminant(this.discriminant).prepare(this.prepare).confirm(this.confirm).externalize(this.externalize).nominate(this.nominate);
        }

        @Generated
        public SCPStatementType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public SCPStatementPrepare getPrepare() {
            return this.prepare;
        }

        @Generated
        public SCPStatementConfirm getConfirm() {
            return this.confirm;
        }

        @Generated
        public SCPStatementExternalize getExternalize() {
            return this.externalize;
        }

        @Generated
        public SCPNomination getNominate() {
            return this.nominate;
        }

        @Generated
        public void setDiscriminant(SCPStatementType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setPrepare(SCPStatementPrepare prepare) {
            this.prepare = prepare;
        }

        @Generated
        public void setConfirm(SCPStatementConfirm confirm) {
            this.confirm = confirm;
        }

        @Generated
        public void setExternalize(SCPStatementExternalize externalize) {
            this.externalize = externalize;
        }

        @Generated
        public void setNominate(SCPNomination nominate) {
            this.nominate = nominate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SCPStatementPledges)) {
                return false;
            }
            SCPStatementPledges other = (SCPStatementPledges)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SCPStatementType this$discriminant = this.getDiscriminant();
            SCPStatementType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            SCPStatementPrepare this$prepare = this.getPrepare();
            SCPStatementPrepare other$prepare = other.getPrepare();
            if (this$prepare == null ? other$prepare != null : !((Object)this$prepare).equals(other$prepare)) {
                return false;
            }
            SCPStatementConfirm this$confirm = this.getConfirm();
            SCPStatementConfirm other$confirm = other.getConfirm();
            if (this$confirm == null ? other$confirm != null : !((Object)this$confirm).equals(other$confirm)) {
                return false;
            }
            SCPStatementExternalize this$externalize = this.getExternalize();
            SCPStatementExternalize other$externalize = other.getExternalize();
            if (this$externalize == null ? other$externalize != null : !((Object)this$externalize).equals(other$externalize)) {
                return false;
            }
            SCPNomination this$nominate = this.getNominate();
            SCPNomination other$nominate = other.getNominate();
            return !(this$nominate == null ? other$nominate != null : !((Object)this$nominate).equals(other$nominate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SCPStatementPledges;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SCPStatementType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            SCPStatementPrepare $prepare = this.getPrepare();
            result = result * 59 + ($prepare == null ? 43 : ((Object)$prepare).hashCode());
            SCPStatementConfirm $confirm = this.getConfirm();
            result = result * 59 + ($confirm == null ? 43 : ((Object)$confirm).hashCode());
            SCPStatementExternalize $externalize = this.getExternalize();
            result = result * 59 + ($externalize == null ? 43 : ((Object)$externalize).hashCode());
            SCPNomination $nominate = this.getNominate();
            result = result * 59 + ($nominate == null ? 43 : ((Object)$nominate).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SCPStatement.SCPStatementPledges(discriminant=" + this.getDiscriminant() + ", prepare=" + this.getPrepare() + ", confirm=" + this.getConfirm() + ", externalize=" + this.getExternalize() + ", nominate=" + this.getNominate() + ")";
        }

        @Generated
        public SCPStatementPledges() {
        }

        @Generated
        public SCPStatementPledges(SCPStatementType discriminant, SCPStatementPrepare prepare, SCPStatementConfirm confirm, SCPStatementExternalize externalize, SCPNomination nominate) {
            this.discriminant = discriminant;
            this.prepare = prepare;
            this.confirm = confirm;
            this.externalize = externalize;
            this.nominate = nominate;
        }

        @Generated
        public static class SCPStatementPledgesBuilder {
            @Generated
            private SCPStatementType discriminant;
            @Generated
            private SCPStatementPrepare prepare;
            @Generated
            private SCPStatementConfirm confirm;
            @Generated
            private SCPStatementExternalize externalize;
            @Generated
            private SCPNomination nominate;

            @Generated
            SCPStatementPledgesBuilder() {
            }

            @Generated
            public SCPStatementPledgesBuilder discriminant(SCPStatementType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public SCPStatementPledgesBuilder prepare(SCPStatementPrepare prepare) {
                this.prepare = prepare;
                return this;
            }

            @Generated
            public SCPStatementPledgesBuilder confirm(SCPStatementConfirm confirm) {
                this.confirm = confirm;
                return this;
            }

            @Generated
            public SCPStatementPledgesBuilder externalize(SCPStatementExternalize externalize) {
                this.externalize = externalize;
                return this;
            }

            @Generated
            public SCPStatementPledgesBuilder nominate(SCPNomination nominate) {
                this.nominate = nominate;
                return this;
            }

            @Generated
            public SCPStatementPledges build() {
                return new SCPStatementPledges(this.discriminant, this.prepare, this.confirm, this.externalize, this.nominate);
            }

            @Generated
            public String toString() {
                return "SCPStatement.SCPStatementPledges.SCPStatementPledgesBuilder(discriminant=" + this.discriminant + ", prepare=" + this.prepare + ", confirm=" + this.confirm + ", externalize=" + this.externalize + ", nominate=" + this.nominate + ")";
            }
        }

        public static class SCPStatementExternalize
        implements XdrElement {
            private SCPBallot commit;
            private Uint32 nH;
            private Hash commitQuorumSetHash;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.commit.encode(stream);
                this.nH.encode(stream);
                this.commitQuorumSetHash.encode(stream);
            }

            public static SCPStatementExternalize decode(XdrDataInputStream stream) throws IOException {
                SCPStatementExternalize decodedSCPStatementExternalize = new SCPStatementExternalize();
                decodedSCPStatementExternalize.commit = SCPBallot.decode(stream);
                decodedSCPStatementExternalize.nH = Uint32.decode(stream);
                decodedSCPStatementExternalize.commitQuorumSetHash = Hash.decode(stream);
                return decodedSCPStatementExternalize;
            }

            public static SCPStatementExternalize fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementExternalize.fromXdrByteArray(bytes);
            }

            public static SCPStatementExternalize fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementExternalize.decode(xdrDataInputStream);
            }

            @Generated
            public static SCPStatementExternalizeBuilder builder() {
                return new SCPStatementExternalizeBuilder();
            }

            @Generated
            public SCPStatementExternalizeBuilder toBuilder() {
                return new SCPStatementExternalizeBuilder().commit(this.commit).nH(this.nH).commitQuorumSetHash(this.commitQuorumSetHash);
            }

            @Generated
            public SCPBallot getCommit() {
                return this.commit;
            }

            @Generated
            public Uint32 getNH() {
                return this.nH;
            }

            @Generated
            public Hash getCommitQuorumSetHash() {
                return this.commitQuorumSetHash;
            }

            @Generated
            public void setCommit(SCPBallot commit) {
                this.commit = commit;
            }

            @Generated
            public void setNH(Uint32 nH) {
                this.nH = nH;
            }

            @Generated
            public void setCommitQuorumSetHash(Hash commitQuorumSetHash) {
                this.commitQuorumSetHash = commitQuorumSetHash;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SCPStatementExternalize)) {
                    return false;
                }
                SCPStatementExternalize other = (SCPStatementExternalize)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                SCPBallot this$commit = this.getCommit();
                SCPBallot other$commit = other.getCommit();
                if (this$commit == null ? other$commit != null : !((Object)this$commit).equals(other$commit)) {
                    return false;
                }
                Uint32 this$nH = this.getNH();
                Uint32 other$nH = other.getNH();
                if (this$nH == null ? other$nH != null : !((Object)this$nH).equals(other$nH)) {
                    return false;
                }
                Hash this$commitQuorumSetHash = this.getCommitQuorumSetHash();
                Hash other$commitQuorumSetHash = other.getCommitQuorumSetHash();
                return !(this$commitQuorumSetHash == null ? other$commitQuorumSetHash != null : !((Object)this$commitQuorumSetHash).equals(other$commitQuorumSetHash));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SCPStatementExternalize;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                SCPBallot $commit = this.getCommit();
                result = result * 59 + ($commit == null ? 43 : ((Object)$commit).hashCode());
                Uint32 $nH = this.getNH();
                result = result * 59 + ($nH == null ? 43 : ((Object)$nH).hashCode());
                Hash $commitQuorumSetHash = this.getCommitQuorumSetHash();
                result = result * 59 + ($commitQuorumSetHash == null ? 43 : ((Object)$commitQuorumSetHash).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SCPStatement.SCPStatementPledges.SCPStatementExternalize(commit=" + this.getCommit() + ", nH=" + this.getNH() + ", commitQuorumSetHash=" + this.getCommitQuorumSetHash() + ")";
            }

            @Generated
            public SCPStatementExternalize() {
            }

            @Generated
            public SCPStatementExternalize(SCPBallot commit, Uint32 nH, Hash commitQuorumSetHash) {
                this.commit = commit;
                this.nH = nH;
                this.commitQuorumSetHash = commitQuorumSetHash;
            }

            @Generated
            public static class SCPStatementExternalizeBuilder {
                @Generated
                private SCPBallot commit;
                @Generated
                private Uint32 nH;
                @Generated
                private Hash commitQuorumSetHash;

                @Generated
                SCPStatementExternalizeBuilder() {
                }

                @Generated
                public SCPStatementExternalizeBuilder commit(SCPBallot commit) {
                    this.commit = commit;
                    return this;
                }

                @Generated
                public SCPStatementExternalizeBuilder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                @Generated
                public SCPStatementExternalizeBuilder commitQuorumSetHash(Hash commitQuorumSetHash) {
                    this.commitQuorumSetHash = commitQuorumSetHash;
                    return this;
                }

                @Generated
                public SCPStatementExternalize build() {
                    return new SCPStatementExternalize(this.commit, this.nH, this.commitQuorumSetHash);
                }

                @Generated
                public String toString() {
                    return "SCPStatement.SCPStatementPledges.SCPStatementExternalize.SCPStatementExternalizeBuilder(commit=" + this.commit + ", nH=" + this.nH + ", commitQuorumSetHash=" + this.commitQuorumSetHash + ")";
                }
            }
        }

        public static class SCPStatementConfirm
        implements XdrElement {
            private SCPBallot ballot;
            private Uint32 nPrepared;
            private Uint32 nCommit;
            private Uint32 nH;
            private Hash quorumSetHash;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.ballot.encode(stream);
                this.nPrepared.encode(stream);
                this.nCommit.encode(stream);
                this.nH.encode(stream);
                this.quorumSetHash.encode(stream);
            }

            public static SCPStatementConfirm decode(XdrDataInputStream stream) throws IOException {
                SCPStatementConfirm decodedSCPStatementConfirm = new SCPStatementConfirm();
                decodedSCPStatementConfirm.ballot = SCPBallot.decode(stream);
                decodedSCPStatementConfirm.nPrepared = Uint32.decode(stream);
                decodedSCPStatementConfirm.nCommit = Uint32.decode(stream);
                decodedSCPStatementConfirm.nH = Uint32.decode(stream);
                decodedSCPStatementConfirm.quorumSetHash = Hash.decode(stream);
                return decodedSCPStatementConfirm;
            }

            public static SCPStatementConfirm fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementConfirm.fromXdrByteArray(bytes);
            }

            public static SCPStatementConfirm fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementConfirm.decode(xdrDataInputStream);
            }

            @Generated
            public static SCPStatementConfirmBuilder builder() {
                return new SCPStatementConfirmBuilder();
            }

            @Generated
            public SCPStatementConfirmBuilder toBuilder() {
                return new SCPStatementConfirmBuilder().ballot(this.ballot).nPrepared(this.nPrepared).nCommit(this.nCommit).nH(this.nH).quorumSetHash(this.quorumSetHash);
            }

            @Generated
            public SCPBallot getBallot() {
                return this.ballot;
            }

            @Generated
            public Uint32 getNPrepared() {
                return this.nPrepared;
            }

            @Generated
            public Uint32 getNCommit() {
                return this.nCommit;
            }

            @Generated
            public Uint32 getNH() {
                return this.nH;
            }

            @Generated
            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            @Generated
            public void setBallot(SCPBallot ballot) {
                this.ballot = ballot;
            }

            @Generated
            public void setNPrepared(Uint32 nPrepared) {
                this.nPrepared = nPrepared;
            }

            @Generated
            public void setNCommit(Uint32 nCommit) {
                this.nCommit = nCommit;
            }

            @Generated
            public void setNH(Uint32 nH) {
                this.nH = nH;
            }

            @Generated
            public void setQuorumSetHash(Hash quorumSetHash) {
                this.quorumSetHash = quorumSetHash;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SCPStatementConfirm)) {
                    return false;
                }
                SCPStatementConfirm other = (SCPStatementConfirm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                SCPBallot this$ballot = this.getBallot();
                SCPBallot other$ballot = other.getBallot();
                if (this$ballot == null ? other$ballot != null : !((Object)this$ballot).equals(other$ballot)) {
                    return false;
                }
                Uint32 this$nPrepared = this.getNPrepared();
                Uint32 other$nPrepared = other.getNPrepared();
                if (this$nPrepared == null ? other$nPrepared != null : !((Object)this$nPrepared).equals(other$nPrepared)) {
                    return false;
                }
                Uint32 this$nCommit = this.getNCommit();
                Uint32 other$nCommit = other.getNCommit();
                if (this$nCommit == null ? other$nCommit != null : !((Object)this$nCommit).equals(other$nCommit)) {
                    return false;
                }
                Uint32 this$nH = this.getNH();
                Uint32 other$nH = other.getNH();
                if (this$nH == null ? other$nH != null : !((Object)this$nH).equals(other$nH)) {
                    return false;
                }
                Hash this$quorumSetHash = this.getQuorumSetHash();
                Hash other$quorumSetHash = other.getQuorumSetHash();
                return !(this$quorumSetHash == null ? other$quorumSetHash != null : !((Object)this$quorumSetHash).equals(other$quorumSetHash));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SCPStatementConfirm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                SCPBallot $ballot = this.getBallot();
                result = result * 59 + ($ballot == null ? 43 : ((Object)$ballot).hashCode());
                Uint32 $nPrepared = this.getNPrepared();
                result = result * 59 + ($nPrepared == null ? 43 : ((Object)$nPrepared).hashCode());
                Uint32 $nCommit = this.getNCommit();
                result = result * 59 + ($nCommit == null ? 43 : ((Object)$nCommit).hashCode());
                Uint32 $nH = this.getNH();
                result = result * 59 + ($nH == null ? 43 : ((Object)$nH).hashCode());
                Hash $quorumSetHash = this.getQuorumSetHash();
                result = result * 59 + ($quorumSetHash == null ? 43 : ((Object)$quorumSetHash).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SCPStatement.SCPStatementPledges.SCPStatementConfirm(ballot=" + this.getBallot() + ", nPrepared=" + this.getNPrepared() + ", nCommit=" + this.getNCommit() + ", nH=" + this.getNH() + ", quorumSetHash=" + this.getQuorumSetHash() + ")";
            }

            @Generated
            public SCPStatementConfirm() {
            }

            @Generated
            public SCPStatementConfirm(SCPBallot ballot, Uint32 nPrepared, Uint32 nCommit, Uint32 nH, Hash quorumSetHash) {
                this.ballot = ballot;
                this.nPrepared = nPrepared;
                this.nCommit = nCommit;
                this.nH = nH;
                this.quorumSetHash = quorumSetHash;
            }

            @Generated
            public static class SCPStatementConfirmBuilder {
                @Generated
                private SCPBallot ballot;
                @Generated
                private Uint32 nPrepared;
                @Generated
                private Uint32 nCommit;
                @Generated
                private Uint32 nH;
                @Generated
                private Hash quorumSetHash;

                @Generated
                SCPStatementConfirmBuilder() {
                }

                @Generated
                public SCPStatementConfirmBuilder ballot(SCPBallot ballot) {
                    this.ballot = ballot;
                    return this;
                }

                @Generated
                public SCPStatementConfirmBuilder nPrepared(Uint32 nPrepared) {
                    this.nPrepared = nPrepared;
                    return this;
                }

                @Generated
                public SCPStatementConfirmBuilder nCommit(Uint32 nCommit) {
                    this.nCommit = nCommit;
                    return this;
                }

                @Generated
                public SCPStatementConfirmBuilder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                @Generated
                public SCPStatementConfirmBuilder quorumSetHash(Hash quorumSetHash) {
                    this.quorumSetHash = quorumSetHash;
                    return this;
                }

                @Generated
                public SCPStatementConfirm build() {
                    return new SCPStatementConfirm(this.ballot, this.nPrepared, this.nCommit, this.nH, this.quorumSetHash);
                }

                @Generated
                public String toString() {
                    return "SCPStatement.SCPStatementPledges.SCPStatementConfirm.SCPStatementConfirmBuilder(ballot=" + this.ballot + ", nPrepared=" + this.nPrepared + ", nCommit=" + this.nCommit + ", nH=" + this.nH + ", quorumSetHash=" + this.quorumSetHash + ")";
                }
            }
        }

        public static class SCPStatementPrepare
        implements XdrElement {
            private Hash quorumSetHash;
            private SCPBallot ballot;
            private SCPBallot prepared;
            private SCPBallot preparedPrime;
            private Uint32 nC;
            private Uint32 nH;

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                this.quorumSetHash.encode(stream);
                this.ballot.encode(stream);
                if (this.prepared != null) {
                    stream.writeInt(1);
                    this.prepared.encode(stream);
                } else {
                    stream.writeInt(0);
                }
                if (this.preparedPrime != null) {
                    stream.writeInt(1);
                    this.preparedPrime.encode(stream);
                } else {
                    stream.writeInt(0);
                }
                this.nC.encode(stream);
                this.nH.encode(stream);
            }

            public static SCPStatementPrepare decode(XdrDataInputStream stream) throws IOException {
                int preparedPrimePresent;
                SCPStatementPrepare decodedSCPStatementPrepare = new SCPStatementPrepare();
                decodedSCPStatementPrepare.quorumSetHash = Hash.decode(stream);
                decodedSCPStatementPrepare.ballot = SCPBallot.decode(stream);
                int preparedPresent = stream.readInt();
                if (preparedPresent != 0) {
                    decodedSCPStatementPrepare.prepared = SCPBallot.decode(stream);
                }
                if ((preparedPrimePresent = stream.readInt()) != 0) {
                    decodedSCPStatementPrepare.preparedPrime = SCPBallot.decode(stream);
                }
                decodedSCPStatementPrepare.nC = Uint32.decode(stream);
                decodedSCPStatementPrepare.nH = Uint32.decode(stream);
                return decodedSCPStatementPrepare;
            }

            public static SCPStatementPrepare fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementPrepare.fromXdrByteArray(bytes);
            }

            public static SCPStatementPrepare fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementPrepare.decode(xdrDataInputStream);
            }

            @Generated
            public static SCPStatementPrepareBuilder builder() {
                return new SCPStatementPrepareBuilder();
            }

            @Generated
            public SCPStatementPrepareBuilder toBuilder() {
                return new SCPStatementPrepareBuilder().quorumSetHash(this.quorumSetHash).ballot(this.ballot).prepared(this.prepared).preparedPrime(this.preparedPrime).nC(this.nC).nH(this.nH);
            }

            @Generated
            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            @Generated
            public SCPBallot getBallot() {
                return this.ballot;
            }

            @Generated
            public SCPBallot getPrepared() {
                return this.prepared;
            }

            @Generated
            public SCPBallot getPreparedPrime() {
                return this.preparedPrime;
            }

            @Generated
            public Uint32 getNC() {
                return this.nC;
            }

            @Generated
            public Uint32 getNH() {
                return this.nH;
            }

            @Generated
            public void setQuorumSetHash(Hash quorumSetHash) {
                this.quorumSetHash = quorumSetHash;
            }

            @Generated
            public void setBallot(SCPBallot ballot) {
                this.ballot = ballot;
            }

            @Generated
            public void setPrepared(SCPBallot prepared) {
                this.prepared = prepared;
            }

            @Generated
            public void setPreparedPrime(SCPBallot preparedPrime) {
                this.preparedPrime = preparedPrime;
            }

            @Generated
            public void setNC(Uint32 nC) {
                this.nC = nC;
            }

            @Generated
            public void setNH(Uint32 nH) {
                this.nH = nH;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SCPStatementPrepare)) {
                    return false;
                }
                SCPStatementPrepare other = (SCPStatementPrepare)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Hash this$quorumSetHash = this.getQuorumSetHash();
                Hash other$quorumSetHash = other.getQuorumSetHash();
                if (this$quorumSetHash == null ? other$quorumSetHash != null : !((Object)this$quorumSetHash).equals(other$quorumSetHash)) {
                    return false;
                }
                SCPBallot this$ballot = this.getBallot();
                SCPBallot other$ballot = other.getBallot();
                if (this$ballot == null ? other$ballot != null : !((Object)this$ballot).equals(other$ballot)) {
                    return false;
                }
                SCPBallot this$prepared = this.getPrepared();
                SCPBallot other$prepared = other.getPrepared();
                if (this$prepared == null ? other$prepared != null : !((Object)this$prepared).equals(other$prepared)) {
                    return false;
                }
                SCPBallot this$preparedPrime = this.getPreparedPrime();
                SCPBallot other$preparedPrime = other.getPreparedPrime();
                if (this$preparedPrime == null ? other$preparedPrime != null : !((Object)this$preparedPrime).equals(other$preparedPrime)) {
                    return false;
                }
                Uint32 this$nC = this.getNC();
                Uint32 other$nC = other.getNC();
                if (this$nC == null ? other$nC != null : !((Object)this$nC).equals(other$nC)) {
                    return false;
                }
                Uint32 this$nH = this.getNH();
                Uint32 other$nH = other.getNH();
                return !(this$nH == null ? other$nH != null : !((Object)this$nH).equals(other$nH));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SCPStatementPrepare;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Hash $quorumSetHash = this.getQuorumSetHash();
                result = result * 59 + ($quorumSetHash == null ? 43 : ((Object)$quorumSetHash).hashCode());
                SCPBallot $ballot = this.getBallot();
                result = result * 59 + ($ballot == null ? 43 : ((Object)$ballot).hashCode());
                SCPBallot $prepared = this.getPrepared();
                result = result * 59 + ($prepared == null ? 43 : ((Object)$prepared).hashCode());
                SCPBallot $preparedPrime = this.getPreparedPrime();
                result = result * 59 + ($preparedPrime == null ? 43 : ((Object)$preparedPrime).hashCode());
                Uint32 $nC = this.getNC();
                result = result * 59 + ($nC == null ? 43 : ((Object)$nC).hashCode());
                Uint32 $nH = this.getNH();
                result = result * 59 + ($nH == null ? 43 : ((Object)$nH).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SCPStatement.SCPStatementPledges.SCPStatementPrepare(quorumSetHash=" + this.getQuorumSetHash() + ", ballot=" + this.getBallot() + ", prepared=" + this.getPrepared() + ", preparedPrime=" + this.getPreparedPrime() + ", nC=" + this.getNC() + ", nH=" + this.getNH() + ")";
            }

            @Generated
            public SCPStatementPrepare() {
            }

            @Generated
            public SCPStatementPrepare(Hash quorumSetHash, SCPBallot ballot, SCPBallot prepared, SCPBallot preparedPrime, Uint32 nC, Uint32 nH) {
                this.quorumSetHash = quorumSetHash;
                this.ballot = ballot;
                this.prepared = prepared;
                this.preparedPrime = preparedPrime;
                this.nC = nC;
                this.nH = nH;
            }

            @Generated
            public static class SCPStatementPrepareBuilder {
                @Generated
                private Hash quorumSetHash;
                @Generated
                private SCPBallot ballot;
                @Generated
                private SCPBallot prepared;
                @Generated
                private SCPBallot preparedPrime;
                @Generated
                private Uint32 nC;
                @Generated
                private Uint32 nH;

                @Generated
                SCPStatementPrepareBuilder() {
                }

                @Generated
                public SCPStatementPrepareBuilder quorumSetHash(Hash quorumSetHash) {
                    this.quorumSetHash = quorumSetHash;
                    return this;
                }

                @Generated
                public SCPStatementPrepareBuilder ballot(SCPBallot ballot) {
                    this.ballot = ballot;
                    return this;
                }

                @Generated
                public SCPStatementPrepareBuilder prepared(SCPBallot prepared) {
                    this.prepared = prepared;
                    return this;
                }

                @Generated
                public SCPStatementPrepareBuilder preparedPrime(SCPBallot preparedPrime) {
                    this.preparedPrime = preparedPrime;
                    return this;
                }

                @Generated
                public SCPStatementPrepareBuilder nC(Uint32 nC) {
                    this.nC = nC;
                    return this;
                }

                @Generated
                public SCPStatementPrepareBuilder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                @Generated
                public SCPStatementPrepare build() {
                    return new SCPStatementPrepare(this.quorumSetHash, this.ballot, this.prepared, this.preparedPrime, this.nC, this.nH);
                }

                @Generated
                public String toString() {
                    return "SCPStatement.SCPStatementPledges.SCPStatementPrepare.SCPStatementPrepareBuilder(quorumSetHash=" + this.quorumSetHash + ", ballot=" + this.ballot + ", prepared=" + this.prepared + ", preparedPrime=" + this.preparedPrime + ", nC=" + this.nC + ", nH=" + this.nH + ")";
                }
            }
        }
    }
}

