/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.SorobanCredentials;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAuthorizationEntry
implements XdrElement {
    private SorobanCredentials credentials;
    private SorobanAuthorizedInvocation rootInvocation;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.credentials.encode(stream);
        this.rootInvocation.encode(stream);
    }

    public static SorobanAuthorizationEntry decode(XdrDataInputStream stream) throws IOException {
        SorobanAuthorizationEntry decodedSorobanAuthorizationEntry = new SorobanAuthorizationEntry();
        decodedSorobanAuthorizationEntry.credentials = SorobanCredentials.decode(stream);
        decodedSorobanAuthorizationEntry.rootInvocation = SorobanAuthorizedInvocation.decode(stream);
        return decodedSorobanAuthorizationEntry;
    }

    public static SorobanAuthorizationEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAuthorizationEntry.fromXdrByteArray(bytes);
    }

    public static SorobanAuthorizationEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAuthorizationEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanAuthorizationEntryBuilder builder() {
        return new SorobanAuthorizationEntryBuilder();
    }

    @Generated
    public SorobanAuthorizationEntryBuilder toBuilder() {
        return new SorobanAuthorizationEntryBuilder().credentials(this.credentials).rootInvocation(this.rootInvocation);
    }

    @Generated
    public SorobanCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public SorobanAuthorizedInvocation getRootInvocation() {
        return this.rootInvocation;
    }

    @Generated
    public void setCredentials(SorobanCredentials credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setRootInvocation(SorobanAuthorizedInvocation rootInvocation) {
        this.rootInvocation = rootInvocation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanAuthorizationEntry)) {
            return false;
        }
        SorobanAuthorizationEntry other = (SorobanAuthorizationEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorobanCredentials this$credentials = this.getCredentials();
        SorobanCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        SorobanAuthorizedInvocation this$rootInvocation = this.getRootInvocation();
        SorobanAuthorizedInvocation other$rootInvocation = other.getRootInvocation();
        return !(this$rootInvocation == null ? other$rootInvocation != null : !((Object)this$rootInvocation).equals(other$rootInvocation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanAuthorizationEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorobanCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        SorobanAuthorizedInvocation $rootInvocation = this.getRootInvocation();
        result = result * 59 + ($rootInvocation == null ? 43 : ((Object)$rootInvocation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanAuthorizationEntry(credentials=" + this.getCredentials() + ", rootInvocation=" + this.getRootInvocation() + ")";
    }

    @Generated
    public SorobanAuthorizationEntry() {
    }

    @Generated
    public SorobanAuthorizationEntry(SorobanCredentials credentials, SorobanAuthorizedInvocation rootInvocation) {
        this.credentials = credentials;
        this.rootInvocation = rootInvocation;
    }

    @Generated
    public static class SorobanAuthorizationEntryBuilder {
        @Generated
        private SorobanCredentials credentials;
        @Generated
        private SorobanAuthorizedInvocation rootInvocation;

        @Generated
        SorobanAuthorizationEntryBuilder() {
        }

        @Generated
        public SorobanAuthorizationEntryBuilder credentials(SorobanCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public SorobanAuthorizationEntryBuilder rootInvocation(SorobanAuthorizedInvocation rootInvocation) {
            this.rootInvocation = rootInvocation;
            return this;
        }

        @Generated
        public SorobanAuthorizationEntry build() {
            return new SorobanAuthorizationEntry(this.credentials, this.rootInvocation);
        }

        @Generated
        public String toString() {
            return "SorobanAuthorizationEntry.SorobanAuthorizationEntryBuilder(credentials=" + this.credentials + ", rootInvocation=" + this.rootInvocation + ")";
        }
    }
}

