/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.TransactionEventStage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionEvent
implements XdrElement {
    private TransactionEventStage stage;
    private ContractEvent event;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.stage.encode(stream);
        this.event.encode(stream);
    }

    public static TransactionEvent decode(XdrDataInputStream stream) throws IOException {
        TransactionEvent decodedTransactionEvent = new TransactionEvent();
        decodedTransactionEvent.stage = TransactionEventStage.decode(stream);
        decodedTransactionEvent.event = ContractEvent.decode(stream);
        return decodedTransactionEvent;
    }

    public static TransactionEvent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionEvent.fromXdrByteArray(bytes);
    }

    public static TransactionEvent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionEvent.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionEventBuilder builder() {
        return new TransactionEventBuilder();
    }

    @Generated
    public TransactionEventBuilder toBuilder() {
        return new TransactionEventBuilder().stage(this.stage).event(this.event);
    }

    @Generated
    public TransactionEventStage getStage() {
        return this.stage;
    }

    @Generated
    public ContractEvent getEvent() {
        return this.event;
    }

    @Generated
    public void setStage(TransactionEventStage stage) {
        this.stage = stage;
    }

    @Generated
    public void setEvent(ContractEvent event) {
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionEvent)) {
            return false;
        }
        TransactionEvent other = (TransactionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionEventStage this$stage = this.getStage();
        TransactionEventStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
            return false;
        }
        ContractEvent this$event = this.getEvent();
        ContractEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionEventStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
        ContractEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionEvent(stage=" + this.getStage() + ", event=" + this.getEvent() + ")";
    }

    @Generated
    public TransactionEvent() {
    }

    @Generated
    public TransactionEvent(TransactionEventStage stage, ContractEvent event) {
        this.stage = stage;
        this.event = event;
    }

    @Generated
    public static class TransactionEventBuilder {
        @Generated
        private TransactionEventStage stage;
        @Generated
        private ContractEvent event;

        @Generated
        TransactionEventBuilder() {
        }

        @Generated
        public TransactionEventBuilder stage(TransactionEventStage stage) {
            this.stage = stage;
            return this;
        }

        @Generated
        public TransactionEventBuilder event(ContractEvent event) {
            this.event = event;
            return this;
        }

        @Generated
        public TransactionEvent build() {
            return new TransactionEvent(this.stage, this.event);
        }

        @Generated
        public String toString() {
            return "TransactionEvent.TransactionEventBuilder(stage=" + this.stage + ", event=" + this.event + ")";
        }
    }
}

