/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.TransactionMeta;
import org.stellar.sdk.xdr.TransactionResultPair;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResultMetaV1
implements XdrElement {
    private ExtensionPoint ext;
    private TransactionResultPair result;
    private LedgerEntryChanges feeProcessing;
    private TransactionMeta txApplyProcessing;
    private LedgerEntryChanges postTxApplyFeeProcessing;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.result.encode(stream);
        this.feeProcessing.encode(stream);
        this.txApplyProcessing.encode(stream);
        this.postTxApplyFeeProcessing.encode(stream);
    }

    public static TransactionResultMetaV1 decode(XdrDataInputStream stream) throws IOException {
        TransactionResultMetaV1 decodedTransactionResultMetaV1 = new TransactionResultMetaV1();
        decodedTransactionResultMetaV1.ext = ExtensionPoint.decode(stream);
        decodedTransactionResultMetaV1.result = TransactionResultPair.decode(stream);
        decodedTransactionResultMetaV1.feeProcessing = LedgerEntryChanges.decode(stream);
        decodedTransactionResultMetaV1.txApplyProcessing = TransactionMeta.decode(stream);
        decodedTransactionResultMetaV1.postTxApplyFeeProcessing = LedgerEntryChanges.decode(stream);
        return decodedTransactionResultMetaV1;
    }

    public static TransactionResultMetaV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResultMetaV1.fromXdrByteArray(bytes);
    }

    public static TransactionResultMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResultMetaV1.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionResultMetaV1Builder builder() {
        return new TransactionResultMetaV1Builder();
    }

    @Generated
    public TransactionResultMetaV1Builder toBuilder() {
        return new TransactionResultMetaV1Builder().ext(this.ext).result(this.result).feeProcessing(this.feeProcessing).txApplyProcessing(this.txApplyProcessing).postTxApplyFeeProcessing(this.postTxApplyFeeProcessing);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public TransactionResultPair getResult() {
        return this.result;
    }

    @Generated
    public LedgerEntryChanges getFeeProcessing() {
        return this.feeProcessing;
    }

    @Generated
    public TransactionMeta getTxApplyProcessing() {
        return this.txApplyProcessing;
    }

    @Generated
    public LedgerEntryChanges getPostTxApplyFeeProcessing() {
        return this.postTxApplyFeeProcessing;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setResult(TransactionResultPair result) {
        this.result = result;
    }

    @Generated
    public void setFeeProcessing(LedgerEntryChanges feeProcessing) {
        this.feeProcessing = feeProcessing;
    }

    @Generated
    public void setTxApplyProcessing(TransactionMeta txApplyProcessing) {
        this.txApplyProcessing = txApplyProcessing;
    }

    @Generated
    public void setPostTxApplyFeeProcessing(LedgerEntryChanges postTxApplyFeeProcessing) {
        this.postTxApplyFeeProcessing = postTxApplyFeeProcessing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResultMetaV1)) {
            return false;
        }
        TransactionResultMetaV1 other = (TransactionResultMetaV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        TransactionResultPair this$result = this.getResult();
        TransactionResultPair other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        LedgerEntryChanges this$feeProcessing = this.getFeeProcessing();
        LedgerEntryChanges other$feeProcessing = other.getFeeProcessing();
        if (this$feeProcessing == null ? other$feeProcessing != null : !((Object)this$feeProcessing).equals(other$feeProcessing)) {
            return false;
        }
        TransactionMeta this$txApplyProcessing = this.getTxApplyProcessing();
        TransactionMeta other$txApplyProcessing = other.getTxApplyProcessing();
        if (this$txApplyProcessing == null ? other$txApplyProcessing != null : !((Object)this$txApplyProcessing).equals(other$txApplyProcessing)) {
            return false;
        }
        LedgerEntryChanges this$postTxApplyFeeProcessing = this.getPostTxApplyFeeProcessing();
        LedgerEntryChanges other$postTxApplyFeeProcessing = other.getPostTxApplyFeeProcessing();
        return !(this$postTxApplyFeeProcessing == null ? other$postTxApplyFeeProcessing != null : !((Object)this$postTxApplyFeeProcessing).equals(other$postTxApplyFeeProcessing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResultMetaV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        TransactionResultPair $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        LedgerEntryChanges $feeProcessing = this.getFeeProcessing();
        result = result * 59 + ($feeProcessing == null ? 43 : ((Object)$feeProcessing).hashCode());
        TransactionMeta $txApplyProcessing = this.getTxApplyProcessing();
        result = result * 59 + ($txApplyProcessing == null ? 43 : ((Object)$txApplyProcessing).hashCode());
        LedgerEntryChanges $postTxApplyFeeProcessing = this.getPostTxApplyFeeProcessing();
        result = result * 59 + ($postTxApplyFeeProcessing == null ? 43 : ((Object)$postTxApplyFeeProcessing).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionResultMetaV1(ext=" + this.getExt() + ", result=" + this.getResult() + ", feeProcessing=" + this.getFeeProcessing() + ", txApplyProcessing=" + this.getTxApplyProcessing() + ", postTxApplyFeeProcessing=" + this.getPostTxApplyFeeProcessing() + ")";
    }

    @Generated
    public TransactionResultMetaV1() {
    }

    @Generated
    public TransactionResultMetaV1(ExtensionPoint ext, TransactionResultPair result, LedgerEntryChanges feeProcessing, TransactionMeta txApplyProcessing, LedgerEntryChanges postTxApplyFeeProcessing) {
        this.ext = ext;
        this.result = result;
        this.feeProcessing = feeProcessing;
        this.txApplyProcessing = txApplyProcessing;
        this.postTxApplyFeeProcessing = postTxApplyFeeProcessing;
    }

    @Generated
    public static class TransactionResultMetaV1Builder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private TransactionResultPair result;
        @Generated
        private LedgerEntryChanges feeProcessing;
        @Generated
        private TransactionMeta txApplyProcessing;
        @Generated
        private LedgerEntryChanges postTxApplyFeeProcessing;

        @Generated
        TransactionResultMetaV1Builder() {
        }

        @Generated
        public TransactionResultMetaV1Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public TransactionResultMetaV1Builder result(TransactionResultPair result) {
            this.result = result;
            return this;
        }

        @Generated
        public TransactionResultMetaV1Builder feeProcessing(LedgerEntryChanges feeProcessing) {
            this.feeProcessing = feeProcessing;
            return this;
        }

        @Generated
        public TransactionResultMetaV1Builder txApplyProcessing(TransactionMeta txApplyProcessing) {
            this.txApplyProcessing = txApplyProcessing;
            return this;
        }

        @Generated
        public TransactionResultMetaV1Builder postTxApplyFeeProcessing(LedgerEntryChanges postTxApplyFeeProcessing) {
            this.postTxApplyFeeProcessing = postTxApplyFeeProcessing;
            return this;
        }

        @Generated
        public TransactionResultMetaV1 build() {
            return new TransactionResultMetaV1(this.ext, this.result, this.feeProcessing, this.txApplyProcessing, this.postTxApplyFeeProcessing);
        }

        @Generated
        public String toString() {
            return "TransactionResultMetaV1.TransactionResultMetaV1Builder(ext=" + this.ext + ", result=" + this.result + ", feeProcessing=" + this.feeProcessing + ", txApplyProcessing=" + this.txApplyProcessing + ", postTxApplyFeeProcessing=" + this.postTxApplyFeeProcessing + ")";
        }
    }
}

