/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionSet
implements XdrElement {
    private Hash previousLedgerHash;
    private TransactionEnvelope[] txs;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.previousLedgerHash.encode(stream);
        int txsSize = this.getTxs().length;
        stream.writeInt(txsSize);
        for (int i = 0; i < txsSize; ++i) {
            this.txs[i].encode(stream);
        }
    }

    public static TransactionSet decode(XdrDataInputStream stream) throws IOException {
        TransactionSet decodedTransactionSet = new TransactionSet();
        decodedTransactionSet.previousLedgerHash = Hash.decode(stream);
        int txsSize = stream.readInt();
        decodedTransactionSet.txs = new TransactionEnvelope[txsSize];
        for (int i = 0; i < txsSize; ++i) {
            decodedTransactionSet.txs[i] = TransactionEnvelope.decode(stream);
        }
        return decodedTransactionSet;
    }

    public static TransactionSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionSet.fromXdrByteArray(bytes);
    }

    public static TransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionSet.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionSetBuilder builder() {
        return new TransactionSetBuilder();
    }

    @Generated
    public TransactionSetBuilder toBuilder() {
        return new TransactionSetBuilder().previousLedgerHash(this.previousLedgerHash).txs(this.txs);
    }

    @Generated
    public Hash getPreviousLedgerHash() {
        return this.previousLedgerHash;
    }

    @Generated
    public TransactionEnvelope[] getTxs() {
        return this.txs;
    }

    @Generated
    public void setPreviousLedgerHash(Hash previousLedgerHash) {
        this.previousLedgerHash = previousLedgerHash;
    }

    @Generated
    public void setTxs(TransactionEnvelope[] txs) {
        this.txs = txs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionSet)) {
            return false;
        }
        TransactionSet other = (TransactionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$previousLedgerHash = this.getPreviousLedgerHash();
        Hash other$previousLedgerHash = other.getPreviousLedgerHash();
        if (this$previousLedgerHash == null ? other$previousLedgerHash != null : !((Object)this$previousLedgerHash).equals(other$previousLedgerHash)) {
            return false;
        }
        return Arrays.deepEquals(this.getTxs(), other.getTxs());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $previousLedgerHash = this.getPreviousLedgerHash();
        result = result * 59 + ($previousLedgerHash == null ? 43 : ((Object)$previousLedgerHash).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTxs());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionSet(previousLedgerHash=" + this.getPreviousLedgerHash() + ", txs=" + Arrays.deepToString(this.getTxs()) + ")";
    }

    @Generated
    public TransactionSet() {
    }

    @Generated
    public TransactionSet(Hash previousLedgerHash, TransactionEnvelope[] txs) {
        this.previousLedgerHash = previousLedgerHash;
        this.txs = txs;
    }

    @Generated
    public static class TransactionSetBuilder {
        @Generated
        private Hash previousLedgerHash;
        @Generated
        private TransactionEnvelope[] txs;

        @Generated
        TransactionSetBuilder() {
        }

        @Generated
        public TransactionSetBuilder previousLedgerHash(Hash previousLedgerHash) {
            this.previousLedgerHash = previousLedgerHash;
            return this;
        }

        @Generated
        public TransactionSetBuilder txs(TransactionEnvelope[] txs) {
            this.txs = txs;
            return this;
        }

        @Generated
        public TransactionSet build() {
            return new TransactionSet(this.previousLedgerHash, this.txs);
        }

        @Generated
        public String toString() {
            return "TransactionSet.TransactionSetBuilder(previousLedgerHash=" + this.previousLedgerHash + ", txs=" + Arrays.deepToString(this.txs) + ")";
        }
    }
}

