/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionSignaturePayload
implements XdrElement {
    private Hash networkId;
    private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.networkId.encode(stream);
        this.taggedTransaction.encode(stream);
    }

    public static TransactionSignaturePayload decode(XdrDataInputStream stream) throws IOException {
        TransactionSignaturePayload decodedTransactionSignaturePayload = new TransactionSignaturePayload();
        decodedTransactionSignaturePayload.networkId = Hash.decode(stream);
        decodedTransactionSignaturePayload.taggedTransaction = TransactionSignaturePayloadTaggedTransaction.decode(stream);
        return decodedTransactionSignaturePayload;
    }

    public static TransactionSignaturePayload fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionSignaturePayload.fromXdrByteArray(bytes);
    }

    public static TransactionSignaturePayload fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionSignaturePayload.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionSignaturePayloadBuilder builder() {
        return new TransactionSignaturePayloadBuilder();
    }

    @Generated
    public TransactionSignaturePayloadBuilder toBuilder() {
        return new TransactionSignaturePayloadBuilder().networkId(this.networkId).taggedTransaction(this.taggedTransaction);
    }

    @Generated
    public Hash getNetworkId() {
        return this.networkId;
    }

    @Generated
    public TransactionSignaturePayloadTaggedTransaction getTaggedTransaction() {
        return this.taggedTransaction;
    }

    @Generated
    public void setNetworkId(Hash networkId) {
        this.networkId = networkId;
    }

    @Generated
    public void setTaggedTransaction(TransactionSignaturePayloadTaggedTransaction taggedTransaction) {
        this.taggedTransaction = taggedTransaction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionSignaturePayload)) {
            return false;
        }
        TransactionSignaturePayload other = (TransactionSignaturePayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$networkId = this.getNetworkId();
        Hash other$networkId = other.getNetworkId();
        if (this$networkId == null ? other$networkId != null : !((Object)this$networkId).equals(other$networkId)) {
            return false;
        }
        TransactionSignaturePayloadTaggedTransaction this$taggedTransaction = this.getTaggedTransaction();
        TransactionSignaturePayloadTaggedTransaction other$taggedTransaction = other.getTaggedTransaction();
        return !(this$taggedTransaction == null ? other$taggedTransaction != null : !((Object)this$taggedTransaction).equals(other$taggedTransaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionSignaturePayload;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : ((Object)$networkId).hashCode());
        TransactionSignaturePayloadTaggedTransaction $taggedTransaction = this.getTaggedTransaction();
        result = result * 59 + ($taggedTransaction == null ? 43 : ((Object)$taggedTransaction).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionSignaturePayload(networkId=" + this.getNetworkId() + ", taggedTransaction=" + this.getTaggedTransaction() + ")";
    }

    @Generated
    public TransactionSignaturePayload() {
    }

    @Generated
    public TransactionSignaturePayload(Hash networkId, TransactionSignaturePayloadTaggedTransaction taggedTransaction) {
        this.networkId = networkId;
        this.taggedTransaction = taggedTransaction;
    }

    @Generated
    public static class TransactionSignaturePayloadBuilder {
        @Generated
        private Hash networkId;
        @Generated
        private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

        @Generated
        TransactionSignaturePayloadBuilder() {
        }

        @Generated
        public TransactionSignaturePayloadBuilder networkId(Hash networkId) {
            this.networkId = networkId;
            return this;
        }

        @Generated
        public TransactionSignaturePayloadBuilder taggedTransaction(TransactionSignaturePayloadTaggedTransaction taggedTransaction) {
            this.taggedTransaction = taggedTransaction;
            return this;
        }

        @Generated
        public TransactionSignaturePayload build() {
            return new TransactionSignaturePayload(this.networkId, this.taggedTransaction);
        }

        @Generated
        public String toString() {
            return "TransactionSignaturePayload.TransactionSignaturePayloadBuilder(networkId=" + this.networkId + ", taggedTransaction=" + this.taggedTransaction + ")";
        }
    }

    public static class TransactionSignaturePayloadTaggedTransaction
    implements XdrElement {
        private EnvelopeType discriminant;
        private Transaction tx;
        private FeeBumpTransaction feeBump;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case ENVELOPE_TYPE_TX: {
                    this.tx.encode(stream);
                    break;
                }
                case ENVELOPE_TYPE_TX_FEE_BUMP: {
                    this.feeBump.encode(stream);
                }
            }
        }

        public static TransactionSignaturePayloadTaggedTransaction decode(XdrDataInputStream stream) throws IOException {
            TransactionSignaturePayloadTaggedTransaction decodedTransactionSignaturePayloadTaggedTransaction = new TransactionSignaturePayloadTaggedTransaction();
            EnvelopeType discriminant = EnvelopeType.decode(stream);
            decodedTransactionSignaturePayloadTaggedTransaction.setDiscriminant(discriminant);
            switch (decodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
                case ENVELOPE_TYPE_TX: {
                    decodedTransactionSignaturePayloadTaggedTransaction.tx = Transaction.decode(stream);
                    break;
                }
                case ENVELOPE_TYPE_TX_FEE_BUMP: {
                    decodedTransactionSignaturePayloadTaggedTransaction.feeBump = FeeBumpTransaction.decode(stream);
                }
            }
            return decodedTransactionSignaturePayloadTaggedTransaction;
        }

        public static TransactionSignaturePayloadTaggedTransaction fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionSignaturePayloadTaggedTransaction.fromXdrByteArray(bytes);
        }

        public static TransactionSignaturePayloadTaggedTransaction fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionSignaturePayloadTaggedTransaction.decode(xdrDataInputStream);
        }

        @Generated
        public static TransactionSignaturePayloadTaggedTransactionBuilder builder() {
            return new TransactionSignaturePayloadTaggedTransactionBuilder();
        }

        @Generated
        public TransactionSignaturePayloadTaggedTransactionBuilder toBuilder() {
            return new TransactionSignaturePayloadTaggedTransactionBuilder().discriminant(this.discriminant).tx(this.tx).feeBump(this.feeBump);
        }

        @Generated
        public EnvelopeType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public Transaction getTx() {
            return this.tx;
        }

        @Generated
        public FeeBumpTransaction getFeeBump() {
            return this.feeBump;
        }

        @Generated
        public void setDiscriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setTx(Transaction tx) {
            this.tx = tx;
        }

        @Generated
        public void setFeeBump(FeeBumpTransaction feeBump) {
            this.feeBump = feeBump;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionSignaturePayloadTaggedTransaction)) {
                return false;
            }
            TransactionSignaturePayloadTaggedTransaction other = (TransactionSignaturePayloadTaggedTransaction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnvelopeType this$discriminant = this.getDiscriminant();
            EnvelopeType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            Transaction this$tx = this.getTx();
            Transaction other$tx = other.getTx();
            if (this$tx == null ? other$tx != null : !((Object)this$tx).equals(other$tx)) {
                return false;
            }
            FeeBumpTransaction this$feeBump = this.getFeeBump();
            FeeBumpTransaction other$feeBump = other.getFeeBump();
            return !(this$feeBump == null ? other$feeBump != null : !((Object)this$feeBump).equals(other$feeBump));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionSignaturePayloadTaggedTransaction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EnvelopeType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            Transaction $tx = this.getTx();
            result = result * 59 + ($tx == null ? 43 : ((Object)$tx).hashCode());
            FeeBumpTransaction $feeBump = this.getFeeBump();
            result = result * 59 + ($feeBump == null ? 43 : ((Object)$feeBump).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction(discriminant=" + this.getDiscriminant() + ", tx=" + this.getTx() + ", feeBump=" + this.getFeeBump() + ")";
        }

        @Generated
        public TransactionSignaturePayloadTaggedTransaction() {
        }

        @Generated
        public TransactionSignaturePayloadTaggedTransaction(EnvelopeType discriminant, Transaction tx, FeeBumpTransaction feeBump) {
            this.discriminant = discriminant;
            this.tx = tx;
            this.feeBump = feeBump;
        }

        @Generated
        public static class TransactionSignaturePayloadTaggedTransactionBuilder {
            @Generated
            private EnvelopeType discriminant;
            @Generated
            private Transaction tx;
            @Generated
            private FeeBumpTransaction feeBump;

            @Generated
            TransactionSignaturePayloadTaggedTransactionBuilder() {
            }

            @Generated
            public TransactionSignaturePayloadTaggedTransactionBuilder discriminant(EnvelopeType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public TransactionSignaturePayloadTaggedTransactionBuilder tx(Transaction tx) {
                this.tx = tx;
                return this;
            }

            @Generated
            public TransactionSignaturePayloadTaggedTransactionBuilder feeBump(FeeBumpTransaction feeBump) {
                this.feeBump = feeBump;
                return this;
            }

            @Generated
            public TransactionSignaturePayloadTaggedTransaction build() {
                return new TransactionSignaturePayloadTaggedTransaction(this.discriminant, this.tx, this.feeBump);
            }

            @Generated
            public String toString() {
                return "TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction.TransactionSignaturePayloadTaggedTransactionBuilder(discriminant=" + this.discriminant + ", tx=" + this.tx + ", feeBump=" + this.feeBump + ")";
            }
        }
    }
}

