// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AssetCode's original definition in the XDR file is:
 *
 * <pre>
 * union AssetCode switch (AssetType type)
 * {
 * case ASSET_TYPE_CREDIT_ALPHANUM4:
 *     AssetCode4 assetCode4;
 *
 * case ASSET_TYPE_CREDIT_ALPHANUM12:
 *     AssetCode12 assetCode12;
 *
 *     // add other asset types here in the future
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AssetCode implements XdrElement {
  private AssetType discriminant;
  private AssetCode4 assetCode4;
  private AssetCode12 assetCode12;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        assetCode4.encode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        assetCode12.encode(stream);
        break;
    }
  }

  public static AssetCode decode(XdrDataInputStream stream) throws IOException {
    AssetCode decodedAssetCode = new AssetCode();
    AssetType discriminant = AssetType.decode(stream);
    decodedAssetCode.setDiscriminant(discriminant);
    switch (decodedAssetCode.getDiscriminant()) {
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        decodedAssetCode.assetCode4 = AssetCode4.decode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        decodedAssetCode.assetCode12 = AssetCode12.decode(stream);
        break;
    }
    return decodedAssetCode;
  }

  public static AssetCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AssetCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
