// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ConfigUpgradeSet's original definition in the XDR file is:
 *
 * <pre>
 * struct ConfigUpgradeSet {
 *     ConfigSettingEntry updatedEntry&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ConfigUpgradeSet implements XdrElement {
  private ConfigSettingEntry[] updatedEntry;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int updatedEntrySize = getUpdatedEntry().length;
    stream.writeInt(updatedEntrySize);
    for (int i = 0; i < updatedEntrySize; i++) {
      updatedEntry[i].encode(stream);
    }
  }

  public static ConfigUpgradeSet decode(XdrDataInputStream stream) throws IOException {
    ConfigUpgradeSet decodedConfigUpgradeSet = new ConfigUpgradeSet();
    int updatedEntrySize = stream.readInt();
    decodedConfigUpgradeSet.updatedEntry = new ConfigSettingEntry[updatedEntrySize];
    for (int i = 0; i < updatedEntrySize; i++) {
      decodedConfigUpgradeSet.updatedEntry[i] = ConfigSettingEntry.decode(stream);
    }
    return decodedConfigUpgradeSet;
  }

  public static ConfigUpgradeSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ConfigUpgradeSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
