// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * CreateContractArgsV2's original definition in the XDR file is:
 *
 * <pre>
 * struct CreateContractArgsV2
 * {
 *     ContractIDPreimage contractIDPreimage;
 *     ContractExecutable executable;
 *     // Arguments of the contract's constructor.
 *     SCVal constructorArgs&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class CreateContractArgsV2 implements XdrElement {
  private ContractIDPreimage contractIDPreimage;
  private ContractExecutable executable;
  private SCVal[] constructorArgs;

  public void encode(XdrDataOutputStream stream) throws IOException {
    contractIDPreimage.encode(stream);
    executable.encode(stream);
    int constructorArgsSize = getConstructorArgs().length;
    stream.writeInt(constructorArgsSize);
    for (int i = 0; i < constructorArgsSize; i++) {
      constructorArgs[i].encode(stream);
    }
  }

  public static CreateContractArgsV2 decode(XdrDataInputStream stream) throws IOException {
    CreateContractArgsV2 decodedCreateContractArgsV2 = new CreateContractArgsV2();
    decodedCreateContractArgsV2.contractIDPreimage = ContractIDPreimage.decode(stream);
    decodedCreateContractArgsV2.executable = ContractExecutable.decode(stream);
    int constructorArgsSize = stream.readInt();
    decodedCreateContractArgsV2.constructorArgs = new SCVal[constructorArgsSize];
    for (int i = 0; i < constructorArgsSize; i++) {
      decodedCreateContractArgsV2.constructorArgs[i] = SCVal.decode(stream);
    }
    return decodedCreateContractArgsV2;
  }

  public static CreateContractArgsV2 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static CreateContractArgsV2 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
