// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * ErrorCode's original definition in the XDR file is:
 *
 * <pre>
 * enum ErrorCode
 * {
 *     ERR_MISC = 0, // Unspecific error
 *     ERR_DATA = 1, // Malformed data
 *     ERR_CONF = 2, // Misconfiguration error
 *     ERR_AUTH = 3, // Authentication failure
 *     ERR_LOAD = 4  // System overloaded
 * };
 * </pre>
 */
public enum ErrorCode implements XdrElement {
  ERR_MISC(0),
  ERR_DATA(1),
  ERR_CONF(2),
  ERR_AUTH(3),
  ERR_LOAD(4);

  private final int value;

  ErrorCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ErrorCode decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return ERR_MISC;
      case 1:
        return ERR_DATA;
      case 2:
        return ERR_CONF;
      case 3:
        return ERR_AUTH;
      case 4:
        return ERR_LOAD;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static ErrorCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ErrorCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
