// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Int128Parts's original definition in the XDR file is:
 *
 * <pre>
 * struct Int128Parts {
 *     int64 hi;
 *     uint64 lo;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Int128Parts implements XdrElement {
  private Int64 hi;
  private Uint64 lo;

  public void encode(XdrDataOutputStream stream) throws IOException {
    hi.encode(stream);
    lo.encode(stream);
  }

  public static Int128Parts decode(XdrDataInputStream stream) throws IOException {
    Int128Parts decodedInt128Parts = new Int128Parts();
    decodedInt128Parts.hi = Int64.decode(stream);
    decodedInt128Parts.lo = Uint64.decode(stream);
    return decodedInt128Parts;
  }

  public static Int128Parts fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Int128Parts fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
