// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ManageDataResult's original definition in the XDR file is:
 *
 * <pre>
 * union ManageDataResult switch (ManageDataResultCode code)
 * {
 * case MANAGE_DATA_SUCCESS:
 *     void;
 * case MANAGE_DATA_NOT_SUPPORTED_YET:
 * case MANAGE_DATA_NAME_NOT_FOUND:
 * case MANAGE_DATA_LOW_RESERVE:
 * case MANAGE_DATA_INVALID_NAME:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ManageDataResult implements XdrElement {
  private ManageDataResultCode discriminant;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case MANAGE_DATA_SUCCESS:
        break;
      case MANAGE_DATA_NOT_SUPPORTED_YET:
      case MANAGE_DATA_NAME_NOT_FOUND:
      case MANAGE_DATA_LOW_RESERVE:
      case MANAGE_DATA_INVALID_NAME:
        break;
    }
  }

  public static ManageDataResult decode(XdrDataInputStream stream) throws IOException {
    ManageDataResult decodedManageDataResult = new ManageDataResult();
    ManageDataResultCode discriminant = ManageDataResultCode.decode(stream);
    decodedManageDataResult.setDiscriminant(discriminant);
    switch (decodedManageDataResult.getDiscriminant()) {
      case MANAGE_DATA_SUCCESS:
        break;
      case MANAGE_DATA_NOT_SUPPORTED_YET:
      case MANAGE_DATA_NAME_NOT_FOUND:
      case MANAGE_DATA_LOW_RESERVE:
      case MANAGE_DATA_INVALID_NAME:
        break;
    }
    return decodedManageDataResult;
  }

  public static ManageDataResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ManageDataResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
