// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * MessageType's original definition in the XDR file is:
 *
 * <pre>
 * enum MessageType
 * {
 *     ERROR_MSG = 0,
 *     AUTH = 2,
 *     DONT_HAVE = 3,
 *     // GET_PEERS (4) is deprecated
 *
 *     PEERS = 5,
 *
 *     GET_TX_SET = 6, // gets a particular txset by hash
 *     TX_SET = 7,
 *     GENERALIZED_TX_SET = 17,
 *
 *     TRANSACTION = 8, // pass on a tx you have heard about
 *
 *     // SCP
 *     GET_SCP_QUORUMSET = 9,
 *     SCP_QUORUMSET = 10,
 *     SCP_MESSAGE = 11,
 *     GET_SCP_STATE = 12,
 *
 *     // new messages
 *     HELLO = 13,
 *
 *     // SURVEY_REQUEST (14) removed and replaced by TIME_SLICED_SURVEY_REQUEST
 *     // SURVEY_RESPONSE (15) removed and replaced by TIME_SLICED_SURVEY_RESPONSE
 *
 *     SEND_MORE = 16,
 *     SEND_MORE_EXTENDED = 20,
 *
 *     FLOOD_ADVERT = 18,
 *     FLOOD_DEMAND = 19,
 *
 *     TIME_SLICED_SURVEY_REQUEST = 21,
 *     TIME_SLICED_SURVEY_RESPONSE = 22,
 *     TIME_SLICED_SURVEY_START_COLLECTING = 23,
 *     TIME_SLICED_SURVEY_STOP_COLLECTING = 24
 * };
 * </pre>
 */
public enum MessageType implements XdrElement {
  ERROR_MSG(0),
  AUTH(2),
  DONT_HAVE(3),
  PEERS(5),
  GET_TX_SET(6),
  TX_SET(7),
  GENERALIZED_TX_SET(17),
  TRANSACTION(8),
  GET_SCP_QUORUMSET(9),
  SCP_QUORUMSET(10),
  SCP_MESSAGE(11),
  GET_SCP_STATE(12),
  HELLO(13),
  SEND_MORE(16),
  SEND_MORE_EXTENDED(20),
  FLOOD_ADVERT(18),
  FLOOD_DEMAND(19),
  TIME_SLICED_SURVEY_REQUEST(21),
  TIME_SLICED_SURVEY_RESPONSE(22),
  TIME_SLICED_SURVEY_START_COLLECTING(23),
  TIME_SLICED_SURVEY_STOP_COLLECTING(24);

  private final int value;

  MessageType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static MessageType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return ERROR_MSG;
      case 2:
        return AUTH;
      case 3:
        return DONT_HAVE;
      case 5:
        return PEERS;
      case 6:
        return GET_TX_SET;
      case 7:
        return TX_SET;
      case 17:
        return GENERALIZED_TX_SET;
      case 8:
        return TRANSACTION;
      case 9:
        return GET_SCP_QUORUMSET;
      case 10:
        return SCP_QUORUMSET;
      case 11:
        return SCP_MESSAGE;
      case 12:
        return GET_SCP_STATE;
      case 13:
        return HELLO;
      case 16:
        return SEND_MORE;
      case 20:
        return SEND_MORE_EXTENDED;
      case 18:
        return FLOOD_ADVERT;
      case 19:
        return FLOOD_DEMAND;
      case 21:
        return TIME_SLICED_SURVEY_REQUEST;
      case 22:
        return TIME_SLICED_SURVEY_RESPONSE;
      case 23:
        return TIME_SLICED_SURVEY_START_COLLECTING;
      case 24:
        return TIME_SLICED_SURVEY_STOP_COLLECTING;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static MessageType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static MessageType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
