// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PathPaymentStrictReceiveResult's original definition in the XDR file is:
 *
 * <pre>
 * union PathPaymentStrictReceiveResult switch (
 *     PathPaymentStrictReceiveResultCode code)
 * {
 * case PATH_PAYMENT_STRICT_RECEIVE_SUCCESS:
 *     struct
 *     {
 *         ClaimAtom offers&lt;&gt;;
 *         SimplePaymentResult last;
 *     } success;
 * case PATH_PAYMENT_STRICT_RECEIVE_MALFORMED:
 * case PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED:
 * case PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST:
 * case PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED:
 * case PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION:
 * case PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST:
 * case PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED:
 * case PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL:
 *     void;
 * case PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER:
 *     Asset noIssuer; // the asset that caused the error
 * case PATH_PAYMENT_STRICT_RECEIVE_TOO_FEW_OFFERS:
 * case PATH_PAYMENT_STRICT_RECEIVE_OFFER_CROSS_SELF:
 * case PATH_PAYMENT_STRICT_RECEIVE_OVER_SENDMAX:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PathPaymentStrictReceiveResult implements XdrElement {
  private PathPaymentStrictReceiveResultCode discriminant;
  private PathPaymentStrictReceiveResultSuccess success;
  private Asset noIssuer;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case PATH_PAYMENT_STRICT_RECEIVE_SUCCESS:
        success.encode(stream);
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_MALFORMED:
      case PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED:
      case PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST:
      case PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED:
      case PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION:
      case PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST:
      case PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED:
      case PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL:
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER:
        noIssuer.encode(stream);
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_TOO_FEW_OFFERS:
      case PATH_PAYMENT_STRICT_RECEIVE_OFFER_CROSS_SELF:
      case PATH_PAYMENT_STRICT_RECEIVE_OVER_SENDMAX:
        break;
    }
  }

  public static PathPaymentStrictReceiveResult decode(XdrDataInputStream stream)
      throws IOException {
    PathPaymentStrictReceiveResult decodedPathPaymentStrictReceiveResult =
        new PathPaymentStrictReceiveResult();
    PathPaymentStrictReceiveResultCode discriminant =
        PathPaymentStrictReceiveResultCode.decode(stream);
    decodedPathPaymentStrictReceiveResult.setDiscriminant(discriminant);
    switch (decodedPathPaymentStrictReceiveResult.getDiscriminant()) {
      case PATH_PAYMENT_STRICT_RECEIVE_SUCCESS:
        decodedPathPaymentStrictReceiveResult.success =
            PathPaymentStrictReceiveResultSuccess.decode(stream);
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_MALFORMED:
      case PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED:
      case PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST:
      case PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED:
      case PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION:
      case PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST:
      case PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED:
      case PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL:
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER:
        decodedPathPaymentStrictReceiveResult.noIssuer = Asset.decode(stream);
        break;
      case PATH_PAYMENT_STRICT_RECEIVE_TOO_FEW_OFFERS:
      case PATH_PAYMENT_STRICT_RECEIVE_OFFER_CROSS_SELF:
      case PATH_PAYMENT_STRICT_RECEIVE_OVER_SENDMAX:
        break;
    }
    return decodedPathPaymentStrictReceiveResult;
  }

  public static PathPaymentStrictReceiveResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PathPaymentStrictReceiveResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * PathPaymentStrictReceiveResultSuccess's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         ClaimAtom offers&lt;&gt;;
   *         SimplePaymentResult last;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class PathPaymentStrictReceiveResultSuccess implements XdrElement {
    private ClaimAtom[] offers;
    private SimplePaymentResult last;

    public void encode(XdrDataOutputStream stream) throws IOException {
      int offersSize = getOffers().length;
      stream.writeInt(offersSize);
      for (int i = 0; i < offersSize; i++) {
        offers[i].encode(stream);
      }
      last.encode(stream);
    }

    public static PathPaymentStrictReceiveResultSuccess decode(XdrDataInputStream stream)
        throws IOException {
      PathPaymentStrictReceiveResultSuccess decodedPathPaymentStrictReceiveResultSuccess =
          new PathPaymentStrictReceiveResultSuccess();
      int offersSize = stream.readInt();
      decodedPathPaymentStrictReceiveResultSuccess.offers = new ClaimAtom[offersSize];
      for (int i = 0; i < offersSize; i++) {
        decodedPathPaymentStrictReceiveResultSuccess.offers[i] = ClaimAtom.decode(stream);
      }
      decodedPathPaymentStrictReceiveResultSuccess.last = SimplePaymentResult.decode(stream);
      return decodedPathPaymentStrictReceiveResultSuccess;
    }

    public static PathPaymentStrictReceiveResultSuccess fromXdrBase64(String xdr)
        throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictReceiveResultSuccess fromXdrByteArray(byte[] xdr)
        throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
