// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCMap's original definition in the XDR file is:
 *
 * <pre>
 * typedef SCMapEntry SCMap&lt;&gt;;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SCMap implements XdrElement {
  private SCMapEntry[] SCMap;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int SCMapSize = getSCMap().length;
    stream.writeInt(SCMapSize);
    for (int i = 0; i < SCMapSize; i++) {
      SCMap[i].encode(stream);
    }
  }

  public static SCMap decode(XdrDataInputStream stream) throws IOException {
    SCMap decodedSCMap = new SCMap();
    int SCMapSize = stream.readInt();
    decodedSCMap.SCMap = new SCMapEntry[SCMapSize];
    for (int i = 0; i < SCMapSize; i++) {
      decodedSCMap.SCMap[i] = SCMapEntry.decode(stream);
    }
    return decodedSCMap;
  }

  public static SCMap fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCMap fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
