// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanTransactionMeta's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanTransactionMeta
 * {
 *     SorobanTransactionMetaExt ext;
 *
 *     ContractEvent events&lt;&gt;;             // custom events populated by the
 *                                         // contracts themselves.
 *     SCVal returnValue;                  // return value of the host fn invocation
 *
 *     // Diagnostics events that are not hashed.
 *     // This will contain all contract and diagnostic events. Even ones
 *     // that were emitted in a failed contract call.
 *     DiagnosticEvent diagnosticEvents&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanTransactionMeta implements XdrElement {
  private SorobanTransactionMetaExt ext;
  private ContractEvent[] events;
  private SCVal returnValue;
  private DiagnosticEvent[] diagnosticEvents;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    int eventsSize = getEvents().length;
    stream.writeInt(eventsSize);
    for (int i = 0; i < eventsSize; i++) {
      events[i].encode(stream);
    }
    returnValue.encode(stream);
    int diagnosticEventsSize = getDiagnosticEvents().length;
    stream.writeInt(diagnosticEventsSize);
    for (int i = 0; i < diagnosticEventsSize; i++) {
      diagnosticEvents[i].encode(stream);
    }
  }

  public static SorobanTransactionMeta decode(XdrDataInputStream stream) throws IOException {
    SorobanTransactionMeta decodedSorobanTransactionMeta = new SorobanTransactionMeta();
    decodedSorobanTransactionMeta.ext = SorobanTransactionMetaExt.decode(stream);
    int eventsSize = stream.readInt();
    decodedSorobanTransactionMeta.events = new ContractEvent[eventsSize];
    for (int i = 0; i < eventsSize; i++) {
      decodedSorobanTransactionMeta.events[i] = ContractEvent.decode(stream);
    }
    decodedSorobanTransactionMeta.returnValue = SCVal.decode(stream);
    int diagnosticEventsSize = stream.readInt();
    decodedSorobanTransactionMeta.diagnosticEvents = new DiagnosticEvent[diagnosticEventsSize];
    for (int i = 0; i < diagnosticEventsSize; i++) {
      decodedSorobanTransactionMeta.diagnosticEvents[i] = DiagnosticEvent.decode(stream);
    }
    return decodedSorobanTransactionMeta;
  }

  public static SorobanTransactionMeta fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanTransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
