/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.contract;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Account;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.SorobanServer;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.contract.AssembledTransaction;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.xdr.SCVal;

public class ContractClient
implements Closeable {
    private final String contractId;
    private final Network network;
    private final SorobanServer server;

    public ContractClient(String contractId, String rpcUrl, Network network) {
        this.contractId = contractId;
        this.network = network;
        this.server = new SorobanServer(rpcUrl);
    }

    public <T> AssembledTransaction<T> invoke(String functionName, List<SCVal> parameters, String source2, KeyPair signer, Function<SCVal, T> parseResultXdrFn, int baseFee) {
        return this.invoke(functionName, parameters, source2, signer, parseResultXdrFn, baseFee, 300, 30, true, true);
    }

    public <T> AssembledTransaction<T> invoke(String functionName, Collection<SCVal> parameters, String source2, @Nullable KeyPair signer, @Nullable Function<SCVal, T> parseResultXdrFn, int baseFee, int transactionTimeout, int submitTimeout, boolean simulate, boolean restore) {
        TransactionBuilder builder = new TransactionBuilder(new Account(source2, 0L), this.network).addOperation(InvokeHostFunctionOperation.invokeContractFunctionOperationBuilder(this.contractId, functionName, parameters).build()).setTimeout(transactionTimeout).setBaseFee(baseFee);
        AssembledTransaction<T> assembled = new AssembledTransaction<T>(builder, this.server, signer, parseResultXdrFn, submitTimeout);
        if (simulate) {
            assembled = assembled.simulate(restore);
        }
        return assembled;
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }
}

