/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests.sorobanrpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.stellar.sdk.requests.sorobanrpc.EventFilterType;

public final class GetEventsRequest {
    private final Long startLedger;
    private final Collection<EventFilter> filters;
    private final PaginationOptions pagination;

    @Generated
    GetEventsRequest(Long startLedger, Collection<EventFilter> filters, PaginationOptions pagination) {
        this.startLedger = startLedger;
        this.filters = filters;
        this.pagination = pagination;
    }

    @Generated
    public static GetEventsRequestBuilder builder() {
        return new GetEventsRequestBuilder();
    }

    @Generated
    public GetEventsRequestBuilder toBuilder() {
        GetEventsRequestBuilder builder = new GetEventsRequestBuilder().startLedger(this.startLedger).pagination(this.pagination);
        if (this.filters != null) {
            builder.filters(this.filters);
        }
        return builder;
    }

    @Generated
    public Long getStartLedger() {
        return this.startLedger;
    }

    @Generated
    public Collection<EventFilter> getFilters() {
        return this.filters;
    }

    @Generated
    public PaginationOptions getPagination() {
        return this.pagination;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEventsRequest)) {
            return false;
        }
        GetEventsRequest other = (GetEventsRequest)o;
        Long this$startLedger = this.getStartLedger();
        Long other$startLedger = other.getStartLedger();
        if (this$startLedger == null ? other$startLedger != null : !((Object)this$startLedger).equals(other$startLedger)) {
            return false;
        }
        Collection<EventFilter> this$filters = this.getFilters();
        Collection<EventFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        PaginationOptions this$pagination = this.getPagination();
        PaginationOptions other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startLedger = this.getStartLedger();
        result = result * 59 + ($startLedger == null ? 43 : ((Object)$startLedger).hashCode());
        Collection<EventFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        PaginationOptions $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetEventsRequest(startLedger=" + this.getStartLedger() + ", filters=" + this.getFilters() + ", pagination=" + this.getPagination() + ")";
    }

    @Generated
    public static class GetEventsRequestBuilder {
        @Generated
        private Long startLedger;
        @Generated
        private ArrayList<EventFilter> filters;
        @Generated
        private PaginationOptions pagination;

        @Generated
        GetEventsRequestBuilder() {
        }

        @Generated
        public GetEventsRequestBuilder startLedger(Long startLedger) {
            this.startLedger = startLedger;
            return this;
        }

        @Generated
        public GetEventsRequestBuilder filter(EventFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        @Generated
        public GetEventsRequestBuilder filters(Collection<? extends EventFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("filters cannot be null");
            }
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        @Generated
        public GetEventsRequestBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        @Generated
        public GetEventsRequestBuilder pagination(PaginationOptions pagination) {
            this.pagination = pagination;
            return this;
        }

        @Generated
        public GetEventsRequest build() {
            List<EventFilter> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<EventFilter>(this.filters));
                }
            }
            return new GetEventsRequest(this.startLedger, filters, this.pagination);
        }

        @Generated
        public String toString() {
            return "GetEventsRequest.GetEventsRequestBuilder(startLedger=" + this.startLedger + ", filters=" + this.filters + ", pagination=" + this.pagination + ")";
        }
    }

    public static final class EventFilter {
        private final EventFilterType type;
        private final Collection<String> contractIds;
        private final Collection<Collection<String>> topics;

        @Generated
        EventFilter(EventFilterType type, Collection<String> contractIds, Collection<Collection<String>> topics) {
            this.type = type;
            this.contractIds = contractIds;
            this.topics = topics;
        }

        @Generated
        public static EventFilterBuilder builder() {
            return new EventFilterBuilder();
        }

        @Generated
        public EventFilterBuilder toBuilder() {
            EventFilterBuilder builder = new EventFilterBuilder().type(this.type).contractIds(this.contractIds);
            if (this.topics != null) {
                builder.topics(this.topics);
            }
            return builder;
        }

        @Generated
        public EventFilterType getType() {
            return this.type;
        }

        @Generated
        public Collection<String> getContractIds() {
            return this.contractIds;
        }

        @Generated
        public Collection<Collection<String>> getTopics() {
            return this.topics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventFilter)) {
                return false;
            }
            EventFilter other = (EventFilter)o;
            EventFilterType this$type = this.getType();
            EventFilterType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Collection<String> this$contractIds = this.getContractIds();
            Collection<String> other$contractIds = other.getContractIds();
            if (this$contractIds == null ? other$contractIds != null : !((Object)this$contractIds).equals(other$contractIds)) {
                return false;
            }
            Collection<Collection<String>> this$topics = this.getTopics();
            Collection<Collection<String>> other$topics = other.getTopics();
            return !(this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EventFilterType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Collection<String> $contractIds = this.getContractIds();
            result = result * 59 + ($contractIds == null ? 43 : ((Object)$contractIds).hashCode());
            Collection<Collection<String>> $topics = this.getTopics();
            result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetEventsRequest.EventFilter(type=" + (Object)((Object)this.getType()) + ", contractIds=" + this.getContractIds() + ", topics=" + this.getTopics() + ")";
        }

        @Generated
        public static class EventFilterBuilder {
            @Generated
            private EventFilterType type;
            @Generated
            private Collection<String> contractIds;
            @Generated
            private ArrayList<Collection<String>> topics;

            @Generated
            EventFilterBuilder() {
            }

            @Generated
            public EventFilterBuilder type(EventFilterType type) {
                this.type = type;
                return this;
            }

            @Generated
            public EventFilterBuilder contractIds(Collection<String> contractIds) {
                this.contractIds = contractIds;
                return this;
            }

            @Generated
            public EventFilterBuilder topic(Collection<String> topic) {
                if (this.topics == null) {
                    this.topics = new ArrayList();
                }
                this.topics.add(topic);
                return this;
            }

            @Generated
            public EventFilterBuilder topics(Collection<? extends Collection<String>> topics) {
                if (topics == null) {
                    throw new NullPointerException("topics cannot be null");
                }
                if (this.topics == null) {
                    this.topics = new ArrayList();
                }
                this.topics.addAll(topics);
                return this;
            }

            @Generated
            public EventFilterBuilder clearTopics() {
                if (this.topics != null) {
                    this.topics.clear();
                }
                return this;
            }

            @Generated
            public EventFilter build() {
                List<Collection<String>> topics;
                switch (this.topics == null ? 0 : this.topics.size()) {
                    case 0: {
                        topics = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        topics = Collections.singletonList(this.topics.get(0));
                        break;
                    }
                    default: {
                        topics = Collections.unmodifiableList(new ArrayList<Collection<String>>(this.topics));
                    }
                }
                return new EventFilter(this.type, this.contractIds, topics);
            }

            @Generated
            public String toString() {
                return "GetEventsRequest.EventFilter.EventFilterBuilder(type=" + (Object)((Object)this.type) + ", contractIds=" + this.contractIds + ", topics=" + this.topics + ")";
            }
        }
    }

    public static final class PaginationOptions {
        private final Long limit;
        private final String cursor;

        @Generated
        PaginationOptions(Long limit, String cursor) {
            this.limit = limit;
            this.cursor = cursor;
        }

        @Generated
        public static PaginationOptionsBuilder builder() {
            return new PaginationOptionsBuilder();
        }

        @Generated
        public PaginationOptionsBuilder toBuilder() {
            return new PaginationOptionsBuilder().limit(this.limit).cursor(this.cursor);
        }

        @Generated
        public Long getLimit() {
            return this.limit;
        }

        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginationOptions)) {
                return false;
            }
            PaginationOptions other = (PaginationOptions)o;
            Long this$limit = this.getLimit();
            Long other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetEventsRequest.PaginationOptions(limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
        }

        @Generated
        public static class PaginationOptionsBuilder {
            @Generated
            private Long limit;
            @Generated
            private String cursor;

            @Generated
            PaginationOptionsBuilder() {
            }

            @Generated
            public PaginationOptionsBuilder limit(Long limit) {
                this.limit = limit;
                return this;
            }

            @Generated
            public PaginationOptionsBuilder cursor(String cursor) {
                this.cursor = cursor;
                return this;
            }

            @Generated
            public PaginationOptions build() {
                return new PaginationOptions(this.limit, this.cursor);
            }

            @Generated
            public String toString() {
                return "GetEventsRequest.PaginationOptions.PaginationOptionsBuilder(limit=" + this.limit + ", cursor=" + this.cursor + ")";
            }
        }
    }
}

